package com.mx.dla.dda.contrato.transaccion.terminos.bos;

import java.io.IOException;
import java.sql.SQLException;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.ExcepcionesSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.MinimoGarantizadoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PrecioRentaDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PremiumDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.RevenueSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.SeccionesTerminos;
import com.mx.dla.global.bos.BaseBO;

@Service
public class TerminosPremium extends BaseBO{

	@Autowired
	private TerminosMinimos minimos;
	
	@Autowired
	private TerminosRelease release;
	
	@Autowired	
	@Qualifier("precioPremium")
	private TerminosPrecio precio;
	
	@Autowired
	private TerminosRevenue revenue;
	
	@Autowired
	private TerminosExcepciones excepciones;
		
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = TransaccionException.class)
	public PremiumDTO obtenerPremium(Long idContrato) throws ResultMapException, SQLException, TransaccionException{
		PremiumDTO premium = new PremiumDTO();
		
		try
		{
			MinimoGarantizadoDTO minimo  = minimos.obtenerMinimos(idContrato, SeccionesTerminos.RentaPremium.getDesc());			
			String[][] releasesDatos     = release.obtenerRelease(idContrato, SeccionesTerminos.RentaPremium.getDesc());
			PrecioRentaDTO   precioDTO   = precio.obtenerPrecio  (releasesDatos, idContrato, SeccionesTerminos.RentaPremium.getDesc());
			RevenueSeccionDTO revenueDTO = revenue.obtenerRevenue(idContrato, SeccionesTerminos.RentaPremium.getDesc(), releasesDatos);
			ExcepcionesSeccionDTO excepcionesDTO = excepciones.obtenerExcepciones(idContrato, SeccionesTerminos.RentaPremium.getDesc());
			
			premium.setMinimos(minimo);
			premium.setRelease(releasesDatos);
			premium.setPrecio(precioDTO);
			premium.setRevenue(revenueDTO);		
			premium.setExcepciones(excepcionesDTO);
			
						
		} catch (PersistenceException e) {
			new TransaccionException("Error al obtener terminos premium.", e);
		} catch (DataAccessException e) {
			new TransaccionException("Error al obtener terminos premium.", e);
		}							
		return premium;		
	}
	
	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = TransaccionException.class)
	public void guardarPremium(PremiumDTO p, Long idContrato) throws JsonParseException, JsonMappingException, IOException, TransaccionException{
		
		try
		{
			logger.debug(p.toString());
			precio.eliminarPaisesImpuestoEstatus(idContrato, SeccionesTerminos.RentaPremium.getDesc());
			precio.eliminarPreciosPremium(idContrato, SeccionesTerminos.RentaPremium.getDesc());
			revenue.eliminarRevenue(idContrato, SeccionesTerminos.RentaPremium.getDesc());
			excepciones.eliminarExcepcion(idContrato, SeccionesTerminos.RentaPremium.getDesc());

			minimos.guardarMinimos(p.getMinimos().getMinimosCateg(), p.getMinimos().getMinimosAnio(), p.getMinimos().getAnios(), p.getMinimos().getTipoMin(), SeccionesTerminos.RentaPremium.getDesc(), idContrato);
			release.guardarRelease(p.getRelease(), idContrato, SeccionesTerminos.RentaPremium.getDesc());
			
			precio.actualizarPrecioAplica(idContrato, SeccionesTerminos.RentaPremium.getDesc(), p.getPrecio().getAplica());
			precio.actualizarPagoPpe(idContrato, SeccionesTerminos.RentaPremium.getDesc(), p.getPrecio().getPagoPPE());

			if(p.getPrecio().getAplica().intValue() == 1)
			   precio.guardarDatosPrecios(p.getPrecio(), release.getIds(), idContrato, SeccionesTerminos.RentaPremium.getDesc());			
				
			revenue.guardarRevenue(idContrato, SeccionesTerminos.RentaPremium.getDesc(), release.getIds(), p.getRevenue());
			excepciones.guardarExcepciones(idContrato, SeccionesTerminos.RentaPremium.getDesc(), p.getExcepciones());
		} catch (PersistenceException e) {
			new TransaccionException("Error al obtener terminos premium.", e);
		} catch (DataAccessException e) {
			new TransaccionException("Error al obtener terminos premium.", e);
		} catch (SQLException e) {
			new TransaccionException("Error al obtener terminos premium.", e);
		}
		
	}
	
}
