package com.mx.dla.dda.factura.listado.actions;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.struts2.ServletActionContext;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.bos.CatalogosBO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.factura.listado.bos.FacturaListadoBO;
import com.mx.dla.dda.factura.listado.dtos.FacturaListadoPantalla;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionContext;

public class FacturaListadoAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private List<FacturaListadoPantalla> listadoFacturas;
	private List<EstudioDTO> estudios;
	private String numeroFact;
	private Long idFactura;
	private Integer operacion;
	private String msgError;
	private String msgExito;
	private String jsonRequest;

	@Autowired
	private FacturaListadoBO facturaListadoBO;

	@Autowired
	private CatalogosBO catalogosBO;

	public String execute() {
		ObjectMapper mapper = new ObjectMapper();

		try {

			estudios = mapper.readValue(jsonRequest,
					mapper.getTypeFactory().constructCollectionType(List.class, EstudioDTO.class));
			numeroFact = numeroFact.compareTo("") == 0 ? null : numeroFact;

			List<Integer> ids = new ArrayList<Integer>();
			for (EstudioDTO item : estudios)
				ids.add(item.getIdEstudio().intValue());

			logger.info("size es:" + ids.size());

			listadoFacturas = facturaListadoBO.getListadoFacturas(ids, numeroFact);

		} catch (PersistenceException e) {
			this.msgError = "Error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", e);
		} catch (JsonParseException e) {
			this.msgError = "Error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", e);
		} catch (JsonMappingException e) {
			this.msgError = "Error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", e);
		} catch (IOException e) {
			this.msgError = "Error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", e);
		}

		return Action.SUCCESS;
	}

	public String operacionListado() {
		// identificdor operacion 1:nuevo, 2:editar, 3: ver, 4: eliminar
		String paramValue = ServletActionContext.getRequest().getParameter("pmn");
		this.getSession().put("pmn", paramValue);
		this.getSession().put("pmnReturn", ServletActionContext.getRequest().getParameter("pmnReturn"));

		try {

			if (operacion.intValue() == 1 || operacion.intValue() == 2 || operacion.intValue() == 3) {
				if (operacion == 1)
					ActionContext.getContext().getSession().put("idFactura", null);
				else
					ActionContext.getContext().getSession().put("idFactura", String.valueOf(idFactura));
				return "operacion";
			}
			if (operacion.intValue() == 4) {
				facturaListadoBO.eliminarListadoFactura(idFactura);
				this.msgExito = "Los datos han sido eliminados.";
			}

		} catch (PersistenceException ibe) {
			this.msgError = "Error al obtener los datos.";
			logger.error("Error en [" + this.getClass() + "]", ibe);

		}

		return Action.SUCCESS;
	}

	public String obtenerEstudios() {

		try {
			estudios = catalogosBO.obtenListaEstudios();
		} catch (PersistenceException ibe) {
			this.msgError = "Error al realizar el proceso.";
			logger.error("Error en [" + this.getClass() + "]", ibe);
		} catch (SQLException e) {
			this.msgError = "Error al realizar el proceso.";
			logger.error("Error en [" + this.getClass() + "]", e);
		} catch (TransaccionException e) {
			this.msgError = "Error al realizar el proceso.";
			logger.error("Error en [" + this.getClass() + "]", e);
		}
		return Action.SUCCESS;
	}

	public List<FacturaListadoPantalla> getListadoFacturas() {
		return listadoFacturas;
	}

	public void setEstudios(List<EstudioDTO> estudios) {
		this.estudios = estudios;
	}

	public List<EstudioDTO> getEstudios() {
		return estudios;
	}

	public void setNumeroFact(String numeroFact) {
		this.numeroFact = numeroFact;
	}

	public void setIdFactura(Long idFactura) {
		this.idFactura = idFactura;
	}

	public String getMsgError() {
		return msgError;
	}

	public String getMsgExito() {
		return msgExito;
	}

	public void setOperacion(Integer operacion) {
		this.operacion = operacion;
	}

	public void setJsonRequest(String jsonRequest) {
		this.jsonRequest = jsonRequest;
	}

}
