function crearDivBono() {
	var divBono = $("<div/>").attr('id', "divBono").addClass("row bono");
	var divBonoCheck = $("<div/>").attr('id', "divBonoCheck").addClass("row");
	var divBonoInfo = $("<div/>").attr('id', "divBonoInfo ").addClass("row");

	divBonoCheck.append(crearDivHtml("<label><input id='checkMostrarBono' type='checkbox' onclick='mostrarBono()'> Bono Por Suscriptores</label>", "6"));
	divBonoCheck.append(crearDivHtml("<label id='mostrarLab'><input id='checkVisBono' type='checkbox' onclick='visualizarBono()'>  Mostrar Bono</label>", "4"));
	divBono.append("<br><br>").append(divBonoCheck);

	divBono.append(divBonoInfo);
	divBono.append("<br><br>").append(crearTablaBono("false"));
	divBono.append("<br>");
	return divBono;
}

function crearTablaBono(oculto) {
	var tabla = $("<table/>").attr('id', "tablaBono").attr("oculto", oculto).addClass("bono");

	if (edoCto == 1)
		var encabezado = "<thead><tr class='encabezado'>" +
			"<th>Desde</th><th>Hasta</th><th>Bono [$]</th><th>Tipo Pago</th>" +
			"<th style='background:white'><label><span data-bs-toggle='tooltip' title='Agregar Bono' class='ui-icon ui-icon-plus' "
			+ "onclick='agregarFilaTablaBono(null)'></span></label></th>" +
			"</tr><thead/>";
	else
		var encabezado = "<thead><tr class='encabezado'>" +
			"<th>Desde</th><th>Hasta</th><th>Bono [$]</th><th>Tipo Pago</th>" +
			"<th style='background:white'></th>" +
			"</tr><thead/>";

	tabla.append(encabezado).append($("<tbody/>"));
	return tabla;
}

function mostrarBono() {
	var valor = $("#checkMostrarBono").prop('checked');
	if (valor) {
		$("#divBono > div:last").show();
		$("#divBono table").show();
		$("#divBono input[id='checkVisBono']").prop('checked', true).show();
		$("#divBono label[id='mostrarLab']").show();
	}
	else {
		$("#divBono > div:last").hide();
		$("#divBono table").hide();
		$("#divBono input[id='checkVisBono']").prop('checked', false).hide();
		$("#divBono label[id='mostrarLab']").hide();
	}
}

function visualizarBono() {
	var valor = $("#divBono input[id='checkVisBono']").prop('checked');
	if (valor) {
		$("#divBono > div:last").show();
		$("#divBono table").show();
	}
	else {
		$("#divBono > div:last").hide();
		$("#divBono table").hide();
	}
}

function llenarDatosFlatBono(data) {
	if (data != null && data.rangos.length > 0) {
		agregarFilaTablaBono(data.rangos);
		$("#checkMostrarBono").prop('checked', true).show();
		$("#checkVisBono").prop('checked', true);
		$("#mostrarLab").show();
	}
	else {
		$("#checkMostrarBono").prop('checked', false).show();
		$("#checkVisBono").prop('checked', false);
		$("#mostrarLab").hide();
		$("#divBono > div:last").hide();
		$("#divBono table").hide();
		agregarFilaTablaBono(null);
	}

}

function agregarFilaTablaBono(rangos) {
	if (rangos == null) {
		var idBono = nuevoBono--;
		var filaMontos = $("<tr/>").attr("id", idBono);
		filaMontos.append(createTdThTabla(1, "", true, null, 1));
		filaMontos.append(createTdThTabla(1, "", true, null, 1));
		filaMontos.append(createTdThTabla(1, "", true, null, 1));
		filaMontos.append($("<td width='100'/>").append(crearComboTipoPagoBono("0")));
		filaMontos.append("<th><label class='mensaje'/><label><span data-bs-toggle='tooltip' title='Eliminar'  onclick='eliminarFila(null," + idBono + ",2)'  class='ui-icon ui-icon-close'></span></label></th>");
		$("#tablaBono").append(filaMontos);
	}
	else {
		for (var i = 0; i < rangos.length; i++) {
			var filaMontos = $("<tr/>").attr("id", rangos[i].idRango);
			filaMontos.append(createTdThTabla(1, formatCurrency(Number(unformatCurrency(rangos[i].desde)), 0), true, null, 1));
			filaMontos.append(createTdThTabla(1, formatCurrency(Number(unformatCurrency(rangos[i].hasta)), 0), true, null, 1));
			filaMontos.append(createTdThTabla(1, formatCurrency(Number(unformatCurrency(rangos[i].bono)), 2), true, null, 1));
			filaMontos.append($("<td width='100'/>").append(crearComboTipoPagoBono(rangos[i].tipoPago)));
			if (edoCto == 1)
				filaMontos.append("<th><label class='mensaje'/><label><span data-bs-toggle='tooltip' title='Eliminar'  onclick='eliminarFila(null," + rangos[i].idRango + ",2)'  class='ui-icon ui-icon-close'></span></label></th>");
			else
				filaMontos.append("<th></th>");
			$("#tablaBono").append(filaMontos);
		}
	}
	bindingInputValoresBono();
}

function bindingInputValoresBono() {

	$("table.bono tr").each(function() {
		var valido = false;
		var cate = $(this);
		$(this).find("td:nth-child(1) input").change(function() {
			var valor = Number(unformatCurrency($(this).val()))
			if (!validaNumero(valor))
				showError("El valor ingresado no es un numero.");
			else
				$(this).val(formatCurrency(valor, 0));
		});

		$(this).find("td:nth-child(2) input").change(function() {
			var valor = Number(unformatCurrency($(this).val()))
			if (!validaNumero(valor))
				showError("El valor ingresado no es un numero.");
			else
				$(this).val(formatCurrency(valor, 0));
		});

		$(this).find("td:nth-child(3) input").change(function() {
			var valor = $(this).val();
			valor = Number(unformatCurrency(valor));
			if (!validaNumero(valor))
				showError("El valor ingresado no es un numero.");
			else
				$(this).val(formatCurrency(valor, 2));
		});

	});
}

function llenarBono(bono) {
	llenarDatosFlatBono(bono);
	bindingInputValoresBono();
}

function obtenerBono() {
	var valor = $("#checkMostrarBono").prop('checked');
	var bonoSuscriptor = { rangos: null };
	if (valor) {
		var rangos = [];
		$("table.bono tbody tr").each(function() {
			var tds = $(this).find("td input");
			var rango = {
				"bono": unformatCurrency(tds[2].value),
				"desde": unformatCurrency(tds[0].value),
				"hasta": unformatCurrency(tds[1].value),
				"tipoPago": $(this).find("select").val(),
				"idRango": $(this).attr("id")
			};
			rangos.push(rango);
		});
		bonoSuscriptor.rangos = rangos;
	}

	if (validacionForma && valor)
		validacionForma = validarBono(bonoSuscriptor, validacionForma);

	return bonoSuscriptor;
}

function validarBono(bono, valido) {
	if (valido && bono.rangos != null) {
		if (valido) {
			for (var i = 0; i < bono.rangos.length; i++) {
				var resultado = validaRangosBono(bono.rangos[i]);
				if (valido)
					valido = resultado.validacion;
				if (!resultado.validacion)
					$("table.bono tr[id='" + bono.rangos[i].idRango + "']").find("label.mensaje").text(resultado.mensaje).show();
				else
					$("table.bono tr[id='" + bono.rangos[i].idRango + "']").find("label.mensaje").hide();
			}
		}
	}

	if (valido) {
		var resultado = validaRangosBonoConsecutivos(bono);
		valido = resultado.validacion;
		if (!valido)
			showError(resultado.mensaje);
	}
	else
		showError("Revisar los datos.");
	return valido;
}

function crearComboTipoPagoBono(tipo) {
	var selectSusc = $("<select/>").addClass("form-control");
	selectSusc.append('<option value="0">Selecciona</option>');
	selectSusc.append('<option value="INICIO">Inicio</option>');
	selectSusc.append('<option value="FIN">Fin</option>');
	selectSusc.append('<option value="Mes">Mes</option>');
	selectSusc.val(tipo);
	return selectSusc;
}