var tituloController;
var idLista;
var titulosContratados;
var listasValidas;

$().ready(function() {
	tituloController = new TituloController();
});

function TituloController() {
	//Se inicializa los permisos de la pantalla
	this.inicializarPerfil();

	this.service = new TituloService();

	//Se inicializa modales y formularios
	this.formManager = new FormManager();
	this.componentesGenerales();

	//Se inicializa la tabla
	this.grid = new TituloGrid("tituloGird");
	this.cargaTitulosInicial();

	//Se inicializa objeto para subir archivo
	this.uploader = new UploaderEX("cargaTitulosDiv", this.onUpload, this.grid);
};

TituloController.prototype.inicializarPerfil = function() {
	$('div[id="divBotonesTitulo"] button').prop("disabled", true);
	$('#bBusqueda').prop("disabled", false);
	var perfil = new PerfilController();
	perfil.ejecutarPerfil(parseInt($("#pmn").val()));
}

TituloController.prototype.reloadGrid = function() {
	this.grid.reload();
}

TituloController.prototype.buscarLista = function() {
	idLista = 0;
	idLista = $("#idListaSel").val();
	this.activarFuncionalidad(idLista, listasValidas);
	this.cargaTitulosInicial();
}

TituloController.prototype.inicializarModalFechas = function(modal) {

	$("#id" + modal + " [name=hvrd]").datepicker();
	$("#id" + modal + " [name=fechaFin]").datepicker("option", "minDate", null);
	$("#id" + modal + " [name=fechaInicio]").datepicker("option", "maxDate", null);

	$("#id" + modal + " [name=fechaInicio]").datepicker('option', 'onClose', function(selectedDate) {
		$("#id" + modal + " [name=fechaFin]").datepicker("option", "minDate", selectedDate);
	});

	$("#id" + modal + " [name=fechaFin]").datepicker('option', 'onClose', function(selectedDate) {
		$("#id" + modal + " [name=fechaInicio]").datepicker("option", "maxDate", selectedDate);
	});
}

TituloController.prototype.validacionesEditarTitulos = function() {
	var mensaje = null;

	if (mensaje == null) {
		if ($("#filial").val() == "0")
			mensaje = "Se debe seleccionar una filial.";
	}

	if (mensaje == null) {
		if ($("#categoria").val() == "0")
			mensaje = "Se debe seleccionar al menos una categor\u00EDa.";
	}


	if ($("input[name='duracion']").val() != "") {
		if (!isNaN($("input[name='duracion']").val()) && $("input[name='duracion']").val() != "") {
			if (parseInt($("input[name='duracion']").val()) > 250)
				mensaje = "La duraci\u00F3n debe ser menos a 250 min.";
		}
		else
			mensaje = "La duraci\u00F3n debe ser un campo n\u00FAmerico.";
	}

	if (mensaje == null) {
		var today = new Date();
		var year = today.getFullYear();

		if ($("input[name='anio']").val() != "") {
			if (!isNaN($("input[name='anio']").val())) {
				var anio = parseInt($("input[name='anio']").val());
				if (anio > (year + 5) && (year - 5) < anio)
					mensaje = "El año debe ser un +/- 5 años al año actual.";
			}
			else
				mensaje = "El año debe ser un campo numerico.";
		}
	}

	if (mensaje == null) {
		if ($("input.formatos:checked").length == 0)
			mensaje = "Se debe seleccionar al menos un formato SD, HD o 3D.";
	}

	if (mensaje == null) {
		if (!$("input:radio[name='tipoTitulo']").is(":checked"))
			mensaje = "Se debe seleccionar al menos una categoria DTR o DTO.";
	}

	if (mensaje == null) {
		if ($("input:radio[name='tipoTitulo']:checked").attr('id') == "dto") {
			if ($("#tier").val() == "0" && $("#categoriaSerie").val() == "0")
				mensaje = "Se debe seleccionar al menos un valor para categoria DTO.";

			if ($("#tier").val() != "0" && $("#categoriaSerie").val() != "0")
				mensaje = "Se debe seleccionar solo un valor para categoria DTO.";
		}

	}

	if (mensaje == null) {
		if ($("input:radio[name='tipoTitulo']:checked").attr('id') == "dtr") {
			if ($("#categoriaDTR").val() == "0")
				mensaje = "Se debe seleccionar al menos un valor para categoria DTR.";
		}
	}

	if (mensaje != null)
		$("#errorEditForm").text(mensaje).show();
	else
		$("#errorEditForm").text(mensaje).hide();
	return mensaje;
}

TituloController.prototype.validacionesCambioMultipleTitulos = function(operacion) {
	var mensaje = null;

	$("#" + operacion + "Label").text(mensaje).hide();
	if (operacion == "CATEGORIA") {
		if ($("#categoriaV").val() == "0")
			mensaje = "Se debe seleccionar al menos una categor\u00EDa.";
	}

	if (operacion == "CATEGORIADTO") {
		if ($("#tierV").val() == "0" && $("#categoriaSerieV").val() == "0")
			mensaje = "Se debe seleccionar al menos un valor para categoria DTO.";

		if (mensaje == null && $("#tierV").val() != "0" && $("#categoriaSerieV").val() != "0")
			mensaje = "Se debe seleccionar solo un valor para categoria DTO.";
	}

	var valido = true;
	if (mensaje != null) {
		$("#" + operacion + "Label").text(mensaje).show();
		valido = false;
	}
	return valido;
}

TituloController.prototype.componentesGenerales = function() {
	this.formManager.initForm("idEditForm", {
		rules: {
			"idBv": { required: true, digits: true, maxlength: 12 },
			"nombreUnico": { required: true, maxlength: 150 },
			"nombreEstandar": { required: true, maxlength: 150 },

			"temporada": { maxlength: 10, digits: true },
			"episodio": { maxlength: 10, digits: true },

			"fechaInicio": { required: true },
			"fechaFin": { required: true },
			"boxOffice": { number: true },

			"duracion": { digits: true, maxlength: 250 },
			"anio": { digits: true, maxlength: 4 },
			"nombreEnEspaniol": { maxlength: 150 },
			"nombreEnIngles": { maxlength: 150 },
			"nombreEnPortugues": { maxlength: 150 }
		}
	});

	this.formManager.initForm("idEliminar");
	this.formManager.initForm("idCategoriaForm");
	this.formManager.initForm("idCategoriaDTRForm");
	this.formManager.initForm("idCategoriaDTOForm");
	this.formManager.initForm("idVentanaForm");

	catalogos = this.service.obtenerCatalogos();

	idLista = catalogos.idLista;
	titulosContratados = catalogos.numTitulos;
	listasValidas = catalogos.listasValidas;
	this.activarFuncionalidad(idLista, listasValidas);

	this.inicializarSelectVal("idListaSel", catalogos.listas);
	this.inicializarSelect("tier", catalogos.tiers);
	this.inicializarSelect("tierV", catalogos.tiers);
	this.inicializarSelect("categoriaSerie", catalogos.catSeries);
	this.inicializarSelect("categoriaSerieV", catalogos.catSeries);
	this.inicializarSelect("genero", catalogos.generosA);
	this.inicializarSelect("generoB", catalogos.generosB);
	this.inicializarSelect("filial", catalogos.filiales);
	this.inicializarSelect("categoria", catalogos.categorias);
	this.inicializarSelect("categoriaV", catalogos.categorias);
	$("#idListaSel").val(idLista);
};

TituloController.prototype.activarFuncionalidad = function(idLista, listas) {

	var encontrado = false;
	for (var i = 0; i < listas.length; i++) {
		if (listas[i] == idLista) {
			encontrado = true;
			$('div[id="divBotonesTitulo"] button').prop("disabled", true);
			$('#bBusqueda').prop("disabled", false);
			var perfil = new PerfilController();
			perfil.ejecutarPerfil(parseInt($("#pmn").val()));
		}
	}

	if (!encontrado) {
		$('div[id="divBotonesTitulo"] button').prop("disabled", true);
		$('#bBusqueda').prop("disabled", false);
	}
};

TituloController.prototype.inicializarSelect = function(nombre, elementos) {

	$("#" + nombre).append($('<option>', { value: "0", text: "Selecciona" }));

	for (var i = 0; i < elementos.length; i++)
		$("#" + nombre).append($('<option>', {
			value: elementos[i].desc,
			text: elementos[i].desc
		}));
};

TituloController.prototype.inicializarSelectVal = function(nombre, elementos) {

	$("#" + nombre).append($('<option>', { value: "0", text: "Selecciona" }));

	for (var i = 0; i < elementos.length; i++)
		$("#" + nombre).append($('<option>', {
			value: elementos[i].value,
			text: elementos[i].desc
		}));
};

TituloController.prototype.open = function(operacion, obj) {

	if (operacion == "guardar") {
		var titulo = {
			idTituloCnt: null, filial: null, idBv: null, nombreUnico: null, nombreEstandar: null,
			categoria: null, temporada: null, episodio: null, fechaFin: null, fechaInicio: null,
			hvdr: null, boxOffice: null, tier: null, categoriaDTO: null, briefcase: null,
			dtr: null, dto: null, sd: null, hd: null, tresd: null,
			duracion: null, anio: null, genero: null, generoB: null, idFila: null,
			categoriaSerie: null
		};
		this.abrirModal("EditForm", titulo);
	}

	if (operacion == "editar") {
		var titulo = this.grid.itemsSelected();
		if (titulo.length == 1 && titulo[0] != null)
			this.abrirModal("EditForm", titulo[0]);
		else
			showError("Debe seleccionar un registro");
	}

	if (operacion == "eliminar") {
		var titulo = this.grid.itemsSelected();
		if (titulo.length == 1 && titulo[0] != null) {
			$(".descTituloElim").html(titulo[0].nombreUnico);
			this.abrirModal("Eliminar", titulo[0]);
		}
		else
			showError("Debe seleccionar un registro");
	}
};

TituloController.prototype.abrirModal = function(modal, titulo) {
	$("Label.labModal").hide();
	this.inicializarModalFechas(modal);
	this.formManager.limpiarForma("id" + modal);
	this.formManager.llenarForma(titulo, "id" + modal, this.grid.getColumns());
	this.formManager.mapCheckToRadio(["dto", "dtr"], "tipoTitulo", titulo, "id" + modal);

	$('#modal' + modal).modal('show');
};

TituloController.prototype.alta = function() {

	if ($("#idEditForm").valid() && this.validacionesEditarTitulos() == null) {
		var me = this;
		var titulo = this.formManager.leerForma('idEditForm', this.grid.getColumns());
		console.log(titulo);
		this.formManager.mapRadioToCheck("tipoTitulo", ["dto", "dtr"], titulo);
		console.log(titulo);

		if (titulo.categoriaDTR == "0")
			titulo.categoriaDTR = null;

		if (titulo.categoriaSerie == "0")
			titulo.categoriaSerie = null;

		if (titulo.tier == "0")
			titulo.tier = null;

		$("#errorEditForm").hide();

		if (titulo.idTituloCnt == null) {
			this.service.guardarTitulo(titulo, idLista, function(resultado) {			
				if (resultado.error != null)
					$("#errorEditForm").text(resultado.error).show();
				else {
					me.cargaTitulosInicial();
					showMessage("Datos guardados correctamente");
					$('#modalEditForm').modal('hide');
				}
			});

		}
		else {
			this.service.editarTitulo(titulo, idLista, function(resultado) {
				if (resultado.error != null)
					$("#errorEditForm").text(resultado.error).show();
				else {
					me.cargaTitulosInicial();
					showMessage("Datos guardados correctamente");
					$('#modalEditForm').modal('hide');
				}
			});
		}
	}
};

TituloController.prototype.baja = function() {
	var modal = 'Eliminar';
	if ($("#id" + modal).valid()) {
		var me = this;
		var a = this.formManager.leerForma("id" + modal, this.grid.getColumns());

		this.service.eliminarTitulo(a, function() {
			showMessage("Datos guardados correctamente");
			me.cargaTitulosInicial();
		});
		$('#modal' + modal).modal('hide');
	}
};

TituloController.prototype.openCambioMultiple = function(modal) {
	var titulo = this.grid.itemsSelected();

	if (titulo.length != 0)
		this.abrirModal(modal, titulo[0]);
	else
		showError("Debe seleccionar al menos un registro");
};

TituloController.prototype.cambioMultiple = function(cambio, modal) {
	if ($("#id" + modal).valid() && this.validacionesCambioMultipleTitulos(cambio)) {
		var me = this;
		var titulo = this.formManager.leerForma("id" + modal, this.grid.getColumns());
		var titulos = this.grid.itemsSelected();

		var indx = [];
		for (var i = 0; i < titulos.length; i++)
			indx.push(titulos[i].idTituloCnt);

		this.service.cambioMultipleTitulo(titulo, cambio, indx, function(res) {
			me.mostrarResultadosMultiple(cambio, res.mensaje, indx.length);
			showMessage("Datos guardados correctamente");
			me.cargaTitulosInicial();
			$('#modal' + modal).modal('hide');
		});
	}
};

TituloController.prototype.mostrarResultadosMultiple = function(cambio, modificados, total) {

	if (cambio == "CATEGORIADTO" || cambio == "CATEGORIADTR") {
		$("#totalResultMul").text(total);
		$("#cargadoResultMul").text(modificados);
		$("#rechazatoResultMul").text(parseInt(total) - parseInt(modificados));
		$("#lbResMul").text("Resultados de Ajuste Categoria");
		$('#modalResultadosMultiple').modal('show');
	}
};

//boton guardar
TituloController.prototype.guardarCambios = function() {
	var me = this;
	this.service.guardarCambios(
		function(fila) {
			me.mostratTotalTitulos();
		}
	);
};

TituloController.prototype.mostratTotalTitulos = function() {
	var fila = this.grid.getRows(1);

	var titulosLista = this.service.listarTitulosEnLista(idLista); console.log(titulosLista);
	var titulosActual = titulosLista.length;

	console.log(titulosContratados);
	console.log(titulosActual);

	var total = titulosContratados - parseInt(titulosActual);

	console.log(total);


	var mensaje = null;
	if (total == 0)
		mensaje = "Se han guardado el n\u00FAmero total de t\u00EDtulos contratados."
	if (total < 0)
		mensaje = "Se han guardado un n\u00FAmero de t\u00EDtulos mayor al contratados."
	if (total > 0)
		mensaje = "Se han guardado un n\u00FAmero de t\u00EDtulos menor al contratados."
	$('#divTotalTitulos div.modal-body').find("p").text(mensaje);
	$('#divTotalTitulos').modal('show');
};

TituloController.prototype.descargar = function() {
	this.service.descargarArchivo(idLista);
};

TituloController.prototype.openCargarDocumento = function() {
	this.uploader.opentUploader();
};

TituloController.prototype.muestraFechaCarga = function(item) {
	if ($(item).val() == 'N')
		$("#fechaInicioNuevaDiv").show();
	else
		$("#fechaInicioNuevaDiv").hide();
};

TituloController.prototype.startUpload = function(item) {
	var nameModal = "modalCarga";
	this.uploader.startUpload(nameModal);
};

TituloController.prototype.onUpload = function(data, grid) {
	if (data.error == '' || data.error == null) {
		if (data.tipoCarga == 'N') {
			$('#idListaSel').find('option').remove().end();
			var listas = this.tituloController.service.buscarListas();
			this.tituloController.inicializarSelectVal("idListaSel", listas.listas);
		}
		if (data.respuestaExcel.lista != null && data.respuestaExcel.lista.idLista != null)
			idLista = data.respuestaExcel.lista.idLista;

		$("#idListaSel").val(idLista);
		grid.getPrincipal();
		this.tituloController.mostrarErroresDescarga(data.respuestaExcel);
	}
	else {
		showError(data.error);
		$('#modalCarga').modal('hide');
	}
};

//jun-17
TituloController.prototype.mostrarErroresDescarga = function(resp) {
	$('#modalCarga').modal('hide');
	$("#totalResultFile").html(resp.responseTR.datosCarga.TOTAL_REGISTROS);
	$("#cargadoResultFile").html(resp.responseTR.datosCarga.TOTAL_CARGADOS);
	$("#rechazatoResultFile").html(resp.responseTR.datosCarga.TOTAL_ERROR);
	$('#modalResultadosCarga').modal('show');

	if (resp.responseTR.datosCarga.TOTAL_ERROR != 0)
		$("#errorFile").show();
	else
		$("#errorFile").hide();
};

TituloController.prototype.descargarArchivoErrores = function() {
	this.service.descargarArchivoErrores();
};

TituloController.prototype.cargaDetalle = function(nombreUnico) {
	this.grid.getDetails(nombreUnico);
};

TituloController.prototype.altaSeriesAutomatico = function() {
	$("#errPerCat").hide();
	var me = this;
	this.service.guardarSeriesAuto(this.service.titulo, function(ret) {
		me.cargaTitulosInicial();
		$('#divAddSeries').modal('hide');
		$('#modalEditForm').modal('hide');
		showMessage("Datos guardados correctamente");
	});
};

TituloController.prototype.exclusiveSelectController = function(selectSource, selectTarget) {
	var sSource = $("#" + selectSource);
	var sTarget = $("#" + selectTarget);
	var state = false;

	if (sSource.val() != "0")
		state = true;

	sTarget.prop('disabled', state)
};

TituloController.prototype.selectsDisabledController = function(selectsSource, selectsTarget) {
	$("select." + selectsSource).prop('disabled', false);
	$("select." + selectsTarget).each(function() {
		$(this).prop('disabled', true);
		$(this).val('0');
	});
};

TituloController.prototype.cargaTitulosInicial = function() {
	this.grid.getPrincipal();
};

TituloController.prototype.cargaTitulosSeries = function(nombreUnico) {
	this.grid.getSeries(nombreUnico);
};

TituloController.prototype.cargaTitulosDetalle = function(nombreUnico, idBv) {
	this.grid.getDetalles(nombreUnico, idBv);
};

TituloController.prototype.ejecutarAcciones = function() {
	var accion = $("#operacionesTitulosTransaccional").val();

	if (accion == "agregar")
		tituloController.open('guardar');

	if (accion == "editar")
		tituloController.open('editar');

	if (accion == "eliminar")
		tituloController.open('eliminar');

	if (accion == "ventana")
		tituloController.openCambioMultiple('VentanaForm');

	if (accion == "categoria")
		tituloController.openCambioMultiple('CategoriaForm');

	if (accion == "hvrd")
		tituloController.openCambioMultiple('HvdrForm');
};