package com.mx.dla.dda.reportes.generaxml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.mx.dla.global.bos.BaseBO;

@Service
public class generaXMLimpl extends BaseBO {

	@Value("${excel.process.source.path}")
	private String uriXML;

	ArrayList<String> xml = new ArrayList<String>();

	public String generaXML(List<Map<String, String>> response, String fileFileName, String tituloReporte)
			throws IOException {
		boolean createHead = false;

		xml.clear();

		String headFileXml = "<?xml version='1.0' encoding ='UTF-8'?> <Archivo> <Tabla id='Hoja 1'>";
		String endFileXml = "</Tabla></Archivo>";
		String title = "<Fila id='' visible='true'><Celda><width>0</width><height>0</height><colspan>13</colspan><rowspan>1</rowspan><align>center</align><valign>middle</valign><cellClass>titulo_modulo</cellClass><value>"
				+ tituloReporte + "</value><text>" + tituloReporte + "</text><datatype></datatype></Celda></Fila>";
		String startFila = "<Fila id='' visible='true'>";
		String endFila = "</Fila>";
		String startCelda = "<Celda><width>0</width><height>0</height><colspan>1</colspan><rowspan>1</rowspan><align>left</align><valign></valign>";
		String celdaClaseEncabezado = "<cellClass>" + "celda_encabezado_general" + "</cellClass>";
		String celdaClaseNormal = "<cellClass>" + "celda_normal" + "</cellClass>";
		String startTextoCelda = "<text>";
		String endTextoCelda = "</text>";
		String endCelda = "</Celda>";

		// inicia xml y coloca titulo al reporte
		xml.add(headFileXml);
		xml.add(title);

		// se genera fila de encabezado
		for (Map<String, String> item : response) {

			if (!createHead)
				xml.add(startFila);

			for (Map.Entry<String, String> pair : item.entrySet()) {
				if (!createHead) {

					xml.add(startCelda);
					xml.add(celdaClaseEncabezado);
					xml.add(startTextoCelda);
					xml.add(pair.getKey());
					xml.add(endTextoCelda);
					xml.add(endCelda);

				}
			}
			if (!createHead)
				xml.add(endFila);

			createHead = true;
		}

		// se generan filas del reporte
		for (Map<String, String> item : response) {
			xml.add(startFila);
			for (Map.Entry<String, String> pair : item.entrySet()) {
				xml.add(startCelda);
				xml.add(celdaClaseNormal);
				xml.add(startTextoCelda);
				xml.add(pair.getValue());
				xml.add(endTextoCelda);
				xml.add(endCelda);
			}
			xml.add(endFila);
		}

		xml.add(endFileXml);

		File file = new File(uriXML + "/" + fileFileName);
		FileUtils.writeLines(file, xml);

		logger.info("busca XML en [{}]", file.getAbsolutePath());
		logger.info("XML [{}]", xml);

		if (file.exists())
			logger.info("se genero xml {}", fileFileName);

		return file.getAbsolutePath();
	}

	public String generaXMLvp(List<Map<String, String>> response, String fileFileName, String tituloReporte)
			throws IOException {
		boolean createHead = false;

		xml.clear();

		String headFileXml = "<?xml version='1.0' encoding ='UTF-8'?> <Archivo> <Tabla id='Hoja 1'>";
		String endFileXml = "</Tabla></Archivo>";
		String title = "<Fila id='' visible='true'><Celda><height>0</height><colspan>13</colspan><rowspan>1</rowspan><align>center</align><valign>middle</valign><cellClass>titulo_modulo</cellClass><value>"
				+ tituloReporte + "</value><text>" + tituloReporte + "</text><datatype></datatype></Celda></Fila>";
		String startFila = "<Fila id='' visible='true'>";
		String endFila = "</Fila>";
		String startCelda = "<Celda><height>0</height><colspan>1</colspan><rowspan>1</rowspan><align>left</align><valign></valign>";
		String celdaClaseEncabezado = "<cellClass>" + "celda_encabezado_general" + "</cellClass>";
		String celdaClaseTotales = "<cellClass>" + "celda_totales" + "</cellClass>";
		String celdaClaseNormal = "<cellClass>" + "celda_normal" + "</cellClass>";
		String startTextoCelda = "<text>";
		String endTextoCelda = "</text>";
		String endCelda = "</Celda>";

		String DatatypeNumeric = "<datatype>decimal2</datatype>";
		String celdaMoreWidth = "<width>200</width>";
		String celdaWidth = "<width>0</width>";

		// inicia xml y coloca titulo al reporte
		xml.add(headFileXml);
		xml.add(title);

		// se genera fila de encabezado
		for (Map<String, String> item : response) {

			if (!createHead)
				xml.add(startFila);

			for (Map.Entry<String, String> pair : item.entrySet()) {
				if (!createHead) {
					xml.add(startCelda);
					xml.add(celdaWidth);
					xml.add(celdaClaseEncabezado);
					xml.add(startTextoCelda);
					if (pair.getKey().equals("COSTA_RICA")) {
						xml.add("COSTA RICA");
					} else if (pair.getKey().equals("EL_SALVADOR")) {
						xml.add("EL SALVADOR");
					} else if (pair.getKey().equals("R_DOMINICANA")) {
						xml.add("R DOMINICANA");
					} else {
						xml.add(pair.getKey());
					}

					xml.add(endTextoCelda);
					xml.add(endCelda);
				}
			}
			if (!createHead)
				xml.add(endFila);

			createHead = true;
		}

		// se generan filas del reporte
		for (Map<String, String> item : response) {
			xml.add(startFila);
			for (Map.Entry<String, String> pair : item.entrySet()) {

				if (pair.getKey().equals("CONCEPTO")) {
					xml.add(startCelda);
					xml.add(celdaMoreWidth);
					xml.add(celdaClaseNormal);
					xml.add(startTextoCelda);
					xml.add(pair.getValue());
					xml.add(endTextoCelda);
					xml.add(endCelda);

				} else if (pair.getKey().equals("TOTAL")) {
					xml.add(startCelda);
					xml.add(celdaWidth);
					xml.add(celdaClaseTotales);
					xml.add(startTextoCelda);
					xml.add(pair.getValue());
					xml.add(endTextoCelda);
					xml.add(DatatypeNumeric);
					xml.add(endCelda);
				} else {
					xml.add(startCelda);
					xml.add(celdaWidth);
					xml.add(celdaClaseNormal);
					xml.add(startTextoCelda);
					xml.add(pair.getValue());
					xml.add(endTextoCelda);
					xml.add(DatatypeNumeric);
					xml.add(endCelda);
				}

			}
			xml.add(endFila);
		}

		xml.add(endFileXml);

		File file = new File(uriXML + "/" + fileFileName);
		FileUtils.writeLines(file, xml);

		logger.info("busca XML en [{}]", file.getAbsolutePath());
		logger.info("XML [{}]", xml);

		if (file.exists())
			logger.info("se genero xml {}", fileFileName);

		return file.getAbsolutePath();
	}

	public String generaXMLabuys(List<LinkedHashMap<String, String>> response, String fileFileName,
			String tituloReporte) throws IOException {
		boolean createHead = false;

		xml.clear();

		String headFileXml = "<?xml version='1.0' encoding ='UTF-8'?> <Archivo> <Tabla id='Hoja 1'>";
		String endFileXml = "</Tabla></Archivo>";
		String title = "<Fila id='' visible='true'><Celda><height>0</height><colspan>13</colspan><rowspan>1</rowspan><align>center</align><valign>middle</valign><cellClass>titulo_modulo</cellClass><value>"
				+ tituloReporte + "</value><text>" + tituloReporte + "</text><datatype></datatype></Celda></Fila>";
		String startFila = "<Fila id='' visible='true'>";
		String endFila = "</Fila>";
		String startCelda = "<Celda><height>0</height><colspan>1</colspan><rowspan>1</rowspan><align>left</align><valign></valign>";
		String celdaClaseEncabezado = "<cellClass>" + "celda_encabezado_general" + "</cellClass>";
		String celdaClaseNormal = "<cellClass>" + "celda_normal" + "</cellClass>";
		String startTextoCelda = "<text>";
		String endTextoCelda = "</text>";
		String endCelda = "</Celda>";

		String DatatypeNumeric = "<datatype>THOUSANDS</datatype>";
		String celdaMoreWidth = "<width>200</width>";
		String celdaWidth = "<width>0</width>";

		// inicia xml y coloca titulo al reporte
		xml.add(headFileXml);
		xml.add(title);

		// se genera fila de encabezado
		for (Map<String, String> item : response) {

			if (!createHead)
				xml.add(startFila);

			for (Map.Entry<String, String> pair : item.entrySet()) {
				if (!createHead) {

					xml.add(startCelda);
					xml.add(celdaWidth);
					xml.add(celdaClaseEncabezado);
					xml.add(startTextoCelda);
					if (pair.getKey().equals("AASSET_NAME")) {
						xml.add("ASSET NAME");
					} else {
						xml.add(pair.getKey());
					}

					xml.add(endTextoCelda);
					xml.add(endCelda);

				}
			}
			if (!createHead)
				xml.add(endFila);

			createHead = true;
		}

		// se generan filas del reporte
		for (Map<String, String> item : response) {
			xml.add(startFila);
			for (Map.Entry<String, String> pair : item.entrySet()) {

				if (pair.getKey().equals("AASSET_NAME")) {
					xml.add(startCelda);
					xml.add(celdaMoreWidth);
					xml.add(celdaClaseNormal);
					xml.add(startTextoCelda);
					xml.add(pair.getValue());
					xml.add(endTextoCelda);
					xml.add(endCelda);

				} else if (pair.getKey().equals("TOTAL")) {
					xml.add(startCelda);
					xml.add(celdaWidth);
					xml.add(celdaClaseNormal);
					xml.add(startTextoCelda);
					xml.add(pair.getValue());
					xml.add(endTextoCelda);
					xml.add(DatatypeNumeric);
					xml.add(endCelda);
				} else {
					xml.add(startCelda);
					xml.add(celdaWidth);
					xml.add(celdaClaseNormal);
					xml.add(startTextoCelda);
					xml.add(pair.getValue());
					xml.add(endTextoCelda);
					xml.add(DatatypeNumeric);
					xml.add(endCelda);
				}

			}
			xml.add(endFila);
		}

		xml.add(endFileXml);

		File file = new File(uriXML + "/" + fileFileName);
		FileUtils.writeLines(file, xml);

		logger.info("busca XML en [{}]", file.getAbsolutePath());
		logger.info("XML [{}]", xml);

		if (file.exists())
			logger.info("se genero xml {}", fileFileName);

		return file.getAbsolutePath();

	}

}
