package com.mx.dla.dda.contrato.transaccion.terminos.dtos;

import java.util.List;

import com.mx.dla.global.dtos.BaseDTO;

public class PremiumDTO extends BaseDTO {

	private static final long	  serialVersionUID = 1L;

	private MinimoGarantizadoDTO  minimos;
	private ComunTerminosDTO	  comun;
	private PrecioRentaDTO		  precio;
	private RevenueSeccionDTO	  revenue;
	private ExcepcionesSeccionDTO excepciones;

	private String[][]			  release;
	private List<List<String>>	  releaseL;

	public MinimoGarantizadoDTO getMinimos() {
		return minimos;
	}

	public void setMinimos(MinimoGarantizadoDTO minimos) {
		this.minimos = minimos;
	}

	public String[][] getRelease() {
		return release;
	}

	public void setRelease(String[][] release) {
		this.release = release;
	}

	public List<List<String>> getReleaseL() {
		return releaseL;
	}

	public void setReleaseL(List<List<String>> releaseL) {
		this.releaseL = releaseL;
		if (releaseL != null) {
			this.release = new String[releaseL.size()][releaseL.get(0).size()];
			for (int i = 0; i < releaseL.size(); i++)
				for (int j = 0; j < releaseL.get(0).size(); j++)
					this.release[i][j] = releaseL.get(i).get(j);
		}
	}

	public ComunTerminosDTO getComun() {
		return comun;
	}

	public void setComun(ComunTerminosDTO comun) {
		this.comun = comun;
	}

	public PrecioRentaDTO getPrecio() {
		return precio;
	}

	public void setPrecio(PrecioRentaDTO precio) {
		this.precio = precio;
	}

	public RevenueSeccionDTO getRevenue() {
		return revenue;
	}

	public void setRevenue(RevenueSeccionDTO revenue) {
		this.revenue = revenue;
	}

	public ExcepcionesSeccionDTO getExcepciones() {
		return excepciones;
	}

	public void setExcepciones(ExcepcionesSeccionDTO excepciones) {
		this.excepciones = excepciones;
	}

}
