package com.mx.dla.dda.contrato.minimoseleccion.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.common.bos.JustificacionBO;
import com.mx.dla.dda.contrato.common.dtos.JustificacionDTO;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.AnnioDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.PeriodoDTO;

@Controller
@Scope("request")
public class MinimoSeleccionAction extends BaseContratoAction {

	private static final long serialVersionUID = 6371845499197432247L;
	//private static Logger log = Logger.getLogger(MinimoSeleccionAction.class);

	private Long idContrato;
	private Long estatus;

	private List<JustificacionDTO> justificaciones;

	@Autowired
	private MinimoSeleccionBO minimoSeleccionBO;

	@Autowired
	private JustificacionBO justificacionBO;

	// private List<PeridoPagoDTO> periodos;

	private String tipoPago;

	private List<AnnioDTO> annios;

	private List<PeriodoDTO> periodos;

	@Override
	public String execute() {
		// el idContrato vendra de la sesion, por el momento llega del request

		if (getSession().get("idContrato") == null) {
			logger.debug("No viene idContrato en session");
			getSession().put("idContrato", getIdContrato());
		} else {
			logger.debug("Viene idContrato en Session");
			setIdContrato((Long) getSession().get("idContrato"));
		}

		setTipoPago(minimoSeleccionBO.obtenTipoPago(getIdContrato()));

		logger.debug(" idContrato : " + getIdContrato() + " tipoPago : " + getTipoPago());

		if (getTipoPago() != null && !getTipoPago().equals("")) {

			if (getTipoPago().equals("FLAT")) {
				setAnnios(minimoSeleccionBO.obtenAnnioContrato(getIdContrato()));
			} else {
				setPeriodos(minimoSeleccionBO.obtnePeriodoContrato(getIdContrato()));
			}

		}

		setJustificaciones(justificacionBO.buscarJustificaciones(getIdContrato()));
		// setPeriodos(minimoSeleccionBO.obtenPeriodoPago(getIdContrato()));
		setEstatus(minimoSeleccionBO.obtenerEstatusContrato(getIdContrato()));

		return SUCCESS;
	}

	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}

	public Long getIdContrato() {
		return idContrato;
	}

	public List<JustificacionDTO> getJustificaciones() {
		return justificaciones;
	}

	public void setJustificaciones(List<JustificacionDTO> justificaciones) {
		this.justificaciones = justificaciones;
	}

	public Long getEstatus() {
		return estatus;
	}

	public void setEstatus(Long estatus) {
		this.estatus = estatus;
	}

	public void setTipoPago(String tipoPago) {
		this.tipoPago = tipoPago;
	}

	public String getTipoPago() {
		return tipoPago;
	}

	public void setAnnios(List<AnnioDTO> annios) {
		this.annios = annios;
	}

	public List<AnnioDTO> getAnnios() {
		return annios;
	}

	public void setPeriodos(List<PeriodoDTO> periodos) {
		this.periodos = periodos;
	}

	public List<PeriodoDTO> getPeriodos() {
		return periodos;
	}

}
