package com.mx.dla.dda.reporte.amortizacion.presupuesto.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.listado.dtos.ContentType;
import com.mx.dla.dda.reporte.amortizacion.presupuesto.bo.ReporteAmortvsPptoBO;
import com.mx.dla.dda.reporte.amortizacion.presupuesto.dto.ReporteAmortizacionVsPresupuestoDTO;

public class ReporteAmortvsPptoAction extends BaseContratoAction {
	
	private static final long serialVersionUID = -6159275023094659946L;
	
	private String fecha;
	private List<ReporteAmortizacionVsPresupuestoDTO> reporteAmortPpto;
	private List<ReporteAmortizacionVsPresupuestoDTO> reporte;
	
	
	private InputStream       fileInputStream;
	private String            fileFileName;
	
	@Autowired
	private ReporteAmortvsPptoBO reporteAmortPptoBO;
	
	@Override
	public String execute() throws Exception {

		return SUCCESS;
	}
	
	
	
	public String obtenerReporteAmortPpto(){
		
		 try{
			 logger.info("Inicia obtenReporteAmortPpto  - [{}]"+fecha);
			 
			    DateFormat formatoEntrada = new SimpleDateFormat("MM/yyyy");
				Date date = formatoEntrada.parse(fecha);

				SimpleDateFormat formatoMes = new SimpleDateFormat("MM");
				Long mes = Long.parseLong(formatoMes.format(date));

				SimpleDateFormat formatoAnio = new SimpleDateFormat("yyyy");
				Long annio = Long.parseLong(formatoAnio.format(date));
 
			 
			 reporteAmortPpto =reporteAmortPptoBO.obtenReporteAmortPpto(mes,annio);
			 
			 logger.info("Se consulta a DAO  - [{}]"+mes+"-"+annio);	
			 
		 }catch(Exception e){
			 logger.error("ERROR - ACTION: obtenReporteAmortPpto [{}]"+e);
			 //return ERROR;
	     }
		 
		 return SUCCESS;
	}
	
	public String descargaReporte(){
		
		String nombre = "reporteAmortizacion.xlsx";
		
		try {

			byte [] bytes = reporteAmortPptoBO.descargaArchivoReporte(fecha);
			fileInputStream = new ByteArrayInputStream(bytes);						
			fileFileName    = nombre;
			
		} catch (Exception e) {
			
			System.out.println("ERROR. obj descargaReporte Amortizacion: "+e);
		}
		return SUCCESS;
	}
	
	public String descargaObjArchivo(){
	       //logger.info("se vista previa : [{}]", reporte);
			String nombre;
			byte[] rep;
						
			
			try {
				
				rep = reporteAmortPptoBO.descargaObjReporte(reporte);
				
				System.out.println("reporte..."+reporte);
				
				nombre = "reporteAmortizacion";
						
				HttpServletResponse response = ServletActionContext.getResponse();
				response.setContentLength(rep.length);
				response.setContentType(ContentType.EXCELX.name());
				response.setHeader("Content-Disposition","attachment;filename="+nombre+".xlsx");		    
						    
				ServletOutputStream out = response.getOutputStream();
				out.write(rep);
				out.flush();
				out.close();
		
				
			} catch (Exception e) {
				
				//error = e.getMessage();
				logger.error("ERROR - reporte amortizacion : [{}]", e);
			}
			
			return SUCCESS;

			
		}
	


	

	public String getFecha() {
		return fecha;
	}



	public void setFecha(String fecha) {
		this.fecha = fecha;
	}

	public List<ReporteAmortizacionVsPresupuestoDTO> getReporteAmortPpto() {
		return reporteAmortPpto;
	}
	
	public List<ReporteAmortizacionVsPresupuestoDTO> getReporte() {
		return reporte;
	}

	public void setReporte(List<ReporteAmortizacionVsPresupuestoDTO> reporte) {
		this.reporte = reporte;
	}

	public void setReporteAmortPpto(List<ReporteAmortizacionVsPresupuestoDTO> reporteAmortPpto) {
		this.reporteAmortPpto = reporteAmortPpto;
	}
	public void setFileInputStream(InputStream fileInputStream) { this.fileInputStream = fileInputStream; }

	public void setFileFileName(String fileFileName) { this.fileFileName = fileFileName; }

	public String            getFileFileName()     { return fileFileName; }
	public InputStream       getFileInputStream()  { return fileInputStream; }

             
}
