var service;
var tipoPresupuesto;
var modificados = [];

$(document).ready(function(){	  
	    service = new PresupuestoService('');	    	    	    	   
	    tipoPresupuesto = tipoPre;
	    
		inicializarBotones();		
		inicializarForma();

		if(tipoPresupuesto === "Amortizable")
		   $("div.l-box-header h2.l-box-title span").text($("div.l-box-header h2.l-box-title span").text() + " Amortizable")
		else
		   $("div.l-box-header h2.l-box-title span").text($("div.l-box-header h2.l-box-title span").text() + " No Amortizable")
});

function inicializarForma(){			
		var anio = parseInt(new Date().getFullYear()) + 1;
		for(var i=anio; i>= 2013; i--)
			addOptionSelect("anio", '<option value="'+ i +'">'+ i +'</option>');	   
}

function inicializarBotones(){
	
	$("#buscar").click(function()   
	{
		if($("#anio").val() != "-1")
		{
			if(tipoPresupuesto === "Amortizable")
				$("#redis").show();
			else
				$("#redis").hide();
			
			
			var request = {type: tipoPresupuesto, anio : $("#anio").val()};
			service.obtenerApartadosAnio(request);						
		}																												
		else		
			showError("Selecciona un año a consultar.");		
	});
	
	$("#redis").click(function()   
	{	
		if( $("#anio").val() != "-1")
		{						
			limpiarElementos();
			var montoAmortizable 	= $("#montoAmortizableVal").val();
			var montoAsignado	 	= $("#montoTotalAsignado").val();
			var montoDisponible 	= $("#montoDisponible").val();
			
			var presupuesto = getPresupuestosAnio(tipoPresupuesto, $("#anio").val());				                                                 			
			registrarApartadoRedistribucion(presupuesto, parseInt($("#anio").val()));
			$('#redismontoDisponible').val( montoDisponible ); 
			$('#modalRedistribucion').modal('show');		
			
		}
		else		
			showError("Selecciona un año a consultar.");
	});
	
	$("#btnGuardar").click(function()   
	{						
		$("#btnGuardar").prop("disabled", true);
		$("#labelProcesando").show();
		var presupuesto = getPresupuestosAnio(tipoPresupuesto, $("#anio").val());		
		var mensaje     = service.validarPresupuestoAmor(presupuesto);
		if(mensaje == "")		
			service.guardarPresupuestos(presupuesto, tipoPresupuesto);																				
		else
		{
			showError(mensaje);
			$("#btnGuardar").prop("disabled", false);
			$("#labelProcesando").hide();
		}
					
	});		
}

function getPresupuestosAnio(tipo, anio){
	var nombreDiv   = tipo === "Amortizable" ? "tabApartados" : "tabNoApartados";
	var presupuesto = obtenerPresupuesto(nombreDiv, anio, tipo);
	return presupuesto;
}

function mostrarTablaApartados(idDiv, idDivAp, idTab, apartados){
	limpiarTabla(idDivAp, idTab);			
	crearTablaApartados(apartados, idTab);
	$("#"+idDiv).show();	
}

function crearTablaApartados(apartados, idTab){	
	var encabezados = $("<thead />");
	var cuerpo      = $("<tbody/>");
		
	var fila = $("<tr class='encabezado'/>");
	fila.append($("<td/>").text("Apartado"));
	fila.append($("<td/>").text("Monto Asignado"));
	fila.append($("<td/>").text("Monto Comprometido"));	
	encabezados.append(fila);
	
	if(apartados.length == 0)
	{
		var fila = $("<tr/>");
		fila.append($("<td/>").text(""));
		fila.append($("<td align='middle'/>").text("No existen registros."));
		fila.append($("<td/>").text(""));
		cuerpo.append(fila);
	}
	else 
	{
		for(var i=0; i<apartados.length; i++)
		{
			var fila = $("<tr/>").attr("id", apartados[i].idPreApart == null ? -1 : apartados[i].idPreApart);
			    fila.attr("idAp", apartados[i].id).attr("idSap", apartados[i].idSap);
			    			   
			fila.append($("<td/>").text(apartados[i].nombre));
			
			var asignado = apartados[i].montoAsignado == null ? 0.0 : parseFloat(apartados[i].montoAsignado); 
			var input = $("<input/>").attr("type", "text")						         
							         .attr("value", asignado.formatDLA())
							         .addClass("form-control");					
			
			
			/*
			if(asignado > 0 && apartados[i].type == "No Amortizable")
				input.attr("readOnly","");
			if(apartados[i].type == "No Amortizable")
			{
			    for(k=0; k<modificados.length; k++)
			    	if(parseInt(modificados[k]) == apartados[i].idPreApart )
			    		input.attr("readOnly","");
			}		
			*/		
			
			if(apartados[i].fechaSAP != null && apartados[i].type == "Amortizable")
				input.attr("readOnly","");			
			fila.append($("<td/>").append(input));			

			var comprometido = apartados[i].montoComprometido == null ? 0.0 : apartados[i].montoComprometido;
			var input1 = $("<input readOnly/>").attr("type", "text")						                
									  .attr("value", parseFloat(comprometido).formatDLA())       
									  .addClass("form-control"); 			    				    	 				  							
			fila.append($("<td/>").append(input1));
			cuerpo.append(fila);
		}
	}					
	modificados = [];
	$("#"+ idTab).append(encabezados).append(cuerpo);	
}

function limpiarTabla(idDiv, idTab){
	$("#" + idTab).remove();
	$("#" + idDiv).empty();	
	var tabla = $("<table/>").addClass("table table-striped table-hover").attr("id", idTab);
	$("#" + idDiv).append(tabla);	
}

function addOptionSelect(id, html){
	$("#" + id).append(html);
}

function obtenerAsignado(presupuesto){
	var asignado = 0.0;
	for(var i=0; i< presupuesto.apartados.length;  i++)
	{
		if(presupuesto.apartados[i].montoAsignado != null)
		   asignado = asignado + parseFloat(presupuesto.apartados[i].montoAsignado);
	}
	return asignado;
}

function cambiaMontoDisponible()
{
	if($( "#chmontoDisponible" ).prop("checked") ) {
		$("#maOrigen")    .val("");
		$("#mcOrigen")    .val("");
		$("#mRedistribur").val("");
		$("#apOrigen").val(-1);
		$("#apOrigen").prop("disabled", true);
	}else {
		$( "#apOrigen" ).prop("disabled", false);
		$("#mRedistribur").val("");
	}
	

}