package com.mx.dla.dda.factura;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.testng.annotations.Test;

import com.mx.dla.dda.common.test.BaseDaoTest;
import com.mx.dla.dda.factura.general.daos.FacturacionDAO;
import com.mx.dla.dda.factura.general.dtos.ContratoFacturaDTO;
import com.mx.dla.dda.factura.general.dtos.MesFacturaDTO;
import com.mx.dla.dda.factura.general.dtos.PagoMesContratoBD;

public class FacturaGeneralTest  extends BaseDaoTest{

	@Autowired
	private FacturacionDAO facturacionDAO;
		
	@Value("${factura.header.sociedad}")
	protected String sociedad;
		
	@Test(enabled = false)
	public void obtenerCostoMesContratoDAO(){
		List<PagoMesContratoBD> datos = facturacionDAO.obtenerCostoMesContrato(24l);
		logger.debug("", datos);		
	}
	
	@Test(enabled = false)
	public void  obtenerPagoMesContratoDAO(){
		List<PagoMesContratoBD> datos = facturacionDAO.obtenerPagoMesContrato(24l,0l);
//		logger.debug("", datos);
	}
	
	@Test(enabled = false)
	public void obtenerContratosEstudioDAO(){
		List<ContratoFacturaDTO> datos = facturacionDAO.obtenerContratosEstudio(18l, "");
		logger.debug("{}", datos);
	}
	
	@Test(enabled = false)
	public void obtenerContratoEnmAden(){
		ContratoFacturaDTO dato = facturacionDAO.obtenerContratoEnmAden(5l);
		logger.debug("{}", dato);
	}
	
	
	@Test(enabled = false)
	public void fecha(){
		SimpleDateFormat sdf = new SimpleDateFormat("MM-yyyy");
		logger.debug("{}", sdf.format(new Date()));
	}
			
	@Test(enabled = false)
	public void guardaFacturDetalleDAO(){
		MesFacturaDTO mes= new MesFacturaDTO();
		mes.setMes("01-6-2018");
		mes.setPagar(5000.0);
		facturacionDAO.actualizarFacturaDetalle(18l, 2l, mes);
				
	}
		
}
