package com.mx.dla.dda.contrato.materiales.bos;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.materiales.daos.MaterialesDAO;
import com.mx.dla.dda.contrato.materiales.dtos.MaterialDTO;
import com.mx.dla.global.bos.BaseBO;

@Service
public class MaterialesBO extends BaseBO{
	
	@Autowired
	private MaterialesDAO materialesDAO;
	
	@Autowired
	private GeneralesDAO generalesDAO;

	public List<MaterialDTO> buscarMateriales ( Long idContrato)
	{
		
		ContratoDTO contrato = generalesDAO.obtenerContrato(idContrato);
		return materialesDAO.buscarMateriales(contrato.getIdContratoOriginal());
	}
	
	public Double buscarCostoTotal(Long idContrato)
	{
		ContratoDTO contrato = generalesDAO.obtenerContrato(idContrato);
		return materialesDAO.buscarCostoTotalMateriales(contrato.getIdContratoOriginal());
	}
}
