package com.mx.dla.dda.contrato.common.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.bos.JustificacionBO;
import com.mx.dla.dda.contrato.common.constants.ContratoConstats;
import com.mx.dla.dda.contrato.common.dtos.JustificacionDTO;
import com.mx.dla.global.actions.BaseAction;

public class BaseContratoAction extends BaseAction {
	
	private static final long serialVersionUID = -1880333104009351799L;
	
	@Autowired
	private JustificacionBO justificacionBO;
	
	private List<JustificacionDTO> justificaciones;
	private String justificacion;
	private Long idContrato;
	private Long estatusContrato;
	
	protected String buscarJustificaciones()  {
		Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);
		setJustificaciones(justificacionBO.buscarJustificaciones(idC));
		return SUCCESS;
	}
	
	protected void guardarJustificacion()
	{
		UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
		Long idC = (Long) getSession().get(ContratoConstats.ID_CONTRATO_SESSION);
		justificacionBO.insertarJustificacion(getJustificacion(),idC , usuario);
	}

	public List<JustificacionDTO> getJustificaciones() {
		return justificaciones;
	}
	public void setJustificaciones(List<JustificacionDTO> justificaciones) {
		this.justificaciones = justificaciones;
	}
	
	public String getJustificacion() {
		return justificacion;
	}
	
	public void setJustificacion(String justificacion) {
		this.justificacion = justificacion;
	}
	
	public Long getIdContrato() {
		return idContrato;
	}
	
	public void setIdContrato(Long idContrato) {
		this.idContrato = idContrato;
	}
	
	public Long getEstatusContrato() {
		return estatusContrato;
	}
	
	public void setEstatusContrato(Long estatusContrato) {
		this.estatusContrato = estatusContrato;
	}

}
