function mostrarInformacionConsulta(presupuesto, anio){
	if(presupuesto != null)
	{
		mostrarTablaApartados("divAmortizable", "divApartados", "tabApartados", presupuesto.apartados);
		presupuesto.montoAsignado = obtenerAsignado(presupuesto);
		showValorePresupuesto(presupuesto.montoAmortizable, presupuesto.montoAsignado, parseFloat(presupuesto.montoAmortizable)-parseFloat(presupuesto.montoAsignado));
		
		$("#"+ "tabApartados" + " tbody tr").each(function(){	
			$(this).find("input").each(function(){    		    	    		
				$(this).change(function() {  
					bindingInputChangeAmorti();
					var valor = $(this).val();
					valor = valor.replaceAll(",","");
					valor = valor == "" ? "" : parseFloat(valor).formatDLA(); 
					$(this).val(valor);
				});    		
			});
		});
	}
}

function showValorePresupuesto(amor, asig, disponible){	
	$("#montoAmortizableVal").val("$"+parseFloat(amor).formatDLA());
	$("#montoTotalAsignado") .val("$"+parseFloat(asig).formatDLA());
	$("#montoDisponible")    .val("$"+parseFloat(disponible).formatDLA());
}

function bindingInputChangeAmorti(){	
	var pre = obtenerPresupuesto("tabApartados", $("#anio").val());	
	showValorePresupuesto(pre.montoAmortizable, pre.montoAsignado, pre.montoAmortizable - pre.montoAsignado);	
}

function obtenerPresupuesto(id, anio, tipoPresupuesto){
	var montoAsignado = 0.0;
	var apartados = [];	
	//debugger
	$("#"+id + " tbody tr").each(function(){												
		var apartado = new Apartado('');
		apartado.id                = parseInt($(this).attr("idAp"));
		apartado.idPreApart        = parseInt($(this).attr("id"));		
		apartado.nombre            = $(this).find("td:first").text();
		apartado.montoAsignado     = $(this).find("input[type='text']:first").val() == "" ? null : parseFloat( deformatDLA( $(this).find("input[type='text']:first").val() ) );		
		apartado.montoComprometido = parseFloat( deformatDLA( $(this).find("input[type='text']:last") .val() ) );
		apartado.montoComprometido = parseFloat( deformatDLA( $(this).find("input[type='text']:last") .val() ) );
		apartado.type              = tipoPresupuesto;
		apartado.idSap             = $(this).attr("idsap");
		
		var read = $(this).find("input[type='text']:first").attr("readOnly");
		apartado.fechaSAP          =  typeof read !== typeof undefined && read !== false ? "" : null;
		if( apartado.montoAsignado != null)
		    montoAsignado = montoAsignado + apartado.montoAsignado;		
		apartados.push(apartado);
	});
				
	var pre = new Presupuesto('');		
	pre.anio = parseInt(anio);
	pre.montoAsignado     = montoAsignado;
	pre.montoAmortizable  = parseFloat( deformatDLA( $("#montoAmortizableVal").val()));	  		
	pre.apartados = apartados;	
	return pre;
}

String.prototype.replaceAll = function(target, replacement) {
	  return this.split(target).join(replacement);
};