package com.mx.dla.dda.admin.catalogos.pais.bos;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.admin.catalogos.pais.daos.CatalogoPaisDAO;
import com.mx.dla.dda.admin.catalogos.pais.dtos.CatalogoPaisDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

@Service
public class CatalogoPaisBO {

	@Autowired
	private CatalogoPaisDAO catalogoPaisDAO;

	public List<CatalogoPaisDTO> getCatalogoPais() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogoPaisDAO.getCatalogoPais();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public CatalogoPaisDTO getPaisPorId(int id) throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogoPaisDAO.getPaisPorId(id);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void updatePais(CatalogoPaisDTO pais) throws ResultMapException, SQLException, TransaccionException {
		try {
			catalogoPaisDAO.updatePais(pais);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void guardarPais(CatalogoPaisDTO pais) throws ResultMapException, SQLException, TransaccionException {
		try {
			catalogoPaisDAO.guardarPais(pais);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

}
