function importarExcel(datosExcel, idContrato) {    
	    
	$("#modalCarga").modal("hide");
    if(tipoSuscriptor == "s")
    {    	
    	var categorias = obtenerCategorias("divSuscriptores");    	
    	verificarFilaVacia("#divSuscriptores table.tSuscriptores");
    	agregarDatosSuscriptor(categorias, datosExcel.datosExcel, idContrato);    
    }    			
    else
    {    
    	var categorias = obtenerCategorias("divFlat");    	
    	agregarDatosFlat(categorias, datosExcel.datosExcel, idContrato);
    }    		    
}
 
function agregarDatosSuscriptor (categorias, datosExcel, idContrato) {	
	var numRangos  = $("#tabla" + idContrato + " tr[id=rangos] input[type='text']").length / 2;				
	var rangos;
	
	for(var i=1; i <datosExcel.length; i++)
	{		
		var categoria  = datosExcel[i].fila[0];
		var encontrada = false;
		rangos = obtenerRangos(datosExcel[i].fila.length-1, datosExcel[i].fila, numRangos);
		
		$("#tabla" + idContrato).find("tr.categoria").each(function(){						
			var inputs = $(this).find("td input[type='text']");		
			if(inputs[0].value == categoria)
			{				
				for(var j=0; j<rangos.length; j++)
					$(this).find("td:nth-child("+(j+2)+") input[type='text']").val(rangos[j].monto);
				encontrada = true;
			}						
		});
		
		if(!encontrada)
		{
			agregarFilaTablaSuscriptor(idContrato, nuevoCategoria, datosExcel[i].fila[0], rangos);
			agregarCategoriaSuscriptorDirecto(idContrato, datosExcel[i].fila[0]);								
		}
	}	
	
	bindingInputCategoria();	
	bindingInputValores();		
};

function obtenerRangos(numRangosExcel, fila, numRangos){	
	var rangosFila = numRangosExcel <= numRangos ? numRangosExcel : numRangos;
	var rangos     = [];
	
	for(var h=1; h<=rangosFila; h++ )							
		rangos.push({ "desde": "", "hasta": "", "idRango": "", "monto": validaValor(fila[h])});
		
	var diferencia = numRangos - numRangosExcel;												
			
	if( diferencia > 0)	
	   for(var l=0; l < diferencia; l++)					
		   rangos.push({ "desde": "", "hasta": "", "idRango": "", "monto": "" });																							
	return rangos;
}

function validaValor(valor){
	if(isNaN(valor) || valor == "")
		return "0";
	else 
		return formatCurrency(Number(unformatCurrency(valor)), 2);
} 

function obtenerAnios(numRangosExcel, fila, numPeriodos){									
	var rangosFila = numRangosExcel <= numPeriodos ? numRangosExcel : numPeriodos;
	var periodos   = [];
	
	for(var h=1; h<=numRangosExcel; h++ )							
		periodos.push({ "anio": 1, "costo": validaValor(fila[h]), "idPagoFlat": 0 });
		
	var diferencia = numPeriodos - numRangosExcel;												
			
	if( diferencia > 0)	
	   for(var l=0; l < diferencia; l++)					
		   periodos.push({ "anio": 1, "costo": "", "idPagoFlat": 0 });																							
	return periodos;
}

function agregarDatosFlat (categorias, datosExcel, idContrato) {    
	var numRangos  = $("#divFlat table:first tr.encabezado th").length - 2;		
	verificarFilaVacia("table.tFlat");
	for(var i=1; i <datosExcel.length; i++)
	{
		var encontrada = false;		
		var categoria  = datosExcel[i].fila[0];
		var anios      = obtenerAnios(datosExcel[i].fila.length-1, datosExcel[i].fila, numRangos);								
		$("table.tFlat").find("tr.categoria").each(function(){						
			var inputs = $(this).find("td input[type='text']");		
			if(inputs[0].value == categoria)
			{
				for(var j=0; j<anios.length; j++)
					$(this).find("td:nth-child("+(j+2)+") input[type='text']").val(anios[j].costo);
				encontrada = true;
			}						
		});
								
		if(!encontrada)
		{													
			agregarFilaVaciaTablaFlat();						
			for(var j=0; j<anios.length; j++)
				$("table.tFlat tr.categoria:last").find("td:nth-child("+(j+2)+") input[type='text']").val(anios[j].costo);
			$("table.tFlat tr.categoria:last").find("input[type='text']:first").val(categoria);
		}
		
	}		
	bindingInputCategoriaFlat();	
	bindingInputValores();		
};

function verificarFilaVacia(selector){
	$(selector).find("tr.categoria").each(function(){						
		var inputs = $(this).find("td input[type='text']");
		var vacia  = true;
		for(var j=0; j<inputs.length; j++)
		{
			if(inputs[0].value != "")
			   vacia = false;
		}		
		if(vacia)
		   $(this).remove();
	});
}

function obtenerCategorias (tipoFees) {    	
	var categorias = [];	
	$("#"+ tipoFees +" table:first").find("tr.categoria").each(function(){					
	    var categoria = { "descCategoria": "", "idCategoria": "", "rangos": null };
	    var inputs       = $(this).find("td input[type='text']");																			    	
	    categoria.descCategoria = inputs[0].value;
	    categoria.idCategoria   = $(this).attr("id");
		categorias.push(categoria);
	});	
	
	if(categorias.length == 1 && categorias[0].descCategoria == "")
	   categorias = [];
	return categorias;
};

function eliminarFilasSuscriptorPeriodo(idPeriodo){
	$("#tabla"+idPeriodo).find("tr.categoria").each(function(){					
	    $(this).remove();
	});	
}

function eliminarFilasFlatPeriodo(){
	$("#divFlat table:first").find("tr.categoria").each(function(){					
	    $(this).remove();
	});
	
	var i=0;
	$("#divFlat table:first").find("tr.eliminarCol td").each(function(){
		if(i!=0)
	       $(this).remove();
		i++;
	});
}

function cargarPeriodosExcel(){	
	$("#periodoExcel").find("option").remove();
	$("#divSuscriptores div.periodo").each(function(){
		var fechaInicio = $(this).find("input[type='text']")[0].value;
		var fechaFin    = $(this).find("input[type='text']")[1].value;
		var idPeriodo   = $(this).attr("id").substring(10, $(this).attr("id").length);
		if(fechaInicio != "" && fechaFin != "")			   
		   $("#periodoExcel").append($("<option/>").val(idPeriodo).text(fechaInicio +"-"+fechaFin));   			   			  			      		
	});    		    			
}

function showDialogosExcel(){	
	if(tipoSuscriptor == "s")
	{    					
		if($("#periodoExcel").find("option").length == 0 || $("#periodoExcel").val() == null)
			$("#labErroExcel").text("No existen periodos para agregar. Registrar fecha del per\u00EDodo a cargar.").show();
		else
		{			
			$('#dialogPeriodoExcel').modal('hide');
			$('#modalCarga').modal('show');
		}
	} 
	else
	{
		$('#dialogPeriodoExcel').modal('hide');
		$('#modalCarga').modal('show');
	}	
}

function descargarPlantilla(){
	$.post( contextPath + '/contrato/fees/descargaTemplate.action', {request : tipoSuscriptor})
	.done(function( response ) 
	{
		if(response.msgError != null)
	       showError(response.msgError);
		else
			window.location = contextPath + "/contrato/fees/descargaTemplate.action?request="+tipoSuscriptor;
	});
}