$('#modalTitulosContrato').on('shown.bs.modal', function() {
	tituloController = new TituloControllerTitulos();
});


function TituloControllerTitulos() {
	this.grid = new TituloGridTitulos("tituloGrid2");
};

function TituloGridTitulos(gridId) {
	this.gridId = gridId;
	this.grid = null;
	var me = this;
	this.columnsFijas = [
		{ label: 'Estatus contrato', name: 'estatusContrato', width: 100, hidden: false },
		{ label: 'Nombre unico', name: 'nombreUnico', width: 200, hidden: false },
		{ label: 'Nombre T&iacute;tulo', name: 'nombreTitulo', width: 200, hidden: false },
		{ label: 'Id SAP', name: 'idSap', width: 100, hidden: false },
		{ label: 'Subnumero', name: 'subnumero', width: 100, hidden: false },
		{ label: 'Notificado', name: 'notificado', width: 150, hidden: false },
		{ label: 'Estatus T&iacute;tulo', name: 'estatusTitulo', width: 100, hidden: false },
		{ label: 'Estatus SAP', name: 'estatusSap', width: 500, hidden: false }
	];
	this.columns = this.columnsFijas.concat([]);
	this.reload();
}

TituloGridTitulos.prototype.getColumns = function() {
	return this.columns;
};

TituloGridTitulos.prototype.reload = function() {
	this.genericLoadData(this.getData);
};


TituloGridTitulos.prototype.reloadDetails = function(nu) {
	this.genericLoadData(this.getDetails, nu);
};


TituloGridTitulos.prototype.genericLoadData = function(loadData, nu) {
	var me = this;
	$("#dynTitulosGrid2").html("<table id='tituloGrid2'></table><div id='tituloGridPager'></div>");
	var items = loadData(nu);
	$("#loadingDiv2").hide();
	if (items != null && items.length > 0) {
		$("#dynTitulosGrid2").show();
		this.init(items);
	} else {
		$("#warningDiv2").show();
	}
}

function cerrarElementos2() {
	$("#warningDiv2").hide();
	$("#loadingDiv2").show();
	$("#dynTitulosGrid2").hide();
}

TituloGridTitulos.prototype.getData = function() {
	var items = {};
	var jsonString = '{"contratoDda" : "' + $("#idContrato").val() + '"}';
	var stringJson = JSON.parse(jsonString);
	$.ajax({
		url: contextPath + '/contrato/generales/titulosContratoTitulosBroadView',
		type: "POST",
		data: stringJson,
		async: false,
		success: function(ret) {
			items = ret.titulosCnt;
			$("#lblNumContrato2").text(ret.numContrato);
		}
	});
	return items;
};

TituloGridTitulos.prototype.init = function(items) {
	var me = this;
	me.grid = $("#" + me.gridId).jqGrid({
		data: items,
		datatype: "local",
		loadonce: true,
		colModel: me.columns,
		viewrecords: false,
		shrinkToFit: false,
		width: 885,
		height: 250,
		multiselect: false,
		rowNum: 30000,
		loadComplete: function(data) {
			$("#" + me.gridId + ' tbody  tr#1 > td').css({ 'font-weight': 'bold', 'background-color': '#ffffcc' });
			$("#" + me.gridId + '_frozen tbody  tr#1 > td').css({ 'font-weight': 'bold', 'background-color': '#ffffcc' });
			$("#" + me.gridId + ' tbody  tr#1 > td').css({ 'font-weight': 'bold', 'padding-left': '1px' });
			$("#" + me.gridId + '_frozen tbody  tr#1 > td').css({ 'font-weight': 'bold', 'padding-left': '1px' });
		}
	});
	$("#" + me.gridId).jqGrid('setFrozenColumns');
};
