
var montosIniciales = [];
var formaValida     = true;

$(document).ready(function() {				
		cargaInicialCondicional();						   	
		inicializarInputs();
		$("#formaId").validate();
								
		$('#botonGuardar').click(function() {						
			    $('#estudioEleccion').attr('disabled', false);			    	
			    var jsonNotaCredito = null;
			    var idNotaCredito = $("#notaCreditoIdentificador").val();
			    var approved = $("#approved").is(':checked') ? 1 : 0;
			    var comentario = $("#comentario").val();
			    var fechaFactura = $("#fechaNotaCredito").val();
			    var idEstudio = $("#estudioEleccion").val();
			    var numeroFactura = $("#numeroFactura").val();
	    	    var montoNotaCredito =  $("#montoNotaCredito").val();
	    	    
	    	    var inputsValidos = validaInputsForma(idEstudio, numeroFactura, fechaFactura, comentario);

	    	    if(inputsValidos){

			    var i = 0;
			    var j = 0;
			    
				jsonNotaCredito = '{"notaCredito.idNota" : "'  + idNotaCredito +  
				                   '", "notaCredito.approved" : "'  + approved + 
					               '", "notaCredito.comentario" : "'  + comentario + 
					               '", "notaCredito.fechaFactura" : "'  + fechaFactura + 
					               '", "notaCredito.idEstudio" : "'  + idEstudio + 
					               '", "notaCredito.numeroFactura" : "'  + numeroFactura + 
					               '", "notaCredito.monto" : "'  + montoNotaCredito ;
				               
				$("#tFacturaDetalle tr[id^=idC]").each(function(){    	
					var idContrato    = parseInt($(this).attr("id").substring(4,$(this).attr("id").length));	
			    	var idSap = $(this).attr("idSap");
			    	var claveIva = $(this).attr("claveIva");
			    	var montoContrato =  $(this).find("td:last-child").text();
		    	    
		    	    if (validaNuloUndefinido(montoContrato) !== 0 )
		    	    	montoContrato = unformatCurrency(montoContrato);
		    	    
		    	    if( validaNuloUndefinido(idSap) === 0)
		    	    	idSap = null;

			    	jsonNotaCredito = jsonNotaCredito + 
			    	 '", "notaCredito.contratos['+ i +'].idContrato" : "'  + idContrato + 
			    	 '", "notaCredito.contratos['+ i +'].idSap" : "'  + idSap + 
			    	 '", "notaCredito.contratos['+ i +'].claveIva" : "'  + claveIva + 
			    	 '", "notaCredito.contratos['+ i +'].monto" : "'  + montoContrato; 

					$("#tFacturaDetalle tr[id^=idM-"+ idContrato +"]").each(function(){ 
						
				    	var montoInput = $(this).find("input:last");
				    	
			    		if(montoInput.attr("valido") == "true"){

			    		    if(montoInput.attr("guardar") == "true"){
 
				    	       var monto =  montoInput.val();
				    	       if (validaNuloUndefinido(monto) !== 0 )
				    		      monto = unformatCurrency(monto);
				    	
						       var descTitulo   = montoInput.attr("mes"); 
						       var idTituloCnt = montoInput.attr("idTto");
						       var nuevo = $(this).find("input:last").attr("nuevo");				    				    
						       
						    	jsonNotaCredito = jsonNotaCredito + 
						    	 '", "notaCredito.contratos['+ i +'].titulos['+ j +'].idTituloCnt" : "'  + idTituloCnt + 
						    	 '", "notaCredito.contratos['+ i +'].titulos['+ j +'].descTitulo" : "'  + descTitulo + 
						    	 '", "notaCredito.contratos['+ i +'].titulos['+ j +'].monto" : "'  + monto + 
						    	 '", "notaCredito.contratos['+ i +'].titulos['+ j +'].nuevo" : "'  + nuevo; 
						    	j++;
			    		    }
						
			    		}else 
			    			formaValida = false;
						
					});
					
			    	i++;
			    	j = 0;
				
				});
				
				jsonNotaCredito = jsonNotaCredito +  '"}';
				

			    if(formaValida)
			    {
			    	realizaGuardadoNotaCredito(jsonNotaCredito);
			    }						       					
			    else 		
				   showError("Los valores ingresados no fueron v\u00E1lidos.");		
			    
	    	    }
	    });							
});

function generarDatosRest(){
	var pagado    = 0;
	var contratos = [];
	
	$("#tFacturaDetalle tr[id^=idC]").each(function(){    	
		var contrato = new ContratoModelo();		 			
		var idCto    = parseInt($(this).attr("id").substring(4,$(this).attr("id").length));
		contrato.contratoDesc = $(this).find("td:nth-child(1)").find("ins").html();		
		contrato.monto        = parseFloat(unformatCurrency($(this).find("td:nth-child(3)").text()));
		contrato.idSapCto     = $(this).attr("sap");
		   
		contrato.idContrato = idCto;
		contratos.push(contrato);						    	    	
	});
	
	var aprovada = $("#approved").is(':checked') ? 1 : 0;
		var fecha = $("#fechaNotaCredito").val().split("/");
		var factura = {numeroFactura: $("#numeroFactura").val(), monto : $("#montoNotaCredito").val(), contratos : contratos, 
				       approved : aprovada, idEstudio: $("#estudioEleccion").val(), fechaFactura: fecha[2]+"-"+fecha[0]+"-"+fecha[1]}
		
		return $("#restCto").val(JSON.stringify(factura));
}

function inicializarInputs(){
	$("#approved").click(function () {
		var valor = $("#approved").val();
		if ( valor === "1")
			confirm("Aviso", "Aprobar la factura evitara cualquier futura edici\u00F3n.");
	});
}

function cargaInicialCondicional(){	
	var idNotaCredito = $('#notaCreditoIdentificador').val();
	var aprobada  = $("input[name='notaCredito.approved']:checked").val();
	
	if ( validaNuloUndefinido(idNotaCredito) === 0)
	{				 		 
		
		 $('#botonConsultarFactura').append(crearBotonConsultaDetalle());
		 		 
		 $("input[type=radio][value=0]").attr('checked', true);
		 		 
		 $('#estudioEleccion').change(function() {
			    $('#facturaDetalleContainer').remove();
		 });		 		 
		 
		 $('#divInputFactura').hide();
		 $('#divComentario').hide();		 
		 $('#divRadio')     .hide();
		 $('#botonGuardar') .hide();		 
	}
	else
	{	
		
		realizaCargaDetalleNotasCredito();
		 $('#estudioEleccion').attr("disabled", true); 	
		
	}
}    

function crearBotonConsultaDetalle(){
	var botonAgregar = $("<button/>").attr("id", "botonConsultarFacturaDetalle").attr("type", "button")
	                    .addClass("btn btn-info").text("Consultar contratos");
	
	botonAgregar.click(function() {
   	 				
		   var estudioEleccion = $('#estudioEleccion').val();
   	 
		   if (validaNuloUndefinido(estudioEleccion) != 0)
		   {
			   $("#tFacturaDetalle").remove();
			   realizaCargaDetalleNotasCredito();
			   $('#divInputFactura').show();
			   $('#divComentario').show();
			   $('#divRadio')     .show();
			   $('#botonGuardar') .show();
		   }			   
   	       else 
   		       showError("Seleccione un valor de Estudio v\u00E1lido");   		      		

    });	
    return botonAgregar;
}

function realizaCargaDetalleNotasCredito(){		
		 var eleccionEstudio      = $('#estudioEleccion').val();
		 var identificadorNotaCredito = $('#notaCreditoIdentificador').val();
		 var notaCreditoAprobada      = $("input[name='notaCredito.approved']:checked").val();
		  if (validaNuloUndefinido(eleccionEstudio) == 0)
			  eleccionEstudio = null;
		  		 
		  if (validaNuloUndefinido(identificadorNotaCredito) == 0)
			  identificadorNotaCredito = null;
		  		  
		  if (validaNuloUndefinido(notaCreditoAprobada) == 0)
			  notaCreditoAprobada = 0;		  
		  
		 var jsonString = '{"idEstudio" : ' + eleccionEstudio + ', "idNotaCredito" : ' + identificadorNotaCredito + ', "aprobado" : ' + notaCreditoAprobada +'}';
		 var stringJson = JSON.parse(jsonString);
 
		 $.ajax({
		     url: contextPath + "/ncredito/general/obtenerDetalleNotaCredito",
		     type: 'POST',
		     data:  stringJson, 
			 dataType: "json",
		     success:function(response){ 
		    	 generaTablaDetalle(response, notaCreditoAprobada);        
		     },
		     error:function(jqXhr, textStatus, errorThrown){
		         alert("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
		     }
		 });
}


function realizaGuardadoNotaCredito(notaCredito){

	 var stringJson = JSON.parse(notaCredito);
	 
	 $.ajax({
	     url: contextPath + "/ncredito/general/guardarNotaCredito",
	     type: 'POST',
	     data:  stringJson, 
		 dataType: "json",
	     success:function(response){ 
	    	 $('#notaCreditoIdentificador').val(response.idNotaCredito);
	    	 desactivaInputsAprobada(response.aprobado);
             showMessage("La factura se ha guardado con exito");
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         alert("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
	     }
	 });
}

function validaNuloUndefinido(variable){	
	if( (variable === null && typeof variable === "object") ||
	    (variable === undefined && typeof variable === "undefined") ||
	    (variable === "" && typeof variable === "string")
	  )
	    return 0;
	else  return variable;	
}

function formatCurrency(unformatedCurrency, n, x) {
	var re = '\\d(?=(\\d{' + (x || 3) + '})+' + (n > 0 ? '\\.' : '$') + ')';
	return unformatedCurrency.toFixed(Math.max(0, ~~n)).replace(new RegExp(re, 'g'), '$&,');
};

function unformatCurrency(formatedCurrency) {
	return String(formatedCurrency).replace(/ /g, "").replace(/,/g, "").replace("$", "");
};

function validateCurrency(currencyString, decimales) {
	var currency_regex = /(?=.)^\$?(([1-9][0-9]{0,2}(,[0-9]{3})*)|[0-9]+)?(\.[0-9]{1,4})?$/;
	return currency_regex.test(currencyString);
}

function validateDate(dt){
    var date_regex = /^(?:(0[1-9]|1[012])[\/.](0[1-9]|[12][0-9]|3[01])[\/.](19|20)[0-9]{2})$/;
    return date_regex.test(dt);
}

function valida(){
  if($("#numeroFactura").val().length>12)
  {
	  showError("Numero de factura demasiado largo");
	  return false;
  }
  else return true;  
}

function desactivaInputsAprobada(aprobada){
	
	 if(validaNuloUndefinido(aprobada) != 0)
	 {			 
		$('#estudioEleccion').attr("disabled", true); 		 
		$('#numeroFactura')   .prop('readonly', true);				
		$('#fechaNotaCredito')    .prop('disabled', true);
		$("input[type=radio]").attr('disabled', true);
		$('#comentario')      .attr('readonly', true);
		$('#botonGuardar').remove();	
		$("table td input").attr("readonly", true);
	 }	
	
}

function confirm(heading, question) {
    var confirmModal = 
        $('<div class="modal fade" id="myModal" role="dialog">'+
      '<div class="modal-dialog modal-sm">'+
        '<div class="modal-content">'+
          '<div class="modal-header">'+
            '<button type="button" class="close" data-dismiss="modal">&times;</button>'+
            '<h4 class="modal-title">' + heading +'</h4>'+
          '</div>'+
          '<div class="modal-body">'+
            '<p>' + question + '</p>'+
          '</div>'+
          '<div class="modal-footer">'+
            '<button type="button" class="btn btn-default" data-dismiss="modal">Ok</button>'+
          '</div>'+
        '</div>'+
      '</div>'+
    '</div>'); 
    confirmModal.modal('show'); 
};  

function validaMontoTotal(){
	if($("#montoNotaCredito").val() == "" || parseFloat(unformatCurrency($("#montoNotaCredito").val())) == 0)
		return false
	else
		return true;
}

function actualizaForma(){
	$("#tFacturaDetalle").remove();
	$("#botonGuardar").hide();
	$("#montoNotaCredito").val("");	
}

function validaInputsForma(idEstudio, numeroFactura, fechaFactura, comentario) {

	if (validaNuloUndefinido(comentario) === 0
			|| validaNuloUndefinido(comentario) !== 0
			&& comentario.trim() === "") {
		showError("Ingrese un Comentario");
		return false;
	} else if (validaNuloUndefinido(fechaFactura) === 0
			|| validaNuloUndefinido(fechaFactura) !== 0
			&& (fechaFactura.trim() === "" || validateDate(fechaFactura) === false)) {
		showError("Elija un valor de Fecha v\u00E1lido (MM/DD/YYYY)");
		return false;
	} else if (validaNuloUndefinido(numeroFactura) === 0
			|| validaNuloUndefinido(numeroFactura) !== 0
			&& numeroFactura.trim() === "") {
		showError("Capture un valor de Factura v\u00E1lido");
		return false;
	} else if (validaNuloUndefinido(idEstudio) === 0
			|| validaNuloUndefinido(idEstudio) !== 0 && idEstudio.trim() === "") {
		showError("Seleccione un valor de Estudio v\u00E1lido");
		return false;
	}
	
	return true;

}