package com.mx.dla.dda.contrato.titulos.bos;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

import com.mx.dla.dda.common.test.BaseDaoTest;
import com.mx.dla.dda.contrato.titulo.daos.TituloDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDmDAO;
import com.mx.dla.dda.contrato.titulo.dtos.SapNum;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;

public class TituloDAOTest extends BaseDaoTest{

	@Autowired
	protected TituloDAO tituloDAO;
	
	@Autowired
	private TituloDmDAO tituloDmDAO;

	@Test(enabled = false)
	public void buscaSerie1Capitulo(){
		List<Titulo> series = tituloDmDAO.buscaSerie1Capitulo(19l, "M");
		logger.debug(series.toString());
	}

	@Test(enabled = false)
	public void buscaSubNumDisminucion(){
		List<SapNum> disminuciones = tituloDmDAO.buscaSubNumDisminucion(1l);
		logger.debug(disminuciones.toString());
	}

	@Test(enabled = false)
	public void buscarTituloFiltroPaginado(){
		Titulo t = new Titulo();
		t.setIdLista(19l);
		List<Titulo> lista = tituloDmDAO.buscarTituloFiltroPaginado(t);
		logger.debug(lista.toString());
		
	}

}
