package com.mx.dla.dda.admin.catalogos.estudios.bos;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoEstudioDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.bos.BaseBO;

@Service
public class EstudioBO extends BaseBO {

	@Autowired
	private CatalogoEstudiosDAO catalogoEstudiosDAO;

	public List<CatalogoEstudioDTO> catalogoEstudios() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogoEstudiosDAO.catalogoEstudios();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public List<EstudioAddonDTO> catalogoEstudiosAddOn() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogoEstudiosDAO.catalogoEstudiosAddOn();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public void updateEstudio(CatalogoEstudioDTO estudio)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			catalogoEstudiosDAO.updateEstudio(estudio);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public CatalogoEstudioDTO guardarEstudio(String nombreEstudio)
			throws ResultMapException, SQLException, TransaccionException {
		CatalogoEstudioDTO estudioNuevo = new CatalogoEstudioDTO();
		estudioNuevo.setDescripcionEstudio(nombreEstudio);
		try {
			estudioNuevo.setIdGrupo(catalogoEstudiosDAO.findIdGrupoDefault());
			catalogoEstudiosDAO.guardarEstudio(estudioNuevo);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
		return estudioNuevo;
	}

	public CatalogoEstudioDTO catalogoEstudiosPorId(Integer id)
			throws ResultMapException, SQLException, TransaccionException {
		CatalogoEstudioDTO estudio = null;
		Integer num = null;
		try {
			estudio = catalogoEstudiosDAO.catalogoEstudiosPorId(id);
			num = catalogoEstudiosDAO.numContratosXEstuio(id.longValue());
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
		if (num != null && num.intValue() > 0)
			estudio.setTieneContratos(true);
		else
			estudio.setTieneContratos(false);
		logger.debug("Busca estudio");
		return estudio;
	}

	public void actulizaCatalogoEstudio(Long idEstudio, String sigla, Long campoGrupo, Integer esAddOn,
			String nombreAddOn) throws ResultMapException, SQLException, TransaccionException {

		CatalogoEstudioDTO estudio = new CatalogoEstudioDTO();
		estudio.setIdEstudio(idEstudio.intValue());
		estudio.setSiglaDda(sigla);
		estudio.setIdGrupo(campoGrupo);
		estudio.setEsAddOn(esAddOn);
		estudio.setAddOn(nombreAddOn);

		try {
			catalogoEstudiosDAO.actualizaEstudio(estudio);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public boolean seRepiteSigla(Long idEstudio, String sigla) {
		boolean ret = false;

		List<String> siglas = null;

		try {

			siglas = catalogoEstudiosDAO.obtenSiglaEstudios(idEstudio, sigla);

			for (String sig : siglas) {
				if (sigla.equals(sig)) {
					ret = true;
				}
			}

		} catch (PersistenceException e) {
			logger.error("Error : [{}]", e);
			ret = true;
        } catch (DataAccessException e) {
        	logger.error("Error : [{}]", e);
			ret = true;
        }

		return ret;
	}

}
