package com.mx.dla.dda.contrato.promociones.bos;

import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.contrato.promociones.daos.PromocionesDAO;
import com.mx.dla.dda.contrato.promociones.dtos.EstudiosPromocionesDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PaisesPromocionesDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PromocionDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PromocionTitulosDTO;
import com.mx.dla.dda.contrato.promociones.dtos.TitulosPromocionesDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.bos.BaseBO;

@Service
public class PromocionesBO extends BaseBO {

	@Autowired
	private PromocionesDAO promocionesdao;

	public List<PromocionDTO> obtenPromociones() throws TransaccionException {

		List<PromocionDTO> promociones = null;

		try {

			promociones = promocionesdao.obtenerPromociones();

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}

		return promociones;
	}

	public List<PromocionDTO> obtenPromocionesVigentes() throws TransaccionException {

		List<PromocionDTO> promociones = null;

		try {

			promociones = promocionesdao.obtenerPromocionesVigentes();

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}

		return promociones;
	}

	public void eliminarPromocion(Long id_promocion) throws TransaccionException {
		try {

			logger.info("se eliminara la promocion: " + id_promocion);
			promocionesdao.eliminaPromocion(id_promocion);

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}
	}

	public void eliminaTitulosPromocion(Long id_promocion) throws TransaccionException {
		try {

			logger.info("se eliminaran los Titulos de la Promo: " + id_promocion);
			promocionesdao.eliminaTitulosPromocion(id_promocion);

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}
	}

	public List<EstudiosPromocionesDTO> obtenerEstudios() throws TransaccionException {

		List<EstudiosPromocionesDTO> listaestudios = null;

		try {

			listaestudios = promocionesdao.obtenerEstudios();

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}

		return listaestudios;
	}

	public List<PaisesPromocionesDTO> obtenerPaises() throws TransaccionException {

		List<PaisesPromocionesDTO> listapaises = null;

		try {

			listapaises = promocionesdao.obtenerPaises();

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}

		return listapaises;
	}

	public List<TitulosPromocionesDTO> obtenerTitulos(Long id_pais, Long id_estudio) throws TransaccionException {

		List<TitulosPromocionesDTO> listatitulos = null;

		try {

			listatitulos = promocionesdao.obtenerTitulos(id_pais, id_estudio);

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}

		return listatitulos;
	}

	public List<TitulosPromocionesDTO> obtenerTitulosTodos(Long id_estudio) throws TransaccionException {

		List<TitulosPromocionesDTO> listatitulostodos = null;

		try {

			listatitulostodos = promocionesdao.obtenerTitulosTodos(id_estudio);

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}

		return listatitulostodos;
	}

	public List<PromocionTitulosDTO> obtenerPromocionTitulos(Long id_promocion) throws TransaccionException {

		List<PromocionTitulosDTO> promociontitulos = null;

		try {

			promociontitulos = promocionesdao.obtenerTitulosPromocion(id_promocion);

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}

		return promociontitulos;
	}

	public PromocionDTO creaPromocion(Long id_estudio, Long id_pais, String nombre_promocion, String fecha_inicio,
			String fecha_fin, String tipo_descuento, String descuento) throws TransaccionException {

		PromocionDTO promocion = new PromocionDTO();

		try {

			promocion.setId_estudio(id_estudio);
			promocion.setId_pais(id_pais);
			promocion.setNombre_promocion(nombre_promocion);
			promocion.setFecha_inicio(fecha_inicio);
			promocion.setFecha_fin(fecha_fin);
			promocion.setTipo_descuento(tipo_descuento);
			promocion.setDescuento(descuento);

			logger.info("Se creara la promocion: " + promocion);
			promocionesdao.crearPromocion(promocion);

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}
		return promocion;
	}

	public PromocionDTO actualizaPromocion(Long id_promocion, Long id_pais, String nombre_promocion,
			String fecha_inicio, String fecha_fin, String tipo_descuento, String descuento)
			throws TransaccionException {

		PromocionDTO promocion = new PromocionDTO();

		try {

			promocion.setId_promocion(id_promocion);
			promocion.setId_pais(id_pais);
			promocion.setNombre_promocion(nombre_promocion);
			promocion.setFecha_inicio(fecha_inicio);
			promocion.setFecha_fin(fecha_fin);
			promocion.setTipo_descuento(tipo_descuento);
			promocion.setDescuento(descuento);

			logger.info("Se actualizara la promocion: " + promocion);

			promocionesdao.actualizaPromocion(promocion);

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}

		return promocion;
	}

	public void registraPromocionTitulos(Long id_promocion, Long id_bv) throws TransaccionException {
		try {
			PromocionTitulosDTO promociontitulos = new PromocionTitulosDTO();
			promociontitulos.setId_bv(id_bv);
			promociontitulos.setId_promocion(id_promocion);
			promocionesdao.registraTitulosPromocion(promociontitulos);

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos.", e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos", e);
		}
	}

}
