package com.mx.dla.dda.reporte.cpview.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.springframework.beans.factory.annotation.Autowired;
import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.catalogos.bos.CatalogosBO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.reporte.cpview.bos.ReporteCostoPerViewBO;
import com.mx.dla.dda.reporte.cpview.dtos.ReporteCostPerViewVistaDTO;
import com.mx.dla.dda.reporte.cpview.dtos.VisualizacionesCostPerViewVistaDTO;
import com.mx.dla.dda.reporte.cpview.exception.ReportCostPerViewException;

public class ReporteCostoPerViewAction extends BaseContratoAction {

	private static final long serialVersionUID = -8363640992586901052L;
	private String fecha;
	private ReporteCostPerViewVistaDTO reporteVista;
	private VisualizacionesCostPerViewVistaDTO visualizacionesVista;
	private InputStream fileInputStream;
	private String fileName;
	private String tipoReporte;
	private File file;
	private String fileFileName;
	private String errorMensaje;
	private Long idEstudio;
	private String nombreUnico;
	private String temporada;
	private List<CatalogoDTO> estudios;
	private List<CatalogoDTO> peliculas_series;
	private List<CatalogoDTO> temporadas;

	@Autowired
	private ReporteCostoPerViewBO reporteCostoPerViewBO;

	@Autowired
	private CatalogosBO catalogosBO;

	public String execute() {
		return SUCCESS;
	}

	public String obtenerDatosReporteMensual() {
		try {
			logger.info("fecha: {}", fecha, idEstudio);
			logger.info("nombreUnico", nombreUnico);
			logger.info("temporada", temporada);
			reporteVista = reporteCostoPerViewBO.obtenerReporteMensualVista(fecha, idEstudio, nombreUnico, temporada,
					true);
			logger.info("getTabla: {}", reporteVista.getTabla());
			logger.info("getPheader: {}", reporteVista.getPheader());
			logger.info("getRheader: {}", reporteVista.getRheader());
		} catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String obtenerDatosReporteAnual() {
		try {
			logger.info("fecha: {} idEstudio: {}", fecha, idEstudio);
			logger.info("nombreUnico", nombreUnico);
			logger.info("temporada", temporada);
			reporteVista = reporteCostoPerViewBO.obtenerReporteAnualVista(fecha, idEstudio, nombreUnico, temporada,
					true);
			logger.info("getTabla: {}", reporteVista.getTabla());
			logger.info("getPheader: {}", reporteVista.getPheader());
			logger.info("getRheader: {}", reporteVista.getRheader());
		} catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String exportarReporte() {
		try {
			logger.info("{} {}", tipoReporte, fecha);
			logger.info("{}", idEstudio);
			fileInputStream = reporteCostoPerViewBO.obtenerStreamReporte(tipoReporte, fecha, idEstudio, nombreUnico,
					temporada);
		} catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ExcelMapperException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IOException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ReportCostPerViewException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String procesarArchivoVisualizacionesCarga() {
		logger.info("{} {}", file, fileFileName);
		logger.info("{}", fileName);
		UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
		try {
			logger.info("{}", usuario);
			reporteCostoPerViewBO.procesarStreamArchivoCarga(file, fileFileName, fecha, usuario.getExpediente());
		} catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IOException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ReportCostPerViewException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String obtenerDatosCargaVisualizacionesMensual() {
		try {
			logger.info("fecha: {}", fecha);
			visualizacionesVista = reporteCostoPerViewBO.obtenerCargaVisualizacionesMensualVista(fecha);
			logger.info("getTabla: {}", visualizacionesVista.getTabla());
			logger.info("getCorrectos: {}, getErroneos: {}", visualizacionesVista.getCorrectos(),
					visualizacionesVista.getErroneos());
			logger.info("getLeidos: {}", visualizacionesVista.getLeidos());
		} catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ReportCostPerViewException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String obtenerDatosCargaVisualizacionesPrincipal() {
		try {
			logger.info("fecha: {}", fecha);
			visualizacionesVista = reporteCostoPerViewBO.obtenCargaVisualizacionesPrincipalTabla(fecha);
			if(visualizacionesVista != null) {
				logger.info("getTabla: {}", visualizacionesVista.getTabla());
				logger.info("getCorrectos: {}, getErroneos: {}", visualizacionesVista.getCorrectos(),
						visualizacionesVista.getErroneos());
				logger.info("getLeidos: {}", visualizacionesVista.getLeidos());
			} else {
				logger.info("La fecha {} no tiene visualizaciones cargadas", fecha);
			}
		} catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ReportCostPerViewException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String descargarVisualizaciones() {
		try {
			logger.info("{} {}", tipoReporte, fecha);
			fileInputStream = reporteCostoPerViewBO.obtenerStreamVisualizaciones(fecha);
		} catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ExcelMapperException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IOException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String descargarPlantilla() {
		try {
			logger.info("{} {}", tipoReporte, fecha);
			fileInputStream = reporteCostoPerViewBO.obtenerStreamPlantilla();
		} catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalAccessException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (InvalidFormatException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ExcelMapperException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IOException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String inicializaCatalogos() {
		try {
			logger.info("{}", getEstudios());
			setEstudios(catalogosBO.obtenCatalogoEstudios(null, null, null, null, null, null, null, null, null, null));
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ResultMapException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String exportarZip() {
		try {
			logger.info("{} {}", tipoReporte, fecha);
			logger.info("{}", idEstudio);
			fileInputStream = reporteCostoPerViewBO.obtenerStreamZipReporte(tipoReporte, fecha);
		} catch (ParseException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (InvalidFormatException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (IOException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String obtenerSeriesyPeliculas() {
		try {
			logger.info("{}", getEstudios());
			setPeliculas_series(catalogosBO.obtenCatalogoPeliculasSeries(idEstudio));
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ResultMapException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return SUCCESS;
	}

	public String obtenerTemporada() {
		try {
			logger.info("{}", getEstudios());
			setTemporadas(catalogosBO.obtenCatalogoTemporadas(idEstudio, nombreUnico));
		} catch (IllegalArgumentException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (ResultMapException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (SQLException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		} catch (TransaccionException e) {
			errorMensaje = e.getMessage();
			logger.error("Error. {}", e);
		}
		return "TEMPORADAS";
	}

	public String getFecha() {
		return fecha;
	}

	public void setFecha(String fecha) {
		this.fecha = fecha;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getTipoReporte() {
		return tipoReporte;
	}

	public void setTipoReporte(String tipoReporte) {
		this.tipoReporte = tipoReporte;
	}

	public ReporteCostPerViewVistaDTO getReporteVista() {
		return reporteVista;
	}

	public void setReporteVista(ReporteCostPerViewVistaDTO reporteVista) {
		this.reporteVista = reporteVista;
	}

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}

	public String getFileFileName() {
		return fileFileName;
	}

	public void setFileFileName(String fileFileName) {
		this.fileFileName = fileFileName;
	}

	public VisualizacionesCostPerViewVistaDTO getVisualizacionesVista() {
		return visualizacionesVista;
	}

	public void setVisualizacionesVista(VisualizacionesCostPerViewVistaDTO visualizacionesVista) {
		this.visualizacionesVista = visualizacionesVista;
	}

	public String getErrorMensaje() {
		return errorMensaje;
	}

	public void setErrorMensaje(String errorMensaje) {
		this.errorMensaje = errorMensaje;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public List<CatalogoDTO> getEstudios() {
		return estudios;
	}

	public void setEstudios(List<CatalogoDTO> estudios) {
		this.estudios = estudios;
	}

	public List<CatalogoDTO> getPeliculas_series() {
		return peliculas_series;
	}

	public void setPeliculas_series(List<CatalogoDTO> peliculas_series) {
		this.peliculas_series = peliculas_series;
	}

	public List<CatalogoDTO> getTemporadas() {
		return temporadas;
	}

	public void setTemporadas(List<CatalogoDTO> temporadas) {
		this.temporadas = temporadas;
	}

	public String getNombreUnico() {
		return nombreUnico;
	}

	public void setNombreUnico(String nombreUnico) {
		this.nombreUnico = nombreUnico;
	}

	public String getTemporada() {
		return temporada;
	}

	public void setTemporada(String temporada) {
		this.temporada = temporada;
	}

}