package com.mx.dla.dda.admin.catalogos.addons.bos;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.admin.catalogos.addons.daos.CatalogoAddOnsDAO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.CatalogoAddOnDTO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.RelacionAddOnDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.dtos.PaisAddOnsVDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.bos.BaseBO;

@Service
public class AddOnBO extends BaseBO {

	@Autowired
	private CatalogoAddOnsDAO catalogoAddOnsDAO;

	public List<CatalogoAddOnDTO> catalogoAddOns() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogoAddOnsDAO.catalogoAddOns();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al solicitar los datos " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al solicitar los datos " + e);
		}
	}

	public void updateAddOn(CatalogoAddOnDTO addOn) throws ResultMapException, SQLException, TransaccionException {
		try {
			catalogoAddOnsDAO.updateAddOn(addOn);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public CatalogoAddOnDTO guardarAddOn(Integer idAddOn, Integer idEstudio, String pais, Integer revenueShare,
			Double precio, Double vat, Double precioNeto, Double vatFijo, Double precioNetoFijo, String tipoCambio,
			String calculoMontoXPais, String calculoRevenueShare, Double tarifaMinima, String preferido)
			throws ResultMapException, SQLException, TransaccionException {
		Long idRelacion = null;
		CatalogoAddOnDTO addOnNuevo = null;
		try {
			idRelacion = catalogoAddOnsDAO.obtenerIdRelacion(Long.valueOf(String.valueOf(idEstudio)),
					Long.valueOf(pais));

			// Si la Relacion NO EXISTE, entonces se crea.
			if (idRelacion == null) {
				RelacionAddOnDTO relacion = new RelacionAddOnDTO();
				relacion.setIdEstudio(Long.valueOf(String.valueOf(idEstudio)));
				relacion.setIdPaisAddOn(Long.valueOf(pais));
				relacion.setEstatus(1l);

				catalogoAddOnsDAO.crearNuevaRelacion(relacion);
				idRelacion = catalogoAddOnsDAO.obtenerIdRelacion(Long.valueOf(String.valueOf(idEstudio)),
						Long.valueOf(pais));
			}

			addOnNuevo = new CatalogoAddOnDTO();
			addOnNuevo.setIdAddOn(idAddOn);
			addOnNuevo.setIdRelacion(idRelacion);
			addOnNuevo.setRevenueShare(revenueShare);
			addOnNuevo.setPrecio(precio);
			addOnNuevo.setVat(vat);
			addOnNuevo.setPrecioNeto(precioNeto);
			addOnNuevo.setTipoDeCambio(tipoCambio);
			addOnNuevo.setCalculoMontoXPais(calculoMontoXPais);
			addOnNuevo.setCalculoRevenueShare(calculoRevenueShare);
			addOnNuevo.setTarifaMinima(tarifaMinima);
			addOnNuevo.setPreferido(preferido);
			addOnNuevo.setVatFijo(vatFijo);
			addOnNuevo.setPrecioNetoFijo(precioNetoFijo);

			if (preferido.equals("1")) {
				catalogoAddOnsDAO.actualizaPreferidoAddOn(addOnNuevo);
			} else {
				Long num = catalogoAddOnsDAO.numeroRelaciones(idRelacion.intValue());
				if (num == 0) {
					addOnNuevo.setPreferido("1");
				}
			}

			catalogoAddOnsDAO.guardarAddOn(addOnNuevo);
		} catch (DuplicateKeyException ex) {
			throw new DuplicateKeyException("PK: " + ex.getMessage());
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

		return addOnNuevo;
	}

	public CatalogoAddOnDTO catalogoAddOnsPorId(Integer idAddOn)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			CatalogoAddOnDTO addOn = catalogoAddOnsDAO.catalogoAddOnsPorId(idAddOn);
			logger.debug("Busca addOn");
			return addOn;
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public List<PaisAddOnsVDTO> obtenerPaisesAddOn() throws ResultMapException, SQLException, TransaccionException {
		try {
			return catalogoAddOnsDAO.obtenerPaisesAddOn();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void actulizaCatalogoAddOn(Integer idAddOn, Integer idEstudio, String pais, Integer revenueShare,
			Double precio, Double vat, Double precioNeto, Double vatFijo, Double precioNetoFijo, String tipoCambio,
			String calculoMontoXPais, String calculoRevenueShare, Double tarifaMinima, String preferido)
			throws ResultMapException, SQLException, TransaccionException {
		try {
			logger.debug("[{}]", idAddOn);

			Long idRelacion = catalogoAddOnsDAO.obtenerIdRelacion(Long.valueOf(String.valueOf(idEstudio)),
					Long.valueOf(pais));

			CatalogoAddOnDTO addOn = new CatalogoAddOnDTO();
			addOn.setIdAddOn(idAddOn);
			addOn.setIdRelacion(idRelacion);
			addOn.setRevenueShare(revenueShare);
			addOn.setPrecio(precio);
			addOn.setVat(vat);
			addOn.setPrecioNeto(precioNeto);
			addOn.setTipoDeCambio(tipoCambio);
			addOn.setCalculoMontoXPais(calculoMontoXPais);
			addOn.setCalculoRevenueShare(calculoRevenueShare);
			addOn.setTarifaMinima(tarifaMinima);
			addOn.setPreferido(preferido);
			addOn.setVatFijo(vatFijo);
			addOn.setPrecioNetoFijo(precioNetoFijo);

			if (preferido.equals("1")) {
				catalogoAddOnsDAO.actualizaPreferidoAddOn(addOn);
			}

			catalogoAddOnsDAO.actualizaAddOn(addOn);

			if (preferido.equals("0")) {
				Long num = catalogoAddOnsDAO.numeroRelacionesPreferidas(revenueShare, "1");
				if (num == 0) {
					addOn.setPreferido("1");
					catalogoAddOnsDAO.actualizaAddOn(addOn);
				}
			}

		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public boolean seRepitePais(String pais) throws ResultMapException, SQLException, TransaccionException {
		boolean ret = false;
		List<String> paises = null;

		try {
			paises = catalogoAddOnsDAO.obtenerPaisesAddOns();

			for (String sig : paises) {
				if (pais.equals(sig)) {
					ret = true;
				}
			}
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

		return ret;
	}

	public void eliminaprecioAddOn(Integer idAddOn, String preferido, Integer idRelacion) throws ResultMapException, SQLException, TransaccionException {
		try {
			catalogoAddOnsDAO.eliminaPrecioAddon(idAddOn);
			if (preferido.equals("SI")) {
				catalogoAddOnsDAO.actualizaPreferidoAddOnPorBorrado(idRelacion);
			}
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

}
