package com.mx.dla.dda.contrato.broadview.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.broadview.bos.ContratoBroadviewBO;
import com.mx.dla.dda.contrato.broadview.dtos.ContratoBroadviewDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.terminos.dtos.ContratoConsultaDTO;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.opensymphony.xwork2.Action;

public class ContratoBroadviewAction extends BaseContratoAction {
	
	private static final long serialVersionUID = 1L;

	private ContratoConsultaDTO contratoConsulta;
	private List<Titulo> titulosDdaActualizados;
	private Integer muestraTodos;
	private Long deal;

	private List<ContratoBroadviewDTO> broadviewTitulosListaNoAsignados;
	private List<Titulo> dlaTitulosContratoNoAsignados;

	private List<ContratoBroadviewDTO> broadviewTitulosListaAsignados;
	private List<Titulo> dlaTitulosContratoAsignados;

	@Autowired
	private ContratoBroadviewBO contratoBroadviewBO;

	public String load() {

		Long idCto = (Long) this.getSession().get("idContrato");

		this.setIdContrato(idCto);

		return Action.SUCCESS;
	}

	public String consultaBroadviewContrato() {

		Long idCto = (Long) this.getSession().get("idContrato");

		this.setIdContrato(idCto);

		deal = contratoBroadviewBO.consultaDealPorContrato(idCto);

		return Action.SUCCESS;

	}

	public String cargaInfoListas() {

		Long idCto = (Long) this.getSession().get("idContrato");

		this.setIdContrato(idCto);

		List<ContratoBroadviewDTO> broadviewTitulosLista = contratoBroadviewBO
				.cargaListaBroadViewTitulos(deal);
		List<Titulo> dlaTitulosLista = contratoBroadviewBO
				.cargaListaTitulosContrato(idCto);

		contratoBroadviewBO.asignaTitulosDDABroadviewPorDescripcion(
				broadviewTitulosLista, dlaTitulosLista);

		broadviewTitulosLista = contratoBroadviewBO.procesaBroadviewAsignados(
				broadviewTitulosLista, dlaTitulosLista, muestraTodos);

		dlaTitulosLista = contratoBroadviewBO.procesaDDAAsignados(
				dlaTitulosLista, muestraTodos);

		broadviewTitulosListaAsignados = contratoBroadviewBO
				.separaTitulosAsignadosBroadview(broadviewTitulosLista);
		broadviewTitulosListaNoAsignados = contratoBroadviewBO
				.separaTitulosNoAsignadosBroadview(broadviewTitulosLista);

		dlaTitulosContratoAsignados = contratoBroadviewBO
				.separaTitulosAsignadosDla(dlaTitulosLista);
		dlaTitulosContratoNoAsignados = contratoBroadviewBO
				.separaTitulosNoAsignadosDla(dlaTitulosLista);

		dlaTitulosContratoAsignados = contratoBroadviewBO
				.ordenaTitulosDdaAsignadosDlaPorBroadview(
						dlaTitulosContratoAsignados,
						broadviewTitulosListaAsignados);

		logger.info("idCto: " + idCto + ", broadviewTitulosLista: "
				+ broadviewTitulosLista + ", titulosContrato: "
				+ dlaTitulosLista + ", idContrato: " + this.getIdContrato()
				+ ", deal: " + deal + ", muestraTodos: " + muestraTodos);

		return Action.SUCCESS;

	}

	public String actualizaBroadviewContrato() {

		Long idCto = (Long) this.getSession().get("idContrato");
		
		this.setIdContrato(idCto);


		contratoConsulta.setIdContrato(idCto);
		contratoBroadviewBO.actualizaBroadviewContrato(contratoConsulta);
		return Action.SUCCESS;
	}

	public String actualizaTitulosDDA() {

		Long idCto = (Long) this.getSession().get("idContrato");
		
		this.setIdContrato(idCto);


		logger.info("titulosDdaActualizados ::: " + titulosDdaActualizados);

		contratoBroadviewBO.guardarTitulosListaContrato(titulosDdaActualizados,
				idCto);
		return Action.SUCCESS;
	}

	public List<ContratoBroadviewDTO> getBroadviewTitulosListaNoAsignados() {
		return broadviewTitulosListaNoAsignados;
	}

	public void setBroadviewTitulosListaNoAsignados(
			List<ContratoBroadviewDTO> broadviewTitulosListaNoAsignados) {
		this.broadviewTitulosListaNoAsignados = broadviewTitulosListaNoAsignados;
	}

	public List<Titulo> getDlaTitulosContratoNoAsignados() {
		return dlaTitulosContratoNoAsignados;
	}

	public void setDlaTitulosContratoNoAsignados(
			List<Titulo> dlaTitulosContratoNoAsignados) {
		this.dlaTitulosContratoNoAsignados = dlaTitulosContratoNoAsignados;
	}

	public List<ContratoBroadviewDTO> getBroadviewTitulosListaAsignados() {
		return broadviewTitulosListaAsignados;
	}

	public void setBroadviewTitulosListaAsignados(
			List<ContratoBroadviewDTO> broadviewTitulosListaAsignados) {
		this.broadviewTitulosListaAsignados = broadviewTitulosListaAsignados;
	}

	public List<Titulo> getDlaTitulosContratoAsignados() {
		return dlaTitulosContratoAsignados;
	}

	public void setDlaTitulosContratoAsignados(
			List<Titulo> dlaTitulosContratoAsignados) {
		this.dlaTitulosContratoAsignados = dlaTitulosContratoAsignados;
	}

	public ContratoConsultaDTO getContratoConsulta() {
		return contratoConsulta;
	}

	public void setContratoConsulta(ContratoConsultaDTO contratoConsulta) {
		this.contratoConsulta = contratoConsulta;
	}

	public List<Titulo> getTitulosDdaActualizados() {
		return titulosDdaActualizados;
	}

	public void setTitulosDdaActualizados(List<Titulo> titulosDdaActualizados) {
		this.titulosDdaActualizados = titulosDdaActualizados;
	}

	public Integer getMuestraTodos() {
		return muestraTodos;
	}

	public void setMuestraTodos(Integer muestraTodos) {
		this.muestraTodos = muestraTodos;
	}

	public Long getDeal() {
		return deal;
	}

	public void setDeal(Long deal) {
		this.deal = deal;
	}

}