package com.mx.dla.dda.contrato.generales.actions;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;

import com.mx.dla.admin.dtos.PermisoDTO;
import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.AreaDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

@Controller
@Scope("request")
public class ObtenerPermisosAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;

	private List<PermisoDTO> permisos;
	private AreaDTO area;
	private UsuarioDTO usuario;

	@Autowired
	private GeneralesBO generalesBO;

	@Override
	public String execute() throws TransaccionException {
		@SuppressWarnings("unchecked")
		List<PermisoDTO> permisosS = (List<PermisoDTO>) this.getSession().get("permisos");
		setUsuario((UsuarioDTO) this.getSession().get("usuario"));
		try {
			setArea(generalesBO.obtenerAreaPorExpediente(getUsuario().getExpediente()));
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SQLException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		setPermisos(permisosS);
		return SUCCESS;
	}

	public void setPermisos(List<PermisoDTO> permisos) {
		this.permisos = permisos;
	}

	public List<PermisoDTO> getPermisos() {
		return permisos;
	}

	public void setArea(AreaDTO area) {
		this.area = area;
	}

	public AreaDTO getArea() {
		return area;
	}

	public void setUsuario(UsuarioDTO usuario) {
		this.usuario = usuario;
	}

	public UsuarioDTO getUsuario() {
		return usuario;
	}
}
