function PresupuestoService(id) { this.id = id; }

PresupuestoService.prototype.cargarPresupuestos = function(tipo) {
	$.post(contextPath + '/presupuestos/catalogoPresupuestos/indexcargarPresupuestos.action', { tipo: tipo })
		.done(function(response) {
			if (response.mensaje != null)
				showError("Error al procesar la operaci\u00F3n.");
			else {
				if (tipo == "Amortizable")
					mostrarAmort(response.presupuestos);
				else
					mostrarNAmort(response.presupuestos);
				$("#tabs").show();
			}
		});
};

PresupuestoService.prototype.generarTablaListado = function(presupuestos) {
	var data = [];
	if (presupuestos != null) {
		for (var i = 0; i < presupuestos.length; i++) {
			var raw = [];
			raw.push(presupuestos[i].anio);
			raw.push(presupuestos[i].montoAsignado);
			raw.push(presupuestos[i].montoComprometido);
			data.push(raw);
		}
	}
	return data;
};

PresupuestoService.prototype.validarPresupuestoAmor = function(presupuesto) {
	var mensaje = "";

	//Se valida que el monto asignado no sea menor al comprometido x apartado
	for (var i = 0; i < presupuesto.apartados.length; i++) {
		if (presupuesto.apartados[i].montoAsignado < presupuesto.apartados[i].montoComprometido)
			mensaje = "Verifica Apartado " + presupuesto.apartados[i].nombre + " el monto asignado no puede ser menor al comprometido";
	}

	//Se valida que el monto asignado del presupuesto no sea mayor al amortizable
	if (presupuesto.montoAsignado > presupuesto.montoAmortizable)
		mensaje = "El Monto Asignado del Presupuesto no puede ser mayor al Monto Amortizable";
	return mensaje;
};

PresupuestoService.prototype.obtenerApartadosAnio = function(request) {
	$.post(contextPath + '/presupuestos/catalogoPresupuestos/indexcargarApartadosAnio.action', { tipo: request.type, anio: request.anio })
		.done(function(response) {
			if (response.mensaje != null)
				showError("Error al procesar la operaci\u00F3n.");
			else {
				$("#btnGuardar").prop("disabled", false);
				$("#labelProcesando").hide();

				if (request.type === "Amortizable")
					mostrarInformacionConsulta(response.presupuesto, parseInt(request.anio));
				else
					mostrarInformacionConsultaNoAmor(response.presupuesto, parseInt(request.anio));
			}
		});
};

PresupuestoService.prototype.guardarPresupuestos = function(presupuesto, tipo) {
	$.post(contextPath + '/presupuestos/catalogoPresupuestos/indexguardarPresupuesto.action', { mensaje: JSON.stringify(presupuesto) })
		.done(function(response) {
			if (response.mensaje != null) {
				service.obtenerApartadosAnio({ type: tipo, anio: presupuesto.anio });

				showWarn("Algunos valores no se registraron, favor de intentarlo de nuevo.");
				$("#btnGuardar").prop("disabled", false);
				$("#labelProcesando").hide();
			}
			else {
				service.obtenerApartadosAnio({ type: tipo, anio: presupuesto.anio });
				showMessage("Datos actualizados correctamente.");
				$("#btnGuardar").prop("disabled", false);
				$("#labelProcesando").hide();
			}
		});
};

PresupuestoService.prototype.getApartadoPresupuesto = function(presupuesto, id) {
	var apartado;
	for (var i = 0; i < presupuesto.apartados.length; i++)
		if (presupuesto.apartados[i].id == id)
			apartado = presupuesto.apartados[i];
	return apartado;
};

PresupuestoService.prototype.guardarRedistribucion = function(apartados, tipo, anio) {
	$.post(contextPath + '/presupuestos/catalogoPresupuestos/indexredistribuirPresupuesto.action', { mensaje: JSON.stringify(apartados), tipo: anio })
		.done(function(response) {
			if (response.mensaje != null) {
				$('#modalRedistribucion').modal('hide');
				showError("Error al procesar la redistribuci\u00F3n.");
				$("#btnGudDis").prop("disabled", false);
				$("#labelProcesandoDis").hide();
			}
			else {
				service.obtenerApartadosAnio({ type: tipo, anio: anio });
				showMessage("Se ha realizado la distribucion de manera exitosa.");
				$("#btnGudDis").prop("disabled", false);
				$("#labelProcesandoDis").hide();
				$('#modalRedistribucion').modal('hide');
			}
		});
};

PresupuestoService.prototype.guardarRedistribucionMontoDisp = function(apartados, tipo, anio) {
	$.post(contextPath + '/presupuestos/catalogoPresupuestos/indexredistribuirPresupuestoMontoDisp.action', { mensaje: JSON.stringify(apartados), tipo: anio })
		.done(function(response) {
			if (response.mensaje != null) {
				$('#modalRedistribucion').modal('hide');
				showError("Error al procesar la redistribuci\u00F3n.");
				$("#btnGudDis").prop("disabled", false);
				$("#labelProcesandoDis").hide();
			}
			else {
				service.obtenerApartadosAnio({ type: tipo, anio: anio });
				showMessage("Se ha realizado la distribuci\u00F3n de manera exitosa.");
				$("#btnGudDis").prop("disabled", false);
				$("#labelProcesandoDis").hide();
				$('#modalRedistribucion').modal('hide');
			}
		});
};
