function DatosAmortizacion(gridId) {
	this.gridId = gridId;
	this.grid = null ;	
	this.init();
};

DatosAmortizacion.prototype.reload = function() {
	var r = this.datos();
	var me = this;
	$("#idAmortizacionForm [name=totalTitulos]").val(r.totalTitulos);
	$("#idAmortizacionForm [name=totalMonto]").val(r.totalMonto);
	$("#"+me.gridId).setGridParam({data: r.amortizaciones , page:1}).trigger('reloadGrid');
	return r.amortizaciones;
};


DatosAmortizacion.prototype.datos = function() {
	var me = this;
	var r = {};
	$.ajax({
		url : contextPath+ '/contrato/titulos/buscaAmortizacionesTituloAsync.action',
		type : "post",
		async : false,
		success : function (ret)
		{
			r = ret.datosAmortizacion;
		}
	});
	
	return r;
};

DatosAmortizacion.prototype.itemsSelected = function() {
	var me = this;
	var ret = [];
	var rowId =$("#"+me.gridId).jqGrid('getGridParam','selarrrow');  
	rowId.forEach(function (e,i){
		var _t = jQuery("#"+me.gridId).getRowData(e);
		var _a = JSON.parse( _t.json);
		ret.push(_a);
	});
	return ret;
	
};

DatosAmortizacion.prototype.init = function() {
	var me = this;
	me.grid = $("#"+me.gridId).jqGrid({
        datatype: "local",
        colModel: [
                 			{ label: 'A&ntilde;o', name: 'value', width: 150 },
                			{ label: 'Total', name: 'desc', width: 150,formatter:'currency' },
                		],
		viewrecords: true,
		shrinkToFit:false,
		width: 300 ,
        height: 'auto',
        rowNum: 20,
        ondblClickRow : function (rowid, iRow, iCol, e) 
        {
        	var gridAmort = new AmortizacionGrid("amortizacionGrid"); 
        	
        	var _t = jQuery("#"+me.gridId).getRowData(rowid);
        	gridAmort.obtenerPintarDatos(_t.value);
        }
    });
	
	this.reload();
};
