package com.mx.dla.dda.contrato.terminos;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

import com.mx.dla.dda.common.test.BaseDaoTest;
import com.mx.dla.dda.contrato.terminos.daos.TerminosDAO;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoBD;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoServicioBD;

public class TerminoTest extends BaseDaoTest{

	@Autowired
	TerminosDAO terminosDAO;
	
	@Test(enabled = false)
	public void getTerminoAnticipoDAO(){
		TerminoBD t = terminosDAO.getTermino(20L);
		logger.debug(t.toString());
	}
	
	@Test(enabled = false)
	public void getTerminoMensualDAO(){
		TerminoBD t = terminosDAO.getTermino(20l);
		logger.debug(t.toString());
	}
	
	@Test(enabled = false)
	public void getTerminoExhibicionDAO(){
		TerminoBD t = terminosDAO.getTermino(20l);
		logger.debug(t.toString());
	}
	
	@Test(enabled = false)
	public void getTerminoPeriodicosDAO(){
		TerminoBD t = terminosDAO.getTermino(20l);
		logger.debug(t.toString());		
		List<TerminoBD> ts = terminosDAO.getTerminoPeriodicos(20l);
		logger.debug(ts.toString());
	}
	
	@Test(enabled = false)
	public void getTerminoTitulosDAO(){
		List<TerminoServicioBD> ts = terminosDAO.getTerminoTitulos(20l);
		logger.debug(ts.toString());
	}
	
	@Test(enabled = false)
	public void guardarTerminoDAO(){
		TerminoBD terminobd = new TerminoBD();
		terminobd.setIdContrato(20L);
		int op = 4;
		switch(op)
		{
			case 1://Se guarda anticipo
						
				terminobd.setAnticipoComentario("Anticipo");
				terminobd.setAnticipoFecha(new Date());		
				terminobd.setAnticipoMonto("200");
				terminobd.setComentarioGeneral("coment general");
				terminobd.setTotalTitulos("100");					
				terminosDAO.guardarTermino(terminobd);
				break;
			case 2:
				terminobd.setTipoPago("MENSUAL");
				terminobd.setComentarioGeneral("coment general");
				terminobd.setTotalTitulos("100");
				terminosDAO.guardarTermino(terminobd);
				break;
			case 3:
				terminobd.setTipoPago("PREDEFINIDO");			
				terminobd.setTipoPredefinido("EXHIBICION");			
				terminobd.setComentarioGeneral("coment general");
				terminobd.setTotalTitulos("100");
				terminosDAO.guardarTermino(terminobd);
				break;
			case 4:
				terminobd.setTipoPago("PREDEFINIDO");
				terminobd.setTipoPredefinido("PERIODICO");
				terminobd.setComentarioGeneral("coment general");
				terminobd.setTotalTitulos("100");
				terminosDAO.guardarTermino(terminobd);
				break;
		}		
	}
	
	@Test(enabled = false)
	public void guardarTerminoPagoDAO(){
		List<TerminoBD> pagoPeriodicos = new ArrayList<TerminoBD>();			
		
		TerminoBD pagoT = new TerminoBD();				
		pagoT.setMonto("100");				
		pagoT.setFecha(new Date());
		pagoT.setComentario("com");
		pagoT.setIdContrato(20L);
		pagoPeriodicos.add(pagoT);
								
		terminosDAO.guardarTerminoPago(pagoPeriodicos);
	}
	
	@Test(enabled = false)
	public void guardarServicioTituloDAO(){
			
		List<TerminoServicioBD> serviTitulos = new ArrayList<TerminoServicioBD>();
		
		TerminoServicioBD tituloServicio =  new TerminoServicioBD();
		tituloServicio.setCantidadTitulos("100");
		tituloServicio.setIdServicio(2l);
		tituloServicio.setPorcentajeTitulos("40");			
		serviTitulos.add(tituloServicio);
		
		terminosDAO.guardarServicioTitulo(serviTitulos, 20L);					
	}
	
}
