package com.mx.dla.dda.carga.suscriptor.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.carga.suscriptor.bos.CargaSuscriptorBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;

public class DescargaPlantillaAction extends BaseContratoAction{
	private static final long serialVersionUID = 1L;

	private InputStream fileInputStream;
	private String fileName;
	private Long id;
	private String tipo;
	private String empresas;
	
	
	@Autowired
	private CargaSuscriptorBO cargaSuscriptorBO;
	
	public String execute()  {
		String[] empresasSplited = {"Clarovideo Brazil", "Net Servicios", "Clarovideo Argentina", "Clarovideo Chile", 
									"Clarovideo Colombia", "Clarovideo Costa Rica", "Clarovideo Dominicana", "Clarovideo Ecuador", 
									"Clarovideo El Salvador", "Clarovideo Guatemala", "Clarovideo Honduras", "Clarovideo Mxico", 
									"Clarovideo Nicaragua", "Clarovideo Per", "Clarovideo Uruguay"};
		if(empresas != null && !empresas.equals("")){
			empresasSplited = empresas.split(",");
		}
		fileInputStream = new ByteArrayInputStream(cargaSuscriptorBO.obtenPlantilla(empresasSplited));
		fileName = "nombre";
		return SUCCESS;
	}
	
	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public String getFileName() {
		return fileName;
	}
	
	public void setId(Long id) {
		this.id = id;
	}
	
	public Long getId() {
		return id;
	}

	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	public String getTipo() {
		return tipo;
	}
	
	public void setEmpresas(String empresas) {
		this.empresas = empresas;
	}
	
	public String getEmpresas() {
		return empresas;
	}

}
