package com.mx.dla.dda.contrato.promociones.actions;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.promociones.bos.PromocionesBO;
import com.mx.dla.dda.contrato.promociones.dtos.EstudiosPromocionesDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PaisesPromocionesDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PromocionDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PromocionTitulosDTO;
import com.mx.dla.dda.contrato.promociones.dtos.TitulosPromocionesDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;

public class PromocionesAction extends BaseContratoAction {

	private static final long serialVersionUID = -6159275023094659946L;

	private List<PromocionDTO> promociones;
	private List<EstudiosPromocionesDTO> estudios;
	private List<PaisesPromocionesDTO> paises;
	private List<TitulosPromocionesDTO> titulos;
	private List<PromocionTitulosDTO> promociontitulos;
	private PromocionDTO promocion;
	private Long id_promocion;
	private Long id_pais;
	private Long id_estudio;
	private Long id_bv;
	private String nombre_promocion;
	private String fecha_inicio;
	private String fecha_fin;
	private String tipo_descuento;
	private String descuento;

	@Autowired
	private PromocionesBO promocionesBO;

	@Override
	public String execute() {

		return SUCCESS;
	}

	public String obtenerPromociones() throws TransaccionException {

		logger.info("Inicia.PromocionesAction.obtenerPromociones- : [{}]");
		try {
			promociones = promocionesBO.obtenPromociones();

			logger.info("PromocionesAction.obtenerPromociones- : [{}]" + promociones);

		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public String obtenerPromocionesVigentes() throws TransaccionException {

		logger.info("Inicia.PromocionesAction.obtenPromocionesVigentes - [{}]");
		try {
			promociones = promocionesBO.obtenPromocionesVigentes();

			logger.info("PromocionesAction.obtenPromocionesVigentes : [{}]" + promociones);

		} catch (TransaccionException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public String eliminaPromocion() {

		try {
			logger.info("Inicia eliminaPromocion  - [{}]" + id_promocion);

			promocionesBO.eliminarPromocion(id_promocion);

			return SUCCESS;

		} catch (TransaccionException e) {
			logger.error("ERROR - ACTION eliminaPromocion [{}]" + e);
			return ERROR;
		}
	}

	public String eliminaTitulosPromocion() {

		try {
			logger.info("Inicia eliminaTitulosPromocion  - [{}]" + id_promocion);

			promocionesBO.eliminaTitulosPromocion(id_promocion);

			return SUCCESS;

		} catch (TransaccionException e) {
			logger.error("ERROR - ACTION: eliminaTitulosPromocion [{}]" + e);
			return ERROR;
		}
	}

	public String obtenerPromocionTitulos() {

		try {
			logger.info("Inicia obtenerPromocionTitulos  - [{}]" + id_promocion);

			promociontitulos = promocionesBO.obtenerPromocionTitulos(id_promocion);

			return SUCCESS;

		} catch (TransaccionException e) {
			logger.error("ERROR - obtenerPromocionTitulos [{}]" + e);
			return ERROR;
		}
	}

	public String obtenerEstudios() throws TransaccionException {

		logger.info("Inicia.PromocionesAction.obtenerEstudios - [{}]");
		try {
			estudios = promocionesBO.obtenerEstudios();

			logger.info("PromocionesAction.obtenerEstudios : [{}]" + estudios);

		} catch (TransaccionException e) {
			logger.error("ERROR - PromocionesAction.obtenerEstudios [{}]" + e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public String obtenerPaises() throws TransaccionException {

		logger.info("Inicia.PromocionesAction.obtenerPaises - [{}]");
		try {
			paises = promocionesBO.obtenerPaises();

			logger.info("PromocionesAction.obtenerPaises : [{}]" + paises);

		} catch (TransaccionException e) {
			logger.error("ERROR - PromocionesAction.obtenerPaises [{}]" + e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public String obtenerTitulos() throws TransaccionException {

		logger.info("Inicia.PromocionesAction.obtenerTitulos - [{}]");
		try {

			titulos = promocionesBO.obtenerTitulos(id_pais, id_estudio);

			logger.info("PromocionesAction.obtenerTitulos : [{}]" + titulos);

		} catch (TransaccionException e) {
			logger.error("ERROR - PromocionesAction.obtenerTitulos [{}]" + e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public String obtenerTitulosTodos() throws TransaccionException {

		logger.info("Inicia.PromocionesAction.obtenerTitulos - [{}]");
		try {

			titulos = promocionesBO.obtenerTitulosTodos(id_estudio);

			logger.info("PromocionesAction.obtenerTitulos : [{}]" + titulos);

		} catch (TransaccionException e) {
			logger.error("ERROR - PromocionesAction.obtenerTitulos [{}]" + e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public String creaPromocion() throws TransaccionException {
		logger.info("Inicia.PromocionesAction.creaPromocion - [{}]");
		try {

			promocion = promocionesBO.creaPromocion(id_estudio, id_pais, nombre_promocion, fecha_inicio, fecha_fin,
					tipo_descuento, descuento);

			logger.info("PromocionesAction.creaPromocion : [{}]" + titulos);

		} catch (TransaccionException e) {
			logger.error("ERROR - PromocionesAction.creaPromocion [{}]" + e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public String actualizaPromocion() throws TransaccionException {
		logger.info("Inicia.PromocionesAction.actualizaPromocion - [{}]");
		try {

			promocion = promocionesBO.actualizaPromocion(id_promocion, id_pais, nombre_promocion, fecha_inicio,
					fecha_fin, tipo_descuento, descuento);

			logger.info("PromocionesAction.actualizaPromocion : [{}]" + titulos);

		} catch (TransaccionException e) {
			logger.error("ERROR - PromocionesAction.actualizaPromocion [{}]" + e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public String registraPromocionTitulos() throws TransaccionException {
		logger.info("Inicia.PromocionesAction.registraPromocionTitulos - [{}]");
		try {

			promocionesBO.registraPromocionTitulos(id_promocion, id_bv);

			logger.info("PromocionesAction.registraPromocionTitulos : [{}]" + titulos);

		} catch (TransaccionException e) {
			logger.error("ERROR - PromocionesAction.registraPromocionTitulos [{}]" + e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public Long getId_promocion() {
		return id_promocion;
	}

	public void setId_promocion(Long id_promocion) {
		this.id_promocion = id_promocion;
	}

	public List<PromocionDTO> getPromociones() {
		return promociones;
	}

	public void setPromociones(List<PromocionDTO> promociones) {
		this.promociones = promociones;
	}

	public List<EstudiosPromocionesDTO> getEstudios() {
		return estudios;
	}

	public void setEstudios(List<EstudiosPromocionesDTO> estudios) {
		this.estudios = estudios;
	}

	public List<PaisesPromocionesDTO> getPaises() {
		return paises;
	}

	public void setPaises(List<PaisesPromocionesDTO> paises) {
		this.paises = paises;
	}

	public List<TitulosPromocionesDTO> getTitulos() {
		return titulos;
	}

	public void setTitulos(List<TitulosPromocionesDTO> titulos) {
		this.titulos = titulos;
	}

	public Long getId_pais() {
		return id_pais;
	}

	public void setId_pais(Long id_pais) {
		this.id_pais = id_pais;
	}

	public PromocionDTO getPromocion() {
		return promocion;
	}

	public void setPromocion(PromocionDTO promocion) {
		this.promocion = promocion;
	}

	public Long getId_estudio() {
		return id_estudio;
	}

	public void setId_estudio(Long id_estudio) {
		this.id_estudio = id_estudio;
	}

	public String getNombre_promocion() {
		return nombre_promocion;
	}

	public void setNombre_promocion(String nombre_promocion) {
		this.nombre_promocion = nombre_promocion;
	}

	public String getFecha_inicio() {
		return fecha_inicio;
	}

	public void setFecha_inicio(String fecha_inicio) {
		this.fecha_inicio = fecha_inicio;
	}

	public String getFecha_fin() {
		return fecha_fin;
	}

	public void setFecha_fin(String fecha_fin) {
		this.fecha_fin = fecha_fin;
	}

	public String getTipo_descuento() {
		return tipo_descuento;
	}

	public void setTipo_descuento(String tipo_descuento) {
		this.tipo_descuento = tipo_descuento;
	}

	public String getDescuento() {
		return descuento;
	}

	public void setDescuento(String descuento) {
		this.descuento = descuento;
	}

	public Long getId_bv() {
		return id_bv;
	}

	public void setId_bv(Long id_bv) {
		this.id_bv = id_bv;
	}

	public List<PromocionTitulosDTO> getPromociontitulos() {
		return promociontitulos;
	}

	public void setPromociontitulos(List<PromocionTitulosDTO> promociontitulos) {
		this.promociontitulos = promociontitulos;
	}

}
