package com.mx.dla.dda.reporte.oyp.actions;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.List;

import javax.xml.stream.XMLStreamException;

import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.reporte.cpview.exception.ReportCostPerViewException;
import com.mx.dla.dda.reporte.oyp.bos.ReporteOveragesYPaymentsBO;
import com.mx.dla.dda.reporte.oyp.dtos.ReporteOveragesYPaymentsVistaDTO;

public class ReporteOveragesYPaymentsViewAction extends BaseContratoAction {

	private static final long serialVersionUID = -8363640992586901052L;
	private String fechaInicial;
	private String fechaFinal;
	private String tipoPago;
	private ReporteOveragesYPaymentsVistaDTO reporteVista;
	private InputStream fileInputStream;
	private Long idEstudio;
	private String claveReporte;
	private List<EstudioDTO> estudios;
	private String validaEstatusCarga;
	private String errorMensaje;

	@Autowired
	private ReporteOveragesYPaymentsBO reporteOveragesYPaymentsBO;

	public String obtenerDatosReporte() throws TransaccionException {

		try {

			logger.info("fechaInicial: {}", fechaInicial);
			logger.info("fechaFinal: {}", fechaFinal);
			logger.info("tipoPago: {}", tipoPago);
			logger.info("claveReporte: {}", claveReporte);
			logger.info("idEstudio: {}", idEstudio);
			logger.info("validaEstatusCarga: {}", validaEstatusCarga);

			reporteVista = reporteOveragesYPaymentsBO.obtenerReporteOveragesYPaymentsVista(fechaInicial, fechaFinal,
					tipoPago, claveReporte, idEstudio, validaEstatusCarga);

			logger.info("getTabla: {}", reporteVista.getTabla());

		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (InstantiationException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (IllegalAccessException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (IllegalArgumentException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (InvocationTargetException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (NoSuchMethodException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SecurityException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (ParseException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}

		return SUCCESS;
	}

	public String obtenerEstudios() {

		try {
			estudios = reporteOveragesYPaymentsBO.obtenerEstudios();
			logger.info("estudios: {}", estudios);
		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
		}

		return SUCCESS;
	}

	public String exportarReporte() throws TransaccionException {
		try {

			logger.info("fechaInicial: {}", fechaInicial);
			logger.info("fechaFinal: {}", fechaFinal);
			logger.info("tipoPago: {}", tipoPago);
			logger.info("claveReporte: {}", claveReporte);
			logger.info("idEstudio: {}", idEstudio);
			logger.info("validaEstatusCarga: {}", validaEstatusCarga);

			UsuarioDTO usuario = (UsuarioDTO) getSession().get("usuario");
			fileInputStream = reporteOveragesYPaymentsBO.obtenerStreamReporte(fechaInicial, fechaFinal, tipoPago,
					claveReporte, idEstudio, usuario.getExpediente(), validaEstatusCarga);

		} catch (ResultMapException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (IllegalArgumentException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (IllegalAccessException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (InstantiationException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (InvocationTargetException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (NoSuchMethodException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (SecurityException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (ParseException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (ExcelMapperException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (IOException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (ReportCostPerViewException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		} catch (XMLStreamException e) {
			logger.error("Error. {}", e);
			throw new TransaccionException("Ocurrio un error", e);
		}
		return SUCCESS;
	}

	public InputStream getFileInputStream() {
		return fileInputStream;
	}

	public void setFileInputStream(InputStream fileInputStream) {
		this.fileInputStream = fileInputStream;
	}

	public String getErrorMensaje() {
		return errorMensaje;
	}

	public void setErrorMensaje(String errorMensaje) {
		this.errorMensaje = errorMensaje;
	}

	public String getFechaInicial() {
		return fechaInicial;
	}

	public void setFechaInicial(String fechaInicial) {
		this.fechaInicial = fechaInicial;
	}

	public String getFechaFinal() {
		return fechaFinal;
	}

	public void setFechaFinal(String fechaFinal) {
		this.fechaFinal = fechaFinal;
	}

	public String getTipoPago() {
		return tipoPago;
	}

	public void setTipoPago(String tipoPago) {
		this.tipoPago = tipoPago;
	}

	public ReporteOveragesYPaymentsVistaDTO getReporteVista() {
		return reporteVista;
	}

	public void setReporteVista(ReporteOveragesYPaymentsVistaDTO reporteVista) {
		this.reporteVista = reporteVista;
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public String getClaveReporte() {
		return claveReporte;
	}

	public void setClaveReporte(String claveReporte) {
		this.claveReporte = claveReporte;
	}

	public List<EstudioDTO> getEstudios() {
		return estudios;
	}

	public void setEstudios(List<EstudioDTO> estudios) {
		this.estudios = estudios;
	}

	public String getValidaEstatusCarga() {
		return validaEstatusCarga;
	}

	public void setValidaEstatusCarga(String validaEstatusCarga) {
		this.validaEstatusCarga = validaEstatusCarga;
	}

}
