$().ready(function() {
});

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	     }
	 });
	
}

function procesaDetalleContratos(jsonData) {
	
	var contratos = jsonData.detalleContratos;
	
	if(contratos.length > 0){

		$("#campoContrato").prop( "disabled", false);
		$('#campoContrato').find('option').remove();
		$("#campoContrato").append('<option value="">Todos</option>');
		$("#botonConsultar").prop( "disabled", false);
		
		for(var i = 0; contratos.length; i++) {
			cnt = contratos[i];
			$("#campoContrato").append('<option value="' + cnt.idContrato + '">' + cnt.numeroContrato + '</option>');
		}
	}else {
		$("#campoContrato").prop( "disabled", true);
		$("#botonConsultar").prop( "disabled", true);
		$("#botonExportar").prop( "disabled", true);
		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', {colNames:[], colModel:[] ,data: [], datatype: 'local'}).trigger('reloadGrid');
		showError("El estudio seleccionado no tiene contratos asociados");
	}
	
}

function llamaObtenerDetalleContratos() {
	
	var jsonString = '{"idEstudio" : "' + $("#campoEstudio").val()+ '", "fechaInicio":"'+ $("#campoFechaInicio").val() + '", "fechaFin":"'+ $("#campoFechaFin").val() +'"}';
	var stringJson = JSON.parse(jsonString);
    callActionAjax( "/reporte/reportePago/detalleContrato", stringJson, procesaDetalleContratos);
    
}

var infoReporte = [];

function procesaReportePrincipal(jsonData) {
	
	var colNamesVar = [ 'ID BV', 'ACTIVO', 'MOVIMIENTO', 'FECHA NOTIF SAP', 'CODIGO DDA', 'DESC TITULO', 'CONTRATO DDA', 'FECHA INICIO', 'FECHA FIN', 'COSTO', 'FECHA CONTABILIZACION'];
	var colModelVar= [{name:'idBV',index:'concepto', width:80, frozen : true, sortable:false},
	                  {name:'idSAP',index:'m1', width:80, align:"right", sortable:false},
	                  {name:'movimiento',index:'m2', width:80, align:"right", sortable:false},
	                  {name:'fechaNotifSAP',index:'m3', width:80, align:"right", sortable:false},
	                  {name:'idTituloCNT',index:'m4', width:80, align:"right", sortable:false},
	                  {name:'descTitulo',index:'m5', width:80, align:"right", sortable:false},
	                  {name:'numeroContrato',index:'m6', width:80, align:"right", sortable:false},
	                  {name:'fechaInicio',index:'m7', width:80, align:"right", sortable:false},
	                  {name:'fechaFin',index:'m8', width:80, align:"right", sortable:false},
	                  {name:'costo',index:'m9', width:80, align:"right", formatter:"number", sortable:false},
	                  {name:'fechaContabilizacion',index:'m10', width:150, align:"right", sortable:false}];
	
	var colModelNames = ['idBV', 'idSAP', 'movimiento', 'fechaNotifSAP', 'idTituloCNT', 'descTitulo', 'numeroContrato', 'fechaInicio', 'fechaFin', 'costo', 'fechaContabilizacion'];
	
	var datos = jsonData.reporte;
	var header = jsonData.encabezado;
	
	var imarcar = 0;
	var porMarcar = [];
	var patron = /^[A-Z]{4}\d{5}[A-Z]$/;
	
	if(datos.length > 0) {
		
		for(var i = 0; i < datos.length; i++){
			if(patron.test(datos[i].concepto))
				porMarcar[imarcar++] = (i + 1);
		}
		
		$("#botonExportar").prop( "disabled", false);
		
		jQuery("#reporteTable").jqGrid({
			datatype: "local",
		   	colNames:colNamesVar,
		   	colModel:colModelVar,
		   	width: '1000',
		    height: '300',
		    rowNum: 999999,
		    autowidth: false,
		    shrinkToFit: false,
		   	multiselect: false,
		   	loadComplete: function(){
		   	}
		});
		
		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', {colNames:colNamesVar, colModel:colModelVar ,data: datos, datatype: 'local'}).trigger('reloadGrid');
	
		for(var i = 0; i < colModelNames.length; i++) {
			jQuery("#reporteTable").jqGrid('setLabel', colModelNames[i], header[i]);
		}
		jQuery("#reporteTable").jqGrid('setRowData', 1, false, 'totalContratoRowClass');
		for(var i = 0; i < porMarcar.length; i++) {
			jQuery("#reporteTable").jqGrid('setRowData', porMarcar[i], false, 'contratoRowClass');
		}
		 jQuery( "#reporteTable").jqGrid('setFrozenColumns');
		 infoReporte = datos;
	}else {
		showError("El contrato seleccionado no tiene t\u00EDtulos asociados.");
		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', {colNames:colNamesVar, colModel:colModelVar ,data: datos, datatype: 'local'}).trigger('reloadGrid');
		$("#botonExportar").prop( "disabled", true);
	}

}

function llamaReporteInfoAction(){ 
	var jsonString = '{"contrato" : "' + $("#campoContrato").val() + '", "estudio":"'+ $("#campoEstudio").val() + '", "mes":"'+ $("#campoMes").val()+ '"}'; 
	var stringJson = JSON.parse(jsonString);
    callActionAjax( "/reporte/movimientos/generaReporteMovimientosAction", stringJson, procesaReportePrincipal);
}

function descargarReporteEnExcel() {
	var url = contextPath +'/reporte/movimientos/reporteMovimientos.action?contrato=' + $("#campoContrato").val() + '&estudio=' + $("#campoEstudio").val() + '&mes=' + $("#campoMes").val();
   	window.open(url);
}
