package com.mx.dla.dda.admin.catalogos.addons.bos;

import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.bos.BaseBO;

@Component
public class EstudioAddonBO extends BaseBO {
	
	@Autowired
	private CatalogoEstudiosDAO estudiosDao;
	
	public List<EstudioAddonDTO> getEstudios() throws ResultMapException, SQLException, TransaccionException {
        try {
        	return estudiosDao.catalogoEstudiosAddOn();
        } catch (PersistenceException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        } catch (DataAccessException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        }

    }
	
	public void guardarAddon(EstudioAddonDTO addon) throws ResultMapException, SQLException, TransaccionException {
        try {
        	estudiosDao.guardarAddon(addon);
        } catch (PersistenceException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        } catch (DataAccessException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        }

    }

	public EstudioAddonDTO getEstudioById(Long idEstudio) throws ResultMapException, SQLException, TransaccionException {
        try {
        	return estudiosDao.catalogoEstudiosAddOnById(idEstudio);
        } catch (PersistenceException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        } catch (DataAccessException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        }

    }

	public boolean modificaAddon(EstudioAddonDTO addon) throws ResultMapException, SQLException, TransaccionException {
        try {
        	estudiosDao.updateAddon(addon);
    		return Boolean.TRUE;
        } catch (PersistenceException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        } catch (DataAccessException e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        }

    }

}
