/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.admin.catalogos.estudios.bos;

import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.admin.catalogos.estudios.dtos.CatalogoEstudioDTO;
import com.mx.dla.global.bos.BaseBO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EstudioBO
extends BaseBO {
    @Autowired
    private CatalogoEstudiosDAO catalogoEstudiosDAO;

    public List<CatalogoEstudioDTO> catalogoEstudios() {
        return this.catalogoEstudiosDAO.catalogoEstudios();
    }

    public List<EstudioAddonDTO> catalogoEstudiosAddOn() {
        return this.catalogoEstudiosDAO.catalogoEstudiosAddOn();
    }

    public void updateEstudio(CatalogoEstudioDTO estudio) {
        this.catalogoEstudiosDAO.updateEstudio(estudio);
    }

    public CatalogoEstudioDTO guardarEstudio(String nombreEstudio) {
        CatalogoEstudioDTO estudioNuevo = new CatalogoEstudioDTO();
        estudioNuevo.setDescripcionEstudio(nombreEstudio);
        estudioNuevo.setIdGrupo(this.catalogoEstudiosDAO.findIdGrupoDefault());
        this.catalogoEstudiosDAO.guardarEstudio(estudioNuevo);
        return estudioNuevo;
    }

    public CatalogoEstudioDTO catalogoEstudiosPorId(Integer id) {
        CatalogoEstudioDTO estudio = this.catalogoEstudiosDAO.catalogoEstudiosPorId(id.intValue());
        Integer num = this.catalogoEstudiosDAO.numContratosXEstuio(Long.valueOf(id.longValue()));
        if (num != null && num > 0) {
            estudio.setTieneContratos(true);
        } else {
            estudio.setTieneContratos(false);
        }
        this.logger.debug("Busca estudio");
        return estudio;
    }

    public void actulizaCatalogoEstudio(Long idEstudio, String sigla, Long campoGrupo, Integer esAddOn, String nombreAddOn) {
        CatalogoEstudioDTO estudio = new CatalogoEstudioDTO();
        estudio.setIdEstudio(Integer.valueOf(idEstudio.intValue()));
        estudio.setSiglaDda(sigla);
        estudio.setIdGrupo(campoGrupo);
        estudio.setEsAddOn(esAddOn.intValue());
        estudio.setAddOn(nombreAddOn);
        try {
            this.catalogoEstudiosDAO.actualizaEstudio(estudio);
        }
        catch (Exception e) {
            System.out.println("Error :" + e.getMessage());
        }
    }

    public boolean seRepiteSigla(Long idEstudio, String sigla) {
        boolean ret = false;
        List siglas = null;
        try {
            siglas = this.catalogoEstudiosDAO.obtenSiglaEstudios(idEstudio, sigla);
            for (String sig : siglas) {
                if (!sigla.equals(sig)) continue;
                ret = true;
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
            ret = true;
        }
        return ret;
    }
}

