/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.carga.suscriptor.bos;

import com.mx.dla.dda.admin.presupuestos.dtos.PlantillaDTO;
import com.mx.dla.dda.carga.suscriptor.daos.CargaSuscriptorDAO;
import com.mx.dla.dda.carga.suscriptor.dtos.CargaSuscripcionBD;
import com.mx.dla.dda.carga.suscriptor.dtos.CargaSuscripcionDTO;
import com.mx.dla.dda.carga.suscriptor.dtos.ParamCalculoCostoSuscriptoresDTO;
import com.mx.dla.dda.carga.suscriptor.dtos.ResponseCalculoCostoSuscriptoresDTO;
import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.EmpresaVentaDTO;
import com.mx.dla.dda.catalogos.dtos.PaisVentaDTO;
import com.mx.dla.dda.catalogos.dtos.RegionVentaDTO;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import com.mx.dla.global.bos.ReadExcelBO;
import com.mx.dla.global.dtos.FilaExcelDTO;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CargaSuscriptorBO
extends BaseBO {
    private final String[] meses = new String[]{"Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"};
    private final DecimalFormat formateador = new DecimalFormat("###,###");
    @Autowired
    private CargaSuscriptorDAO cargaSuscriptorDAO;
    @Autowired
    private CatalogosDAO catalogosDAO;
    @Autowired
    public DLARestClientFactory dlaRestClientFactory;
    @Autowired
    private ReadExcelBO readExcelBO;
    @Value(value="${uri.file.carga.suscriptores}")
    protected String uriCarga;
    private Map<Integer, Integer> mesesMap = new HashMap<Integer, Integer>();
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    private ExcelMapperContext excelMapperContext;

    public List<CargaSuscripcionDTO> getDatosSuscripcion(Integer mes, Integer anio) throws Exception {
        ArrayList<String> fechas = new ArrayList<String>();
        CargaSuscripcionDTO suscripcion = new CargaSuscripcionDTO();
        ArrayList<CargaSuscripcionDTO> listado = new ArrayList<CargaSuscripcionDTO>();
        try {
            Date inicio = this.crearFecha("01/" + mes + "/" + anio);
            block10: for (int i = 0; i <= 5; ++i) {
                this.mesesMap.put(i, this.getMesFecha(inicio, i));
                fechas.add(this.restarMesFecha(inicio, i));
                switch (i) {
                    case 1: {
                        suscripcion.setMes1(this.getFechaFormato(inicio, i));
                        continue block10;
                    }
                    case 2: {
                        suscripcion.setMes2(this.getFechaFormato(inicio, i));
                        continue block10;
                    }
                    case 3: {
                        suscripcion.setMes3(this.getFechaFormato(inicio, i));
                        continue block10;
                    }
                    case 4: {
                        suscripcion.setMes4(this.getFechaFormato(inicio, i));
                        continue block10;
                    }
                    case 5: {
                        suscripcion.setMes5(this.getFechaFormato(inicio, i));
                        continue block10;
                    }
                    case 0: {
                        suscripcion.setMesActual(this.getFechaFormato(inicio, i));
                    }
                }
            }
            listado.add(suscripcion);
            List empresas = this.catalogosDAO.getEmpresasVenta();
            List resultado = this.cargaSuscriptorDAO.obtenerCargaSuscripciones(fechas);
            boolean existeReg = false;
            boolean regActual = false;
            suscripcion = new CargaSuscripcionDTO();
            for (EmpresaVentaDTO empresa : empresas) {
                for (CargaSuscripcionBD carga : resultado) {
                    if ((long)empresa.getIdEmpresa().intValue() != carga.getIdEmpresa()) continue;
                    this.asignarValores(carga, suscripcion, mes);
                    existeReg = true;
                    if (carga.getMes().intValue() != mes.intValue()) continue;
                    regActual = true;
                }
                if (existeReg) {
                    if (!regActual) {
                        suscripcion.setMesActual("");
                        suscripcion.setIdCarga(Long.valueOf(0L));
                    }
                } else {
                    suscripcion.setIdEmpresa(empresa.getIdEmpresa());
                    suscripcion.setMesActual("");
                    suscripcion.setEmpresa(empresa.getDescripcion());
                    PaisVentaDTO pais = this.catalogosDAO.getPaisXId(empresa.getIdPais());
                    RegionVentaDTO region = this.catalogosDAO.getRegionXId(pais.getIdRegion());
                    suscripcion.setRegion(region.getDescripcion());
                    suscripcion.setIdEmpresa(empresa.getIdEmpresa());
                }
                this.formatearListado(suscripcion);
                this.logger.debug("suscripcion " + suscripcion.toString());
                listado.add(suscripcion);
                existeReg = false;
                regActual = false;
                suscripcion = new CargaSuscripcionDTO();
            }
        }
        catch (Exception e) {
            this.logger.error("{}", (Throwable)e);
            throw new Exception(e);
        }
        CargaSuscripcionDTO suspcionAux = (CargaSuscripcionDTO)listado.get(0);
        listado.remove(0);
        Collections.sort(listado);
        ArrayList<CargaSuscripcionDTO> listadoAux = new ArrayList<CargaSuscripcionDTO>();
        listadoAux.add(suspcionAux);
        listadoAux.addAll(listado);
        return listadoAux;
    }

    private void asignarValores(CargaSuscripcionBD itemBD, CargaSuscripcionDTO itemDTO, Integer mes) {
        itemDTO.setEmpresa(itemBD.getEmpresa());
        itemDTO.setRegion(itemBD.getRegion());
        itemDTO.setIdEmpresa(itemBD.getIdEmpresa());
        this.logger.debug("B:" + itemBD.toString());
        if (mes.intValue() == itemBD.getMes().intValue()) {
            itemDTO.setIdCarga(itemBD.getIdCarga());
            itemDTO.setMesActual(this.formateador.format(itemBD.getSuscriptores()));
        } else {
            for (int i = 1; i <= 5; ++i) {
                if (this.mesesMap.get(i).intValue() != itemBD.getMes().intValue()) continue;
                if (i == 1) {
                    itemDTO.setMes1(this.formateador.format(itemBD.getSuscriptores()));
                }
                if (i == 2) {
                    itemDTO.setMes2(this.formateador.format(itemBD.getSuscriptores()));
                }
                if (i == 3) {
                    itemDTO.setMes3(this.formateador.format(itemBD.getSuscriptores()));
                }
                if (i == 4) {
                    itemDTO.setMes4(this.formateador.format(itemBD.getSuscriptores()));
                }
                if (i != 5) continue;
                itemDTO.setMes5(this.formateador.format(itemBD.getSuscriptores()));
            }
        }
        this.logger.debug(itemDTO.toString());
    }

    public void actualizarSuscriptores(List<CargaSuscripcionDTO> suscriptores) throws Exception {
        String mes = "";
        try {
            for (CargaSuscripcionDTO item : suscriptores) {
                if (item.getIdCarga() == 0L && item.getMesActual() != null) {
                    mes = item.getFecha();
                    this.nuevoCargaSuscripcion(item);
                    continue;
                }
                if (item.getIdCarga() != 0L && item.getMesActual() != null) {
                    mes = item.getFecha();
                    this.updateCargaSuscripcion(item);
                    continue;
                }
                if (item.getIdCarga() == 0L || item.getMesActual() != null) continue;
                this.logger.info("idcarga:" + item.getIdCarga());
                this.cargaSuscriptorDAO.eliminarCarga(item.getIdCarga());
            }
        }
        catch (Exception e) {
            this.logger.error("{}", (Throwable)e);
            throw new Exception(e);
        }
        try {
            this.logger.info("Se inicia comunicacion para el calculo de costo.");
            ParamCalculoCostoSuscriptoresDTO request = new ParamCalculoCostoSuscriptoresDTO();
            request.setFechaMes(mes);
            DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.COSTO_SUSCRIPTORES);
            ResponseCalculoCostoSuscriptoresDTO response = client.get(request, ResponseCalculoCostoSuscriptoresDTO.class);
            this.logger.info("Se ha notificado Carga Suscriptores. Mensaje [" + response.getMensaje() + "]");
            this.logger.info("Se ha notificado Carga Suscriptores. Resultado [" + response.getResultado() + "]");
        }
        catch (Exception e) {
            this.logger.error("Error al notificar Carga Suscriptores.", (Throwable)e);
        }
    }

    private void nuevoCargaSuscripcion(CargaSuscripcionDTO suscriptor) {
        CargaSuscripcionBD itemBD = new CargaSuscripcionBD();
        itemBD.setIdEmpresa(suscriptor.getIdEmpresa());
        itemBD.setFecha(suscriptor.getFecha());
        itemBD.setSuscriptores(Integer.valueOf(Integer.parseInt(suscriptor.getMesActual().replace(",", ""))));
        this.cargaSuscriptorDAO.nuevoCargaSuscripcion(itemBD);
    }

    private void updateCargaSuscripcion(CargaSuscripcionDTO suscriptor) {
        CargaSuscripcionBD itemBD = new CargaSuscripcionBD();
        itemBD.setIdCarga(suscriptor.getIdCarga());
        itemBD.setSuscriptores(Integer.valueOf(Integer.parseInt(suscriptor.getMesActual().replace(",", ""))));
        this.cargaSuscriptorDAO.updateCargaSuscripcion(itemBD);
    }

    private void formatearListado(CargaSuscripcionDTO item) {
        if (item.getMes1() == null) {
            item.setMes1("");
        }
        if (item.getMes2() == null) {
            item.setMes2("");
        }
        if (item.getMes3() == null) {
            item.setMes3("");
        }
        if (item.getMes4() == null) {
            item.setMes4("");
        }
        if (item.getMes5() == null) {
            item.setMes5("");
        }
    }

    public String getFecha(Date fecha) {
        SimpleDateFormat fechaHora = new SimpleDateFormat("dd/MM/yyyy");
        return fechaHora.format(fecha);
    }

    public Date crearFecha(String valor) throws ParseException {
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd/MM/yy");
        Date fecha = formatter1.parse(valor);
        return fecha;
    }

    public String restarMesFecha(Date fecha, int mes) throws ParseException {
        Calendar calFecha = Calendar.getInstance();
        calFecha.setTime(fecha);
        calFecha.add(2, mes * -1);
        return "01/" + (calFecha.get(2) + 1) + "/" + calFecha.get(1);
    }

    public Integer getMesFecha(Date fecha, int mes) throws ParseException {
        Calendar calFecha = Calendar.getInstance();
        calFecha.setTime(fecha);
        calFecha.add(2, mes * -1);
        return calFecha.get(2) + 1;
    }

    public String getFechaFormato(Date fecha, int mes) {
        Calendar calFecha = Calendar.getInstance();
        calFecha.setTime(fecha);
        calFecha.add(2, mes * -1);
        return this.meses[calFecha.get(2)] + "-" + calFecha.get(1);
    }

    public List<CargaSuscripcionDTO> ordenar(List<CargaSuscripcionDTO> lista) {
        try {
            for (int j = 1; j < lista.size() - 1; ++j) {
                for (int i = 1; i < lista.size() - 1 - j; ++i) {
                    if (lista.get(i).getRegion().compareTo(lista.get(i + 1).getRegion()) <= 0) continue;
                    String aux = lista.get(i).getRegion();
                    lista.set(i, lista.get(i + 1));
                    lista.get(i + 1).setRegion(aux);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("{}", (Throwable)e);
        }
        return lista;
    }

    public Map<String, String> obtenInformacionExcel(File fileUpload, String fileName) {
        HashMap<String, String> informacionExcel = new HashMap<String, String>();
        List<FilaExcelDTO> listaInformacionExcel = null;
        try {
            listaInformacionExcel = this.readExcelBO.obtenerDatosExcel(this.uriCarga, fileUpload, fileName);
            for (FilaExcelDTO fila : listaInformacionExcel) {
                this.logger.debug("[{}] -- [{}]", fila.getFila().get(0), fila.getFila().get(1));
                informacionExcel.put((String)fila.getFila().get(0), (String)fila.getFila().get(1));
            }
        }
        catch (IOException e) {
            this.logger.error("[{}]", (Throwable)e);
            this.logger.debug("[{}]", (Throwable)e);
        }
        catch (ExcelMapperException e) {
            this.logger.error("[{}]", (Throwable)e);
            this.logger.debug("[{}]", (Throwable)e);
        }
        return informacionExcel;
    }

    public byte[] obtenPlantilla(String[] empresas) {
        byte[] plantilla = null;
        ArrayList<PlantillaDTO> lista = new ArrayList<PlantillaDTO>();
        ExcelMapper mapper = null;
        for (String emp : empresas) {
            PlantillaDTO li = new PlantillaDTO();
            li.setEmpresa(emp);
            lista.add(li);
        }
        try {
            mapper = this.excelMapperContext.getExcelMapper("plantillaCargaSuscriptores");
            plantilla = this.excelMapperTransform.transformObjectToExcel(lista, mapper, PlantillaDTO.class);
        }
        catch (Exception ex) {
            this.logger.error("[{}]", (Throwable)ex);
        }
        return plantilla;
    }
}

