/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.generales.bos;

import com.dla.dda.domain.constants.Operacion;
import com.dla.dda.domain.constants.OrigenCodes;
import com.dla.dda.domain.model.email.DetalleCorreoVO;
import com.dla.dda.domain.model.request.EmailRequest;
import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.common.bos.CommonRestBO;
import com.mx.dla.dda.contrato.common.bos.DocumentoBO;
import com.mx.dla.dda.contrato.common.bos.JustificacionBO;
import com.mx.dla.dda.contrato.common.dtos.DocumentoDTO;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.bos.OpcionesContratoBO;
import com.mx.dla.dda.contrato.generales.bos.ParametersWebService;
import com.mx.dla.dda.contrato.generales.daos.ValidacionGeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.AreaDTO;
import com.mx.dla.dda.contrato.generales.dtos.AutorizadorDTO;
import com.mx.dla.dda.contrato.generales.dtos.BundleReturn;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.CorreoExternoDTO;
import com.mx.dla.dda.contrato.generales.dtos.DetalleCorreoDTO;
import com.mx.dla.dda.contrato.generales.dtos.WFPasoDTO;
import com.mx.dla.dda.contrato.generales.dtos.WFSeguimientoDTO;
import com.mx.dla.dda.contrato.generales.enums.Estatus;
import com.mx.dla.dda.contrato.generales.enums.MensajeTexto;
import com.mx.dla.dda.contrato.generales.enums.TipoMensaje;
import com.mx.dla.dda.contrato.transaccion.titulos.daos.TituloLoteTransDAO;
import com.mx.dla.dda.contrato.ws.amortizacioncontrato.ParamCalcAmortCntDTO;
import com.mx.dla.dda.contrato.ws.amortizacioncontrato.ResponseCalcAmortCntDTO;
import com.mx.dla.dda.contrato.ws.dtos.ItemOrdenCompraDTO;
import com.mx.dla.dda.contrato.ws.dtos.ParamAdendumEnmiendaDTO;
import com.mx.dla.dda.contrato.ws.dtos.ParamOrdenCompraDTO;
import com.mx.dla.dda.contrato.ws.dtos.ResponseAdendumEnmiendaDTO;
import com.mx.dla.dda.contrato.ws.dtos.ResponseOrdenCompraDTO;
import com.mx.dla.dda.contrato.ws.validapresupuesto.ParamValidaPresupuestoCntDTO;
import com.mx.dla.dda.contrato.ws.validapresupuesto.ResponseValidaPresupuestoCntDTO;
import com.mx.dla.dda.contrato.ws.validarMinimoSeleccion.ParamValidaMinimoSeleccionDTO;
import com.mx.dla.dda.contrato.ws.validarMinimoSeleccion.ResponseValidaMinimoSeleccionDTO;
import com.mx.dla.dda.rest.services.client.JsonConverter;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ValidacionGeneralesBO
extends BaseBO {
    @Autowired
    private ValidacionGeneralesDAO validacionGeneralesDAO;
    @Autowired
    private DLARestClientFactory dlaRestClientFactory;
    @Autowired
    private OpcionesContratoBO opcionesContratoBO;
    @Autowired
    private ParametersWebService parametersWebService;
    @Autowired
    private CommonRestBO commonRestBO;
    @Autowired
    private JustificacionBO justificacionBO;
    @Autowired
    private GeneralesBO generalesBO;
    @Autowired
    private DocumentoBO documentoBO;
    @Autowired
    private TituloLoteTransDAO tituloLoteDAO;
    @Value(value="${ordenInterna.idPosicion}")
    private String idPosicionOrdInt;
    private DLARestClient dLARestClient;

    public BundleReturn notificacionSAP(ContratoDTO contrato, String expedienteUsuario) {
        BundleReturn respuesta = new BundleReturn();
        respuesta.setNumero(Integer.valueOf(TipoMensaje.ERROR.getValor()));
        respuesta.setEstado(Boolean.valueOf(false));
        boolean desicion = false;
        ResponseOrdenCompraDTO responseDTO = null;
        ResponseAdendumEnmiendaDTO responseAdendumDTO = null;
        if (contrato.getAmortizable().equals("SI")) {
            if (contrato.getIdTipoMovimiento() == 1L) {
                try {
                    this.logger.info("antes de llamarCrearOrdenCompra.");
                    responseDTO = this.llamaCrearOrdenCompra(contrato, expedienteUsuario);
                    this.logger.info("despues de llamarCrearOrdenCompra.");
                    desicion = responseDTO.getResultado();
                    respuesta.setCadena(responseDTO.getMensaje());
                }
                catch (Exception ex) {
                    this.logger.debug(ex.toString());
                    respuesta.setCadena(MensajeTexto.TIEMPO_AGOTADO.getTexto());
                }
                if (desicion) {
                    respuesta.setCadena(MensajeTexto.LLAMADA_EXITOSA.getTexto());
                    respuesta.setEstado(Boolean.valueOf(true));
                    respuesta.setNumero(Integer.valueOf(TipoMensaje.EXITO.getValor()));
                    this.procesarResultadosPorContrato(contrato.getIdContrato());
                } else {
                    respuesta.setCadena(MensajeTexto.LLAMADA_NO_EXITOSA.getTexto());
                }
            } else {
                try {
                    this.logger.info("antes de llamaCrearEnmienda.");
                    responseAdendumDTO = this.llamaCrearEnmienda(contrato, expedienteUsuario);
                    this.logger.info("despues de llamaCrearEnmienda.");
                    desicion = responseAdendumDTO.getResultado();
                    respuesta.setCadena(responseAdendumDTO.getMensaje());
                }
                catch (Exception ex) {
                    this.logger.debug(ex.toString());
                    respuesta.setCadena(MensajeTexto.TIEMPO_AGOTADO.getTexto());
                }
                if (desicion) {
                    respuesta.setCadena(MensajeTexto.LLAMADA_EXITOSA.getTexto());
                    respuesta.setEstado(Boolean.valueOf(true));
                    respuesta.setNumero(Integer.valueOf(TipoMensaje.EXITO.getValor()));
                    this.procesarResultadosPorContrato(contrato.getIdContrato());
                } else {
                    respuesta.setCadena(MensajeTexto.LLAMADA_NO_EXITOSA.getTexto());
                }
                this.logger.debug("Se termino de llamar a crearAdendunEnmienda (SUSCRIPCI\u00d3N)");
            }
        } else if (contrato.getIdTipoMovimiento() == 1L) {
            try {
                responseDTO = this.llamaRegistrarSAPNoAmortizable(contrato, expedienteUsuario);
                desicion = responseDTO.getResultado();
                respuesta.setCadena(responseDTO.getMensaje());
            }
            catch (Exception ex) {
                this.logger.debug(ex.toString());
                respuesta.setCadena(MensajeTexto.TIEMPO_AGOTADO.getTexto());
            }
            if (desicion) {
                respuesta.setCadena(MensajeTexto.LLAMADA_EXITOSA.getTexto());
                respuesta.setEstado(Boolean.valueOf(true));
                respuesta.setNumero(Integer.valueOf(TipoMensaje.EXITO.getValor()));
                this.procesarResultadosPorContrato(contrato.getIdContrato());
            } else {
                respuesta.setCadena(MensajeTexto.LLAMADA_NO_EXITOSA.getTexto());
            }
            this.logger.debug("Se termino de llamar a registroSAPNoAmortizable (TRANSACCIONAL - LINCESE FEE)");
        } else {
            try {
                responseAdendumDTO = this.llamaEnmiendaNoAmortizable(contrato, expedienteUsuario);
                desicion = responseAdendumDTO.getResultado();
                respuesta.setCadena(responseAdendumDTO.getMensaje());
            }
            catch (Exception ex) {
                this.logger.debug(ex.toString());
                respuesta.setCadena(MensajeTexto.TIEMPO_AGOTADO.getTexto());
            }
            if (desicion) {
                respuesta.setCadena(MensajeTexto.LLAMADA_EXITOSA.getTexto());
                respuesta.setEstado(Boolean.valueOf(true));
                respuesta.setNumero(Integer.valueOf(TipoMensaje.EXITO.getValor()));
                this.procesarResultadosPorContrato(contrato.getIdContrato());
            } else {
                respuesta.setCadena(MensajeTexto.LLAMADA_NO_EXITOSA.getTexto());
            }
            this.logger.debug("Se termino de llamar a registroAdendumEnmiendaNoAmortizable (TRANSACCIONAL - LINCESE FEE)");
        }
        return respuesta;
    }

    public boolean validaEstudioContrato(Long idContrato) {
        String estudio = null;
        try {
            estudio = this.validacionGeneralesDAO.obtenerIdSapEstudioContrato(idContrato);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return estudio != null;
    }

    public ResponseValidaPresupuestoCntDTO obtenValidacionPresupuesto(Date fechaInicio, Long idContrato, String origen) {
        DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.VALIDAR_PRESUPUESTO_POR_CONTRATO);
        ParamValidaPresupuestoCntDTO req = new ParamValidaPresupuestoCntDTO();
        ResponseValidaPresupuestoCntDTO resp = null;
        req.setIdContrato(idContrato.toString());
        this.logger.debug("request : [{}]", (Object)req);
        try {
            resp = client.get(req, ResponseValidaPresupuestoCntDTO.class);
            this.logger.debug("response : [{}]", (Object)resp);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return resp;
    }

    public ResponseValidaMinimoSeleccionDTO obtenValidacionMinimoSeleccion(Long idContrato, String origen) {
        DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.VALIDA_MINIMO_SELECCION);
        ParamValidaMinimoSeleccionDTO req = new ParamValidaMinimoSeleccionDTO();
        ResponseValidaMinimoSeleccionDTO resp = null;
        req.setIdContrato(idContrato.toString());
        req.setOrigenTitulos(origen);
        this.logger.debug("request : [{}]", (Object)req);
        try {
            resp = client.get(req, ResponseValidaMinimoSeleccionDTO.class);
            this.logger.debug("response : [{}]", (Object)resp);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return resp;
    }

    public boolean llamdaCalcularAmortizacionPorContrato(Long idContrato) {
        boolean respuesta = false;
        DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.CALCULAR_AMORTIZACION_POR_CONTRATO);
        ParamCalcAmortCntDTO req = new ParamCalcAmortCntDTO();
        ResponseCalcAmortCntDTO resp = null;
        req.setIdContrato(idContrato.toString());
        String modulo = "AMORTIZACION";
        this.logger.debug("request : [{}]", (Object)req);
        try {
            resp = client.get(req, ResponseCalcAmortCntDTO.class);
            this.logger.debug("response : [{}]", (Object)resp);
            respuesta = resp.getResultado();
            if (!respuesta) {
                this.opcionesContratoBO.registraProcesoPendiente(idContrato, modulo, 1);
            }
        }
        catch (Exception ex) {
            this.opcionesContratoBO.registraProcesoPendiente(idContrato, modulo, 1);
            this.logger.error("", (Throwable)ex);
        }
        return respuesta;
    }

    public BundleReturn validacionesParaFinalizarRegistro(Long idContrato, Long tipoContrato, Date fechaInicio, String origen, String expediente) {
        this.logger.info("Validando, idContrato : [{}] -- tipoContrato [{}]", (Object)idContrato, (Object)tipoContrato);
        String infoRespuesta = "";
        BundleReturn respuesta = new BundleReturn();
        respuesta.setCadena(MensajeTexto.CONTRATO_NO_FINALIZADO.getTexto() + "_");
        respuesta.setNumero(Integer.valueOf(TipoMensaje.ERROR.getValor()));
        respuesta.setEstado(Boolean.valueOf(false));
        boolean esEstudioOficial = false;
        Integer numeroDocumentos = 0;
        Integer numeroTerminos = 0;
        Integer numeroCondicionesPago = 0;
        Integer numeroTitulos = 0;
        Integer totalTitulos = 0;
        Long apartado = null;
        Integer sinSubnumero = 0;
        Integer erroresMG = 0;
        Double costoSAP = 0.0;
        Double costoContrato = 0.0;
        WFSeguimientoDTO wfSeguimiento = new WFSeguimientoDTO();
        wfSeguimiento.setIdContrato(idContrato);
        wfSeguimiento.setIdPasoWF(Integer.valueOf(1));
        wfSeguimiento.setFecha1(new Date());
        wfSeguimiento.setEstaAutorizado(Integer.valueOf(0));
        try {
            esEstudioOficial = this.validaEstudioContrato(idContrato);
            numeroDocumentos = 1;
        }
        catch (Exception e) {
            this.logger.error("Erro : [{}]", (Throwable)e);
        }
        if (tipoContrato == 1L) {
            try {
                numeroTerminos = this.validacionGeneralesDAO.contarTerminosContrato(idContrato);
                numeroCondicionesPago = this.validacionGeneralesDAO.contarCondicionesPagoContrato(idContrato);
                sinSubnumero = this.validacionGeneralesDAO.contarSinSubnumero(idContrato);
                apartado = this.validacionGeneralesDAO.obtenerApartadoContrato(idContrato);
            }
            catch (Exception e) {
                this.logger.error("Erro : [{}]", (Throwable)e);
            }
            ResponseValidaPresupuestoCntDTO respuestaPresupuesto = null;
            respuestaPresupuesto = this.commonRestBO.validaPresupuesto(fechaInicio, idContrato, origen);
            ResponseValidaMinimoSeleccionDTO respuestaMinimos = null;
            respuestaMinimos = this.obtenValidacionMinimoSeleccion(idContrato, origen);
            infoRespuesta = esEstudioOficial ? (numeroDocumentos > 0 ? (numeroTerminos > 0 ? (numeroCondicionesPago > 0 ? (sinSubnumero == 0 ? (apartado != null ? (respuestaPresupuesto.getResultado() ? this.revisaMinimoCorreo(idContrato, expediente, fechaInicio, respuestaMinimos.getResultado(), respuesta, wfSeguimiento, infoRespuesta) : infoRespuesta + respuestaPresupuesto.getMensaje() + "_") : infoRespuesta + MensajeTexto.CONTRATO_NO_TIENE_APARTADOS.getTexto() + "_") : infoRespuesta + MensajeTexto.CONTRATO_CON_SINSUBNUMERO.getTexto() + "_") : infoRespuesta + MensajeTexto.CONTRATO_NO_TIENE_CONDICIONES_PAGO.getTexto() + "_") : infoRespuesta + MensajeTexto.CONTRATO_NO_TIENE_TERMINOS.getTexto() + "_") : infoRespuesta + MensajeTexto.CONTRATO_NO_TIENE_DOCUMENTOS.getTexto() + "_") : infoRespuesta + MensajeTexto.CONTRATO_NO_ESTUDIO_OFICIAL.getTexto() + "_";
        }
        if (tipoContrato == 2L) {
            erroresMG = this.validacionGeneralesDAO.ObtenerErroresCalculoMinimoGarantizado(idContrato);
            this.logger.info("Transaccional: Total Errores en calculo MG" + erroresMG);
            if (esEstudioOficial) {
                this.logger.info("Transaccional: es estudio oficial " + esEstudioOficial);
                if (numeroDocumentos > 0) {
                    this.logger.info("Transaccional: numero de documentos " + numeroDocumentos);
                    this.logger.info("Transaccional: No existen Errores en calculo" + erroresMG);
                    infoRespuesta = this.revisaMinimoCorreo(idContrato, expediente, fechaInicio, true, respuesta, wfSeguimiento, infoRespuesta);
                } else {
                    infoRespuesta = infoRespuesta + MensajeTexto.CONTRATO_NO_TIENE_DOCUMENTOS.getTexto() + "_";
                }
            } else {
                infoRespuesta = infoRespuesta + MensajeTexto.CONTRATO_NO_ESTUDIO_OFICIAL.getTexto() + "_";
            }
        }
        if (tipoContrato == 3L) {
            try {
                numeroTitulos = this.validacionGeneralesDAO.contarTitulosActivosContrato(idContrato);
                totalTitulos = this.validacionGeneralesDAO.obtenerTotalTitulosEnTerminos(idContrato);
                costoSAP = this.validacionGeneralesDAO.obtenMontoContratoSAP(idContrato);
                costoContrato = this.validacionGeneralesDAO.obtenCantidad(idContrato);
            }
            catch (Exception e) {
                this.logger.error("Erro : [{}]", (Throwable)e);
            }
            if (esEstudioOficial) {
                this.logger.info("License Fee: es estudio oficial " + esEstudioOficial);
                if (numeroDocumentos > 0) {
                    this.logger.info("License Fee: numero de documentos " + numeroDocumentos);
                    if (numeroTitulos == totalTitulos) {
                        this.logger.info("License Fee: numero de titulos y total de titulos " + numeroTitulos + "=" + totalTitulos);
                        if (costoSAP <= costoContrato) {
                            infoRespuesta = this.revisaMinimoCorreo(idContrato, expediente, fechaInicio, true, respuesta, wfSeguimiento, infoRespuesta);
                        } else {
                            this.logger.info("License Fee: costo SAP y costo Contraro " + costoSAP + "<" + costoContrato);
                            infoRespuesta = infoRespuesta + MensajeTexto.CONTRATO_COSTO_NO_DISMINUIR.getTexto() + "_";
                        }
                    } else {
                        infoRespuesta = infoRespuesta + MensajeTexto.CONTRATO_NO_TITULOS_ESPECIFICADOS.getTexto() + "_";
                    }
                } else {
                    infoRespuesta = infoRespuesta + MensajeTexto.CONTRATO_NO_TIENE_DOCUMENTOS.getTexto() + "_";
                }
            } else {
                infoRespuesta = infoRespuesta + MensajeTexto.CONTRATO_NO_ESTUDIO_OFICIAL.getTexto() + "_";
            }
        }
        if (!respuesta.getEstado().booleanValue()) {
            respuesta.setCadena(infoRespuesta);
        }
        return respuesta;
    }

    public String revisaMinimoCorreo(Long idContrato, String expediente, Date fechaInicio, boolean respuestaMinimos, BundleReturn respuesta, WFSeguimientoDTO wfSeguimiento, String infoRespuesta) {
        if (respuestaMinimos) {
            Map<String, Object> respuestaEnvioCorreo = this.notificaFinalizacionRegistro(idContrato);
            respuesta.setCadena(MensajeTexto.CONTRATO_FINALIZADO.getTexto() + "_" + (String)respuestaEnvioCorreo.get("mensaje"));
            respuesta.setNumero(Integer.valueOf(TipoMensaje.EXITO.getValor()));
            respuesta.setEstado(Boolean.valueOf(true));
            this.opcionesContratoBO.actulizaEstatus(Estatus.Revision.getValor(), idContrato, expediente);
            this.validacionGeneralesDAO.registraWFSeguimiento(wfSeguimiento);
            this.esContratoSuscripcion(fechaInicio, idContrato);
        } else {
            infoRespuesta = infoRespuesta + MensajeTexto.CONTRATO_NO_CUMPLE_MINIMOS.getTexto() + "_";
        }
        return infoRespuesta;
    }

    public String uneListaErrores(List<String> errores) {
        String cadenaErrores = "";
        if (errores.size() > 0) {
            for (int i = 0; i < errores.size(); ++i) {
                cadenaErrores = cadenaErrores + "Error " + (i + 1) + " : " + errores.get(i) + ".";
                if (i >= errores.size() - 1) continue;
                cadenaErrores = cadenaErrores + "_";
            }
        }
        return cadenaErrores;
    }

    public BundleReturn validaWorkFlow(Long idContrato, String expedienteUsuario, Integer ordenPasoWF, Integer noPasosWF, Date fechaInicioContrato, String fechaSincronizacionSAP, Long tipoContrato) {
        WFPasoDTO pasoActual = null;
        WFPasoDTO pasoSiguiente = null;
        List autorizadores = null;
        List correosExternos = null;
        Long idMenu = null;
        boolean seEnviaronCorreos = false;
        BundleReturn respuesta = new BundleReturn();
        String etiqueta = null;
        respuesta.setEstado(Boolean.valueOf(false));
        respuesta.setNumero(Integer.valueOf(TipoMensaje.ERROR.getValor()));
        SimpleDateFormat sdf = null;
        String sFechaInicio = null;
        Date fechaSAP = null;
        Date dFechaInicio = null;
        boolean seCambioEstatusPorFechas = false;
        String seccionExternos = "AUTORIZACION_WF_CEO";
        Date fechaRegistro = null;
        WFSeguimientoDTO wfSeguimiento = new WFSeguimientoDTO();
        Operacion tipo = null;
        try {
            pasoActual = this.validacionGeneralesDAO.obtnerWFPaso(ordenPasoWF);
            idMenu = 65L;
            this.logger.info("Area Actual : [{}]", (Object)pasoActual);
            if (ordenPasoWF < noPasosWF) {
                pasoSiguiente = this.validacionGeneralesDAO.obtnerWFPaso(Integer.valueOf(ordenPasoWF + 1));
                autorizadores = this.validacionGeneralesDAO.obtenerAutorizador(idMenu, pasoSiguiente.getIdArea());
                etiqueta = MensajeTexto.ETIQUETA_AUTORIZACION_WF.getTexto();
                tipo = Operacion.CONTRATO;
            } else {
                autorizadores = this.validacionGeneralesDAO.obtenerTodosAreas();
                etiqueta = "Se ha autorizado ";
                seccionExternos = "AUTORIZACION_WF_CEO";
                etiqueta = MensajeTexto.ETIQUETA_FINALIZA_AUTORIZACION_WF.getTexto();
                tipo = Operacion.FINALIZO_AUTORIZACION;
            }
            this.logger.info("Area Siguiente : [{}] - autorizadores : [{}]", (Object)pasoSiguiente, (Object)autorizadores);
            if (autorizadores.size() > 0) {
                seEnviaronCorreos = this.mandaCorreo(idContrato, autorizadores, null, etiqueta, tipo);
                if (seEnviaronCorreos) {
                    fechaRegistro = new Date();
                    this.validacionGeneralesDAO.registraPasoWF(idContrato, pasoActual.getOrdenWF(), expedienteUsuario, fechaRegistro);
                    this.validacionGeneralesDAO.actualizaEstaAutorizado(idContrato, pasoActual.getOrdenWF());
                    if (pasoSiguiente != null) {
                        wfSeguimiento.setIdContrato(idContrato);
                        wfSeguimiento.setIdPasoWF(pasoSiguiente.getOrdenWF());
                        wfSeguimiento.setFecha1(fechaRegistro);
                        wfSeguimiento.setEstaAutorizado(Integer.valueOf(0));
                        this.validacionGeneralesDAO.registraWFSeguimiento(wfSeguimiento);
                    }
                    respuesta.setEstado(Boolean.valueOf(true));
                    respuesta.setCadena(MensajeTexto.AUTORIZACION_REGISTRADA.getTexto());
                    respuesta.setNumero(Integer.valueOf(TipoMensaje.EXITO.getValor()));
                    if (ordenPasoWF == noPasosWF) {
                        if (!this.opcionesContratoBO.tieneFechaAutorizacion(idContrato)) {
                            this.opcionesContratoBO.actualizaFechaAutorizacion(new Date(), idContrato);
                        }
                        if (this.opcionesContratoBO.esContratoAmortizable(idContrato)) {
                            this.llamdaCalcularAmortizacionPorContrato(idContrato);
                        }
                        try {
                            this.logger.debug("dateInicio [{}]", (Object)fechaInicioContrato);
                            this.logger.debug("fecha Sincronizacion [{}]", (Object)fechaSincronizacionSAP);
                            sdf = new SimpleDateFormat("MM/dd/yyyy");
                            sFechaInicio = sdf.format(fechaInicioContrato);
                            fechaSAP = sdf.parse(fechaSincronizacionSAP);
                            dFechaInicio = sdf.parse(sFechaInicio);
                            this.logger.debug("fechaInicio : [{}], fechaSAP [{}]", (Object)dFechaInicio, (Object)fechaSAP);
                            if (dFechaInicio.compareTo(fechaSAP) < 0) {
                                this.logger.debug("No entrara a notificar a SAP[{}]", (Object)idContrato);
                                this.opcionesContratoBO.actulizaEstatus(Estatus.Vigente.getValor(), idContrato, expedienteUsuario);
                                this.opcionesContratoBO.actualizaEstatusPadreContrato(idContrato, expedienteUsuario);
                                seCambioEstatusPorFechas = true;
                                this.procesarResultadosPorContrato(idContrato);
                            }
                        }
                        catch (ParseException e) {
                            this.logger.error("Error : [{}]", (Throwable)e);
                        }
                    }
                } else {
                    respuesta.setCadena(MensajeTexto.AUTORIZACION_NO_REGISTRADA.getTexto());
                }
            } else {
                respuesta.setCadena(MensajeTexto.AUTORIZACION_VERIFICA.getTexto());
            }
            seEnviaronCorreos = false;
            if (pasoActual.getEnviaExterno() == 1) {
                this.logger.debug("Se debera enviar correos externos.");
                correosExternos = this.validacionGeneralesDAO.obtenerCorreoExterno(seccionExternos);
                seEnviaronCorreos = this.mandaCorreo(idContrato, null, correosExternos, etiqueta, tipo);
            }
            this.logger.debug("valores de estatus area : [{}], seCambioEstatusPorFechas : [{}]", (Object)pasoActual.getIdEstatus(), (Object)seCambioEstatusPorFechas);
            if (pasoActual.getIdEstatus() != null && !seCambioEstatusPorFechas) {
                this.logger.info("se debera cambiar estatus : [{}]", (Object)pasoActual.getIdEstatus());
                this.opcionesContratoBO.actulizaEstatus(pasoActual.getIdEstatus(), idContrato, expedienteUsuario);
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return respuesta;
    }

    public boolean procesarResultadosPorContrato(Long idContrato) {
        boolean resultado = true;
        ContratoDTO contrato = this.generalesBO.obtenContrato(idContrato);
        this.logger.info("Se ejecuta SP Ajusta Addendum." + idContrato);
        this.opcionesContratoBO.llamarAjustaAddendum(idContrato);
        try {
            if (contrato.getIdTipoContrato() != 2L) {
                this.logger.info("Se ejecuta SP Reporte Pago [{}]:" + idContrato);
                this.opcionesContratoBO.llamarReportePagos(idContrato);
            } else {
                this.logger.info("Se ejecuta SP Calculo de Minimo Garantizado");
                this.tituloLoteDAO.calcularMG(idContrato);
            }
            if (contrato.getIdTipoContrato() == 1L) {
                this.logger.info("Se ejecuta SP Amortizacion Inicial.");
                this.opcionesContratoBO.llamarAmortizacionInicial(idContrato);
                this.opcionesContratoBO.llamarAmortizacionCpv(idContrato);
            }
            if (contrato.getIdTipoMovimiento() == 1L) {
                Date fechaInicio = contrato.getFechaInicio();
                SimpleDateFormat formatoAnio = new SimpleDateFormat("yyyy");
                Long anio = Long.parseLong(formatoAnio.format(fechaInicio));
                Double cantidadContrato = this.validacionGeneralesDAO.obtenCantidad(contrato.getIdContrato());
                String cantidad = contrato.getIdTipoContrato() == 1L || contrato.getIdTipoContrato() == 3L ? (cantidadContrato != null ? String.format("%.2f", cantidadContrato) : "1") : "1";
                try {
                    this.logger.info("Se registra el monto y a\u00f1o del contrato en DDA_T_CONTRATO_SAP cantidad : " + cantidad + "-> anio :" + anio + "-> idPosicionOrdInt :" + this.idPosicionOrdInt);
                    this.validacionGeneralesDAO.registraContratoSAP(idContrato, anio, this.idPosicionOrdInt, cantidad);
                }
                catch (Exception ex) {
                    this.logger.error("Error : ", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : ", (Throwable)ex);
        }
        return resultado;
    }

    public boolean mandaCorreo(Long idContrato, List<AutorizadorDTO> autorizadores, List<CorreoExternoDTO> correosExternos, String etiqueta, Operacion tipo) {
        boolean seEnvio = false;
        DetalleCorreoDTO detalleCorreo = null;
        String[] destinatarios = null;
        DecimalFormat decimalFormatterS = new DecimalFormat("$###,###.##");
        DecimalFormat decimalFormatter = new DecimalFormat("###,###.##");
        SimpleDateFormat formatoDeFecha = new SimpleDateFormat("MM/dd/yyyy");
        DetalleCorreoVO detalleCorreoVO = new DetalleCorreoVO();
        try {
            detalleCorreo = this.validacionGeneralesDAO.obtenerDetalleParaCorreo(idContrato);
            this.logger.info("Detalle Correo : [{}]", (Object)detalleCorreo);
            detalleCorreoVO.setNumeroContrato(detalleCorreo.getNumeroContrato());
            detalleCorreoVO.setDescripcionEstudio(detalleCorreo.getDescripcionEstudio());
            detalleCorreoVO.setMonto(decimalFormatterS.format(detalleCorreo.getMonto()));
            detalleCorreoVO.setNoTitulos(decimalFormatter.format(detalleCorreo.getNoTitulos()));
            detalleCorreoVO.setVigencia(formatoDeFecha.format(detalleCorreo.getFechaInicio()) + " - " + formatoDeFecha.format(detalleCorreo.getFechaFin()));
            etiqueta = etiqueta.replace("nctoremp", detalleCorreoVO.getNumeroContrato());
            this.logger.info("Detalle Correo Formato : [{}]", (Object)detalleCorreoVO);
            if (autorizadores != null) {
                destinatarios = new String[autorizadores.size()];
                for (int i = 0; i < autorizadores.size(); ++i) {
                    destinatarios[i] = autorizadores.get(i).getEmail();
                }
                seEnvio = this.llamaServicioEnviaCorreo(idContrato, destinatarios, detalleCorreoVO, etiqueta, tipo, MensajeTexto.EMAIL_SUBJECT_AUTORIZACION.getTexto().replace("&oacute;", "\u00f3"));
            } else {
                destinatarios = new String[correosExternos.size()];
                for (int i = 0; i < correosExternos.size(); ++i) {
                    destinatarios[i] = correosExternos.get(i).getCorreo();
                }
                seEnvio = this.llamaServicioEnviaCorreo(idContrato, destinatarios, detalleCorreoVO, etiqueta, tipo, MensajeTexto.EMAIL_SUBJECT_AUTORIZACION.getTexto());
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : ", (Throwable)ex);
        }
        return seEnvio;
    }

    public boolean mandaCorreoRechazo(Long idContrato, List<AutorizadorDTO> autorizadores, String etiqueta, String motivo) {
        DetalleCorreoVO detalleCorreoVO = new DetalleCorreoVO();
        boolean seEnvio = false;
        String[] destinatarios = null;
        detalleCorreoVO.setMotivo(motivo);
        detalleCorreoVO.setNumeroContrato(this.opcionesContratoBO.obtenerNumeroContrato(idContrato));
        etiqueta = etiqueta.replace("nctoremp", detalleCorreoVO.getNumeroContrato());
        if (autorizadores != null) {
            destinatarios = new String[autorizadores.size()];
            for (int i = 0; i < autorizadores.size(); ++i) {
                destinatarios[i] = autorizadores.get(i).getEmail();
            }
            seEnvio = this.llamaServicioEnviaCorreo(idContrato, destinatarios, detalleCorreoVO, etiqueta, Operacion.NOAUTORIZA, MensajeTexto.EMAIL_SUBJECT_NO_AUTORIZACION.getTexto().replace("&oacute;", "\u00f3"));
        }
        return seEnvio;
    }

    public boolean mandaCorreoNotificacionCreacionContrato(Long idContrato, String numeroContrato, Long idEstudio, Date fechaInicio, Date fechaFin) {
        DetalleCorreoVO detalleCorreoVO = new DetalleCorreoVO();
        boolean seEnvio = false;
        List correosExternos = this.validacionGeneralesDAO.obtenerCorreoExterno("CREACION_CONTRATO");
        SimpleDateFormat formatoDeFecha = new SimpleDateFormat("MM/dd/yyyy");
        detalleCorreoVO.setNumeroContrato(numeroContrato);
        detalleCorreoVO.setDescripcionEstudio(this.validacionGeneralesDAO.obtenerDescripcionEstudio(idEstudio));
        detalleCorreoVO.setVigencia(formatoDeFecha.format(fechaInicio) + " - " + formatoDeFecha.format(fechaFin));
        String etiqueta = MensajeTexto.ETIQUETA_CREACION_CONTRATO.getTexto();
        etiqueta = etiqueta.replace("nctoremp", detalleCorreoVO.getNumeroContrato());
        if (correosExternos != null) {
            String[] destinatarios = new String[correosExternos.size()];
            for (int i = 0; i < correosExternos.size(); ++i) {
                destinatarios[i] = ((CorreoExternoDTO)correosExternos.get(i)).getCorreo();
            }
            seEnvio = this.llamaServicioEnviaCorreo(idContrato, destinatarios, detalleCorreoVO, etiqueta, Operacion.CREACION_CONTRATO, "Notificaci\u00f3n de creaci\u00f3n del contrato ");
        }
        return seEnvio;
    }

    public boolean llamaServicioEnviaCorreo(Long idContrato, String[] destinatarios, DetalleCorreoVO detalleCorreo, String etiqueta, Operacion tipo, String subject) {
        String body = null;
        EmailRequest request = new EmailRequest();
        Object response = null;
        boolean exito = false;
        DocumentoDTO documento = null;
        HashMap<String, String> destina = new HashMap<String, String>();
        try {
            for (String dest : destinatarios) {
                destina.put(dest, dest);
            }
            documento = this.documentoBO.obtenerUltimoDocumento(idContrato);
            if (documento != null) {
                detalleCorreo.setIdDocumento(documento.getIdContratoDocto());
            }
            body = JsonConverter.toJson(detalleCorreo);
            this.logger.debug("body [{}]", (Object)body);
            request.setDate(new Date().toString());
            request.setName("yussel luna");
            request.setToCompany("Derechos de Autor");
            request.setUserName("administrador@dladda.com");
            request.setDestinatarios(destina.values().toArray(new String[0]));
            request.setSubject(subject + detalleCorreo.getNumeroContrato());
            request.setBody(body);
            request.setOperacion(tipo);
            request.setEtiqueta(etiqueta);
            this.logger.debug("response : [{}]", response);
            exito = true;
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
            exito = false;
        }
        return exito;
    }

    public Map<String, Object> notificaFinalizacionRegistro(Long idContrato) {
        WFPasoDTO primerPaso = null;
        Boolean correoEnviado = false;
        String mensaje = "";
        HashMap<String, Object> respuesta = new HashMap<String, Object>();
        try {
            primerPaso = this.validacionGeneralesDAO.obtnerWFPaso(Integer.valueOf(1));
            List autorizadores = this.validacionGeneralesDAO.obtenerAutorizador(Long.valueOf(65L), primerPaso.getIdArea());
            respuesta.put("respuesta", correoEnviado);
            if (autorizadores.size() > 0) {
                correoEnviado = this.mandaCorreo(idContrato, autorizadores, null, MensajeTexto.ETIQUETE_FINALIA_REGISTRO.getTexto(), Operacion.CONTRATO);
                respuesta.put("respuesta", correoEnviado);
                if (correoEnviado.booleanValue()) {
                    mensaje = MensajeTexto.NOTIFICACION_FINALIZO_REGISTRO.getTexto();
                    respuesta.put("mensaje", mensaje);
                } else {
                    mensaje = MensajeTexto.NOTIFICACION_NO_FINALIZO_REGISTRO.getTexto();
                    respuesta.put("mensaje", mensaje);
                }
            } else {
                respuesta.put("mensaje", MensajeTexto.AUTORIZACION_VERIFICA.getTexto());
            }
        }
        catch (Exception ex) {
            this.logger.error("Error :_ [{}]", (Throwable)ex);
        }
        return respuesta;
    }

    public BundleReturn noAceptarAutorizacion(Long idContrato, String motivo, Integer noPaso, UsuarioDTO usuario) {
        WFPasoDTO pasoActual = null;
        WFPasoDTO pasoAnterior = null;
        List autorizadoresPrevios = null;
        Boolean seMandoCorreo = false;
        BundleReturn respuesta = new BundleReturn();
        String sarea = "";
        respuesta.setEstado(Boolean.valueOf(false));
        respuesta.setCadena(MensajeTexto.RECHAZO_NO_NOTIFICADO.getTexto());
        respuesta.setNumero(Integer.valueOf(TipoMensaje.ERROR.getValor()));
        String etiqueta = MensajeTexto.ETIQUETA_RECHAZO_AUTORIZACION_WF.getTexto();
        try {
            this.logger.debug("noPaso : [{}]", (Object)noPaso);
            pasoActual = this.validacionGeneralesDAO.obtnerWFPaso(noPaso);
            if (noPaso == 1) {
                pasoAnterior = this.validacionGeneralesDAO.obtnerWFPaso(Integer.valueOf(2));
                autorizadoresPrevios = this.obtenerAutorizadorAreas();
            } else {
                pasoAnterior = this.validacionGeneralesDAO.obtnerWFPaso(Integer.valueOf(noPaso - 1));
                autorizadoresPrevios = this.validacionGeneralesDAO.obtenerAutorizador(Long.valueOf(65L), pasoAnterior.getIdArea());
            }
            this.logger.debug("pasoAnterior : [{}]", (Object)pasoAnterior);
            this.logger.debug("autorizadores anteriores : [{}]", (Object)autorizadoresPrevios);
            sarea = pasoActual.getDescripcionArea().replaceAll("\u00f3", "&oacute;");
            etiqueta = etiqueta.replace("sarea", sarea);
            seMandoCorreo = this.mandaCorreoRechazo(idContrato, autorizadoresPrevios, etiqueta, motivo);
            if (seMandoCorreo.booleanValue()) {
                this.justificacionBO.insertarJustificacion(motivo, idContrato, usuario);
                switch (noPaso) {
                    case 1: {
                        this.opcionesContratoBO.actulizaEstatus(Estatus.Registro.getValor(), idContrato, usuario.getExpediente());
                        break;
                    }
                    case 2: {
                        this.opcionesContratoBO.actulizaEstatus(Estatus.Revision.getValor(), idContrato, usuario.getExpediente());
                    }
                    default: {
                        this.validacionGeneralesDAO.eliminaAutorizacionRegistrada(idContrato, pasoAnterior.getOrdenWF());
                    }
                }
                this.validacionGeneralesDAO.actualizaEstaAutorizado(idContrato, pasoActual.getOrdenWF());
                respuesta.setEstado(Boolean.valueOf(true));
                respuesta.setCadena(MensajeTexto.RECHAZO_NOTIFICADO.getTexto());
                respuesta.setNumero(Integer.valueOf(TipoMensaje.EXITO.getValor()));
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return respuesta;
    }

    public List<AutorizadorDTO> obtenerAutorizadorAreas() {
        ArrayList<AutorizadorDTO> autorizadores = new ArrayList<AutorizadorDTO>();
        List autorizadoresAux = null;
        try {
            List<AreaDTO> areas = this.generalesBO.obtenerAreasFinalizadoras();
            for (AreaDTO area : areas) {
                autorizadoresAux = this.validacionGeneralesDAO.obtenerAutorizador(Long.valueOf(65L), area.getIdArea());
                for (AutorizadorDTO autorizador : autorizadoresAux) {
                    autorizadores.add(autorizador);
                }
                autorizadoresAux = null;
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return autorizadores;
    }

    public boolean esContratoSuscripcion(Date fechaInicio, Long idContrato) {
        boolean respuesta = false;
        String tipoFees = null;
        try {
            tipoFees = this.validacionGeneralesDAO.obtenerTipoFees(idContrato);
            if (tipoFees != null && tipoFees.equals("ESCALA")) {
                respuesta = true;
                this.commonRestBO.llamadaCostoTitulo(fechaInicio, idContrato, OrigenCodes.REAL.name());
            }
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return respuesta;
    }

    public ResponseOrdenCompraDTO llamaCrearOrdenCompra(ContratoDTO contrato, String expediente) {
        this.logger.info("idContrato : " + contrato.getIdContrato() + ", expediente : " + expediente + " en llamarCrearOrdenCompra");
        ParamOrdenCompraDTO paramDTO = null;
        ResponseOrdenCompraDTO responseDTO = new ResponseOrdenCompraDTO();
        paramDTO = this.parametersWebService.obtenParametroOrdenCompra(contrato, expediente);
        this.logger.info("{}", (Object)this.printOrdenCompraRequest(paramDTO));
        this.dLARestClient = this.dlaRestClientFactory.getClient(DLARestServices.REGISTRAR_SAP_SUSCRIPCION);
        responseDTO = this.dLARestClient.get(paramDTO, ResponseOrdenCompraDTO.class);
        this.logger.debug("Request : " + paramDTO + " Response : " + responseDTO);
        return responseDTO;
    }

    public ResponseAdendumEnmiendaDTO llamaCrearEnmienda(ContratoDTO contrato, String expediente) {
        ParamAdendumEnmiendaDTO paramDTO = null;
        ResponseAdendumEnmiendaDTO responseDTO = new ResponseAdendumEnmiendaDTO();
        paramDTO = this.parametersWebService.obtenParametroEnmienda(contrato, expediente);
        this.dLARestClient = this.dlaRestClientFactory.getClient(DLARestServices.REGISTRAR_SAP_ENMIENDA_SUSCRIPCION);
        responseDTO = this.dLARestClient.get(paramDTO, ResponseAdendumEnmiendaDTO.class);
        this.logger.debug("Request: " + paramDTO + " Resonse: " + responseDTO);
        return responseDTO;
    }

    public ResponseOrdenCompraDTO llamaRegistrarSAPNoAmortizable(ContratoDTO contrato, String expediente) {
        ParamOrdenCompraDTO paramDTO = null;
        ResponseOrdenCompraDTO responseDTO = new ResponseOrdenCompraDTO();
        paramDTO = this.parametersWebService.obtenParametroOrdenCompra(contrato, expediente);
        this.logger.info("{}", (Object)this.printOrdenCompraRequest(paramDTO));
        this.dLARestClient = contrato.getIdTipoContrato() == 2L ? this.dlaRestClientFactory.getClient(DLARestServices.REGISTRAR_SAP_TRANSACCIONAL) : this.dlaRestClientFactory.getClient(DLARestServices.REGISTRAR_SAP_LICENSE_FEE);
        responseDTO = this.dLARestClient.get(paramDTO, ResponseOrdenCompraDTO.class);
        this.logger.debug("Request: " + paramDTO + " Response: " + responseDTO);
        return responseDTO;
    }

    public ResponseAdendumEnmiendaDTO llamaEnmiendaNoAmortizable(ContratoDTO contrato, String expediente) {
        ParamAdendumEnmiendaDTO paramDTO = null;
        ResponseAdendumEnmiendaDTO responseDTO = new ResponseAdendumEnmiendaDTO();
        paramDTO = this.parametersWebService.obtenParametroEnmienda(contrato, expediente);
        this.dLARestClient = contrato.getIdTipoContrato() == 2L ? this.dlaRestClientFactory.getClient(DLARestServices.REGISTRAR_SAP_ENMIENDA_TRANSACCIONAL) : this.dlaRestClientFactory.getClient(DLARestServices.REGISTRAR_SAP_ENMIENDA_LICENSE_FEE);
        responseDTO = this.dLARestClient.get(paramDTO, ResponseAdendumEnmiendaDTO.class);
        this.logger.debug("Request: " + paramDTO + " Resonse: " + responseDTO);
        return responseDTO;
    }

    public String printOrdenCompraRequest(ParamOrdenCompraDTO request) {
        if (request != null) {
            StringBuilder result = new StringBuilder();
            String SEPARATOR_LINE = ", ";
            String NEW_LINE = System.getProperty("line.separator");
            result.append(NEW_LINE);
            result.append(" [Header] ");
            result.append(" sociedad: " + request.getSociedad() + SEPARATOR_LINE);
            result.append(" claseDoc: " + request.getClaseDoc() + SEPARATOR_LINE);
            result.append(" idProveedor: " + request.getIdProveedor() + SEPARATOR_LINE);
            result.append(" orgCompras: " + request.getOrgCompras() + SEPARATOR_LINE);
            result.append(" grupoCompras: " + request.getGrupoCompras() + SEPARATOR_LINE);
            result.append(" fechaDoc: " + request.getFechaDoc() + SEPARATOR_LINE);
            result.append(" referencia: " + request.getReferencia() + SEPARATOR_LINE);
            result.append(" idContrato: " + request.getIdContrato() + SEPARATOR_LINE);
            result.append(" expediente: " + request.getExpediente());
            result.append(" [/Header] ");
            result.append(NEW_LINE);
            result.append(" [Body] ");
            List items = request.getItems();
            if (items != null && items.size() > 0) {
                for (ItemOrdenCompraDTO item : items) {
                    result.append(NEW_LINE);
                    result.append("     [Item] ");
                    result.append(" idPosicion: " + item.getIdPosicion() + SEPARATOR_LINE);
                    result.append(" idMaterial: " + item.getIdMaterial() + SEPARATOR_LINE);
                    result.append(" centro: " + item.getCentro() + SEPARATOR_LINE);
                    result.append(" cantidad: " + item.getCantidad() + SEPARATOR_LINE);
                    result.append(" precio: " + item.getPrecio() + SEPARATOR_LINE);
                    result.append(" indicadorIVA: " + item.getIndicadorIVA() + SEPARATOR_LINE);
                    result.append(" tipoImputacion: " + item.getTipoImputacion() + SEPARATOR_LINE);
                    result.append(" idPosicionAcc: " + item.getIdPosicionAcc() + SEPARATOR_LINE);
                    result.append(" centroCostos: " + item.getCentroCostos() + SEPARATOR_LINE);
                    result.append(" idOrden: " + item.getIdOrden());
                    result.append(" [/Item] ");
                }
            }
            result.append(NEW_LINE);
            result.append(" [/Body] ");
            NEW_LINE = null;
            return result.toString();
        }
        return null;
    }
}

