/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.minimoseleccion.bos;

import com.mx.dla.dda.contrato.fees.dtos.FeesSuscriptorBD;
import com.mx.dla.dda.contrato.minimoseleccion.daos.MinimoSeleccionDAO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.AnioInfoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.AnnioDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.AnnioPeriodoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.CategoriaInfoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.CategoriaMinimoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoMinimoSeleccionDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoCategoriaDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoCostoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.ContratoPagoFlatDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.DetalleAnnioPeriodoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.MontoRealDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.PeriodoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.PeriodoInfoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.dtos.SuscriptoresPeriodoDTO;
import com.mx.dla.dda.contrato.ws.obtenersuscriptores.ParamSuscriptoresContrato;
import com.mx.dla.dda.contrato.ws.obtenersuscriptores.ResponseSuscriptoresContratoDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MinimoSeleccionBO
extends BaseBO {
    @Autowired
    private MinimoSeleccionDAO minimoSeleccionDAO;
    @Autowired
    public DLARestClientFactory dlaRestClientFactory;

    public void cambiaMinimoCategoria(List<CategoriaMinimoDTO> campoPeriodos) {
        Map categoriaMinimo = null;
        this.logger.debug("campoPeriodo: " + campoPeriodos);
        try {
            for (CategoriaMinimoDTO categoriaMinimoDTO : campoPeriodos) {
                this.logger.debug("categoriaMinimo " + categoriaMinimoDTO);
                categoriaMinimo = categoriaMinimoDTO.getPareja();
                this.minimoSeleccionDAO.cambiaMontoPeriodo(categoriaMinimoDTO.getIdMonto(), categoriaMinimoDTO.getMontoMinimo());
                for (String llave : categoriaMinimo.keySet()) {
                    String[] idCategoria = llave.split("_");
                    this.logger.debug(idCategoria[1] + " : " + (String)categoriaMinimo.get(llave));
                    this.minimoSeleccionDAO.cambiaMinimoCategoria(Long.valueOf(Long.parseLong(idCategoria[1])), (String)categoriaMinimo.get(llave));
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
    }

    public Long obtenerEstatusContrato(Long idContrato) {
        Long estatusContrato = null;
        try {
            estatusContrato = this.minimoSeleccionDAO.obtenerEstatusContrato(idContrato);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return estatusContrato;
    }

    public String obtenTipoPago(Long idContrato) {
        String tipoPago = null;
        try {
            tipoPago = this.minimoSeleccionDAO.obtenTipoPago(idContrato);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return tipoPago;
    }

    public List<AnnioDTO> obtenAnnioContrato(Long idContrato) {
        List annios = null;
        try {
            annios = this.minimoSeleccionDAO.obtenAnnioContrato(idContrato);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return annios;
    }

    public List<PeriodoDTO> obtnePeriodoContrato(Long idContrato) {
        List periodos = null;
        SimpleDateFormat formatoDeFecha = new SimpleDateFormat("MM/dd/yyyy");
        try {
            periodos = this.minimoSeleccionDAO.obtnePeriodoContrato(idContrato);
            for (PeriodoDTO periodo : periodos) {
                periodo.setStrFechaInicio(formatoDeFecha.format(periodo.getFechaInicio()));
                periodo.setStrFechaFin(formatoDeFecha.format(periodo.getFechaFin()));
            }
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return periodos;
    }

    public AnnioPeriodoDTO obtenAnnioPeriodo(Long idContratoPago, Integer annio, String tipoPago, Long idContrato) {
        AnnioPeriodoDTO annioPeriodo = new AnnioPeriodoDTO();
        String monto = null;
        List categorias = null;
        String precioAnualyMinimo = null;
        String[] precioAnualyMinimoArray = null;
        try {
            if (tipoPago.equals("FLAT")) {
                monto = this.minimoSeleccionDAO.obtenAnnioMinimoMonto(idContratoPago, annio);
                categorias = this.minimoSeleccionDAO.obtenAnnioCategorias(idContratoPago, annio);
            } else {
                monto = this.minimoSeleccionDAO.obtenPeriodoMinimoMonto(idContratoPago);
                categorias = this.minimoSeleccionDAO.obtenPeriodoCategorias(idContratoPago);
            }
            for (DetalleAnnioPeriodoDTO categoria : categorias) {
                precioAnualyMinimo = this.obtenPrecioAnualAndMinimo(tipoPago, idContratoPago, annio, categoria.getIdPagoCategoria(), Integer.parseInt(categoria.getMinimoTitulos()), idContrato);
                precioAnualyMinimoArray = precioAnualyMinimo.split("_");
                categoria.setPrecioAnual(precioAnualyMinimoArray[0]);
                categoria.setMinimo(precioAnualyMinimoArray[1]);
            }
            annioPeriodo.setIdContratoPago(idContratoPago);
            annioPeriodo.setMinimoMonto(monto);
            annioPeriodo.setCategorias(categorias);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return annioPeriodo;
    }

    public boolean actualizaCategoriasMonto(Long idContratoPago, String minimoMonto, Map<Long, String> categoriasMod, Integer annio, String tipoPago) {
        boolean respuesta = false;
        this.logger.debug("idContratoPago : " + idContratoPago + " minimoMonto : " + minimoMonto + " key : " + categoriasMod.keySet());
        try {
            if (tipoPago.equals("FLAT")) {
                this.minimoSeleccionDAO.actualizaMinimoMontoAnnio(idContratoPago, minimoMonto, annio);
            } else {
                this.minimoSeleccionDAO.actualizaMinimoMontoPeriodo(idContratoPago, minimoMonto);
            }
            for (Long key : categoriasMod.keySet()) {
                this.minimoSeleccionDAO.actualizaMinimoTitulos(categoriasMod.get(key), key);
            }
            respuesta = true;
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return respuesta;
    }

    public String obtenPrecioAnualAndMinimo(String tipoPago, Long idContratoPago, Integer annio, Long idPagoCategoria, Integer noTitulos, Long idContrato) {
        String respuesta = null;
        String precio = null;
        Integer minimo = null;
        Integer numeroSuscriptores = 0;
        try {
            if (tipoPago.equals("FLAT")) {
                precio = this.minimoSeleccionDAO.obtenCostoAnnio(idContratoPago, idPagoCategoria, annio);
            } else {
                numeroSuscriptores = this.obtnerNumeroSuscriptores(idContratoPago, idContrato);
                this.logger.debug("numero de Suscriptores : " + numeroSuscriptores);
                precio = this.minimoSeleccionDAO.obtenCostoPeriodo(idContratoPago, idPagoCategoria, numeroSuscriptores);
            }
            this.logger.debug("precio : " + precio);
            if (precio == null || precio.equals("")) {
                precio = "0";
            }
            minimo = noTitulos * Integer.parseInt(precio);
            respuesta = precio + "_" + minimo.toString();
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return respuesta;
    }

    public Integer obtnerNumeroSuscriptores(Long idContratoPago, Long idContrato) {
        Integer nSuscriptores = 0;
        String fechaInicioPeriodo = null;
        ParamSuscriptoresContrato solicitud = new ParamSuscriptoresContrato();
        ResponseSuscriptoresContratoDTO respuesta = null;
        try {
            fechaInicioPeriodo = this.minimoSeleccionDAO.obtneFechaInicioPeriodo(idContrato, idContratoPago);
            solicitud.setFechaInicioPeriodo(fechaInicioPeriodo);
            solicitud.setIdContrato(idContrato.toString());
            DLARestClient dLARestClient = this.dlaRestClientFactory.getClient(DLARestServices.OBTENER_SUSCRIPTORES_CONTRATO);
            this.logger.debug("request : " + solicitud);
            respuesta = dLARestClient.get(solicitud, ResponseSuscriptoresContratoDTO.class);
            this.logger.debug("response : " + respuesta);
            nSuscriptores = Integer.parseInt(respuesta.getSuscriptores());
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return nSuscriptores;
    }

    public void guardarMinSeleccion(Long idCtoPago, Long idCategoria, Long anio) {
        if (idCtoPago != null && idCategoria == null) {
            this.minimoSeleccionDAO.guardarminSeleccionCtoPago(this.minimoSeleccionDAO.getSecuenciaSeleccion(), idCtoPago, anio);
        } else if (idCategoria != null) {
            this.minimoSeleccionDAO.guardarminSeleccionCtoPagoCateg(this.minimoSeleccionDAO.getSecuenciaSeleccion(), idCtoPago, idCategoria, anio);
        }
    }

    public void guardarMinSeleccionXAnio(List<FeesSuscriptorBD> minSelAnio) {
        this.minimoSeleccionDAO.guardarMinSeleccionXAnio(minSelAnio);
    }

    public void guardarMinSeleccionXCatAnio(List<FeesSuscriptorBD> minSel) {
        this.minimoSeleccionDAO.guardarMinSeleccionXCatAnio(minSel);
    }

    public void eliminarMinSeleccion(Long idCtoPago, Long idCateg) {
        if (idCtoPago != null && idCateg == null) {
            this.minimoSeleccionDAO.eliminarminSeleccionCtoPago(idCtoPago);
        } else if (idCateg != null) {
            this.minimoSeleccionDAO.eliminarminSeleccionCtoPagoCateg(idCtoPago, idCateg);
        }
    }

    public void eliminarMinSeleccionXCto(Long idContrato) {
        this.minimoSeleccionDAO.eliminarMinSeleccionXCto(idContrato);
    }

    public List<PeriodoInfoDTO> consultaInformacionRender(Long idContrato) {
        ArrayList<PeriodoInfoDTO> periodosLista = new ArrayList<PeriodoInfoDTO>();
        ArrayList<AnioInfoDTO> anniosLista = new ArrayList<AnioInfoDTO>();
        ArrayList<CategoriaInfoDTO> categoriasLista = new ArrayList<CategoriaInfoDTO>();
        List periodos = this.minimoSeleccionDAO.consultaPeriodosPagoContrato(idContrato);
        List categorias = this.minimoSeleccionDAO.consultaCategoriasPagoContrato(idContrato);
        List annios = this.minimoSeleccionDAO.obtenAnnioContrato(idContrato);
        for (ContratoPagoDTO periodo : periodos) {
            PeriodoInfoDTO periodoInfo = new PeriodoInfoDTO();
            periodoInfo.setIdContratoPago(periodo.getIdContratoPago());
            Integer annioIndex = 0;
            anniosLista = new ArrayList();
            do {
                AnioInfoDTO annioInfo = new AnioInfoDTO();
                AnnioDTO annio = new AnnioDTO();
                if (annios != null && annios.size() != 0) {
                    annio = (AnnioDTO)annios.get(annioIndex);
                    annioInfo.setAnnio(annio.getAnnio());
                    Integer n = annioIndex;
                    Integer n2 = annioIndex = Integer.valueOf(annioIndex + 1);
                } else {
                    annioInfo.setAnnio(null);
                    annioIndex = null;
                }
                categoriasLista = new ArrayList();
                for (ContratoPagoCategoriaDTO categoria : categorias) {
                    CategoriaInfoDTO categoriaInfo = new CategoriaInfoDTO();
                    categoriaInfo.setIdPagoCateg(categoria.getIdPagoCateg());
                    categoriaInfo.setDescCategoria(categoria.getDescCategoria());
                    categoriasLista.add(categoriaInfo);
                    ContratoMinimoSeleccionDTO params = new ContratoMinimoSeleccionDTO();
                    params.setIdContratoPago(periodoInfo.getIdContratoPago());
                    params.setIdPagoCategoria(categoriaInfo.getIdPagoCateg());
                    params.setAnnio(annioInfo.getAnnio());
                }
                annioInfo.setCategorias(categoriasLista);
                anniosLista.add(annioInfo);
            } while (annioIndex != null && annios != null && annios.size() != 0 && annioIndex < annios.size());
            periodoInfo.setAnnios(anniosLista);
            periodosLista.add(periodoInfo);
        }
        return periodosLista;
    }

    public List<ContratoPagoDTO> consultaInformacionPeriodos(Long idContrato) {
        return this.minimoSeleccionDAO.consultaPeriodosPagoContrato(idContrato);
    }

    public List<ContratoPagoCategoriaDTO> consultaInformacionCategorias(Long idContrato) {
        return this.minimoSeleccionDAO.consultaCategoriasPagoContrato(idContrato);
    }

    public List<AnnioDTO> consultaInformacionAnnios(Long idContrato) {
        return this.minimoSeleccionDAO.obtenAnnioContrato(idContrato);
    }

    public List<ContratoPagoFlatDTO> consultaInformacionCostoFlat(Long idContrato) {
        return this.minimoSeleccionDAO.consultaContratoPagoFlat(idContrato);
    }

    public List<AnnioDTO> consultaInformacionAnniosPorPeriodo(Long idContrato) {
        return this.minimoSeleccionDAO.obtenAnniosPeriodoPorContrato(idContrato);
    }

    public List<ContratoPagoCostoDTO> consultaInformacionCostoSubscriptores(Long idContrato) {
        ArrayList<ContratoPagoCostoDTO> contratoPagoCosto = new ArrayList<ContratoPagoCostoDTO>();
        List periodos = this.minimoSeleccionDAO.consultaPeriodosPagoContrato(idContrato);
        List categorias = this.minimoSeleccionDAO.consultaCategoriasPagoContrato(idContrato);
        HashMap<Long, Integer> noSuscriptoresPorPeriodo = new HashMap<Long, Integer>();
        List suscriptoresPeriodo = this.minimoSeleccionDAO.obtnerSuscriptoresPeriodo(idContrato);
        for (SuscriptoresPeriodoDTO peroido : suscriptoresPeriodo) {
            noSuscriptoresPorPeriodo.put(peroido.getIdContratoPago(), peroido.getSuscriptores());
        }
        for (ContratoPagoDTO periodo : periodos) {
            for (ContratoPagoCategoriaDTO categoria : categorias) {
                Long idContratoPago = periodo.getIdContratoPago();
                Long idPagoCategoria = categoria.getIdPagoCateg();
                ContratoPagoCostoDTO item = new ContratoPagoCostoDTO();
                item.setIdPagoCateg(idPagoCategoria);
                item.setIdContratoPago(idContratoPago);
                Integer noSuscriptores = (Integer)noSuscriptoresPorPeriodo.get(idContratoPago);
                String costo = this.minimoSeleccionDAO.obtenCostoPeriodo(idContratoPago, idPagoCategoria, Integer.valueOf(noSuscriptores == null ? 0 : noSuscriptores));
                item.setCosto(costo);
                contratoPagoCosto.add(item);
            }
        }
        return contratoPagoCosto;
    }

    public List<ContratoMinimoSeleccionDTO> consultaInformacionMinimos(Long idContrato) {
        return this.minimoSeleccionDAO.consultaMinimosSeleccionContrato(idContrato);
    }

    public void actualizaMinimoMonto(Long idContratoPago, Long idPagoCategoria, Integer annio, String minimoMonto) {
        this.logger.debug("idContratoPago: " + idContratoPago + " idPagoCategoria: " + idPagoCategoria + " annio: " + annio + " minimoMonto: " + minimoMonto);
        this.minimoSeleccionDAO.actualizaMinimoMonto(idContratoPago, idPagoCategoria, annio, minimoMonto);
    }

    public List<MontoRealDTO> consultaInformacionMontosReales(Long idContrato) {
        List montosReales = this.minimoSeleccionDAO.obtenInformacionMontoReal(idContrato);
        return montosReales;
    }
}

