/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.rest.services.client;

import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public final class JsonConverter {
    private static ObjectMapper mapper = new ObjectMapper();

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static <T> String toJson(T obj) throws IOException {
        String json = null;
        try {
            json = mapper.writeValueAsString(obj);
        }
        catch (JsonGenerationException jge) {
            throw new IOException(jge);
        }
        catch (JsonMappingException jme) {
            throw new IOException(jme);
        }
        if (json.equals("null")) {
            return "";
        }
        return json;
    }

    public static <T> T fromJson(String json, Class<T> cl) throws IOException {
        Object obj = null;
        try {
            obj = mapper.readValue(json, cl);
        }
        catch (JsonParseException je) {
            throw new IOException(je);
        }
        return (T)obj;
    }

    public static <T> T fromJson(String json, String className) throws IOException {
        Object obj = null;
        try {
            Class<?> cl = Class.forName(className);
            obj = mapper.readValue(json, cl);
        }
        catch (JsonParseException je) {
            throw new IOException(je);
        }
        catch (ClassNotFoundException cne) {
            throw new IOException(cne);
        }
        return (T)obj;
    }

    public static Map<String, Object> mapFromJson(String json) throws IOException {
        Map map;
        try {
            map = (Map)mapper.readValue(json, Map.class);
        }
        catch (JsonParseException je) {
            throw new IOException(je);
        }
        return map;
    }

    static {
        mapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES, false);
        mapper.configure(SerializationConfig.Feature.WRITE_NULL_PROPERTIES, false);
        mapper.configure(SerializationConfig.Feature.SORT_PROPERTIES_ALPHABETICALLY, true);
        mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

