/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.saaj.SaajSoapHeader;
import org.springframework.ws.soap.soap11.Soap11Header;

class SaajSoap11Header
extends SaajSoapHeader
implements Soap11Header {
    SaajSoap11Header(SOAPHeader header) {
        super(header);
    }

    @Override
    public Iterator<SoapHeaderElement> examineHeaderElementsToProcess(String[] actors) {
        ArrayList<SOAPHeaderElement> result = new ArrayList<SOAPHeaderElement>();
        Iterator iterator = this.getSaajHeader().examineAllHeaderElements();
        while (iterator.hasNext()) {
            SOAPHeaderElement saajHeaderElement = (SOAPHeaderElement)iterator.next();
            String headerActor = saajHeaderElement.getActor();
            if (!this.shouldProcess(headerActor, actors)) continue;
            result.add(saajHeaderElement);
        }
        return new SaajSoapHeader.SaajSoapHeaderElementIterator(result.iterator());
    }

    private boolean shouldProcess(String headerActor, String[] actors) {
        if (!StringUtils.hasLength((String)headerActor)) {
            return true;
        }
        if ("http://schemas.xmlsoap.org/soap/actor/next".equals(headerActor)) {
            return true;
        }
        if (!ObjectUtils.isEmpty((Object[])actors)) {
            for (String actor : actors) {
                if (!actor.equals(headerActor)) continue;
                return true;
            }
        }
        return false;
    }
}

