/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.carga.transaccion.bos;

import com.mx.dla.dda.carga.transaccion.daos.CargaTransaccionesDAO;
import com.mx.dla.dda.carga.transaccion.dtos.CargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.dtos.FechaBloqueoDTO;
import com.mx.dla.dda.carga.transaccion.dtos.PrincipalCargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowRepErrAsocTitulosDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowRepErrResumenCargaDTO;
import com.mx.dla.dda.carga.transaccion.dtos.RowReporteCargaDTO;
import com.mx.dla.dda.carga.transaccion.dtos.TitulosCargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.dtos.plantillaCargaTransaccionesDTO;
import com.mx.dla.dda.carga.transaccion.ws.asociarTitulosTransCntVigentes.ParamAsocTitTransCntVigentesDTO;
import com.mx.dla.dda.carga.transaccion.ws.asociarTitulosTransCntVigentes.ResponseAsociarTitTransCntVigentesDTO;
import com.mx.dla.dda.carga.transaccion.ws.procesarCargaTitulosPN.ParamCargaTitulosPNDTO;
import com.mx.dla.dda.carga.transaccion.ws.procesarCargaTitulosPN.ResponseCargaTitulosPNDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.bos.BeanPopulator;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.reporte.ws.dtos.ParamGeneraReporteDTO;
import com.mx.dla.dda.reporte.ws.dtos.ResponseGeneraReporteDTO;
import com.mx.dla.dda.reportes.ExcelGeneratorProcess.bos.ExcelGeneratorProcessBO;
import com.mx.dla.dda.reportes.generaxml.generaXMLimpl;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CargaTransaccionesBO
extends BaseBO {
    @Value(value="${uri.file.reporte.TransaccionesvistaPrevia}")
    private String filePath;
    @Autowired
    private ExcelGeneratorProcessBO excelGeneratorProcessBO;
    @Value(value="${uri.file.carga.transacciones}")
    private String uriCarga;
    @Value(value="${uri.file.reporte.baseActivosSQL}")
    protected String uriSQL;
    @Autowired
    private BeanPopulator beanPopulator;
    @Autowired
    private DLARestClientFactory dlaRestClientFactory;
    @Autowired
    private CargaTransaccionesDAO cargaTransaccionesDAO;
    @Autowired
    private ExcelMapperContext excelMapperContext;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    private generaXMLimpl genXml;
    ArrayList<String> textoSQLReporte = new ArrayList();
    ResponseGeneraReporteDTO responseDTO = null;

    public List<CargaTransaccionesDTO> obtenCargaTransacciones(String mes) throws TransaccionException {
        List cargaTransacciones = null;
        mes = this.obtenFechaFront(mes);
        try {
            cargaTransacciones = this.cargaTransaccionesDAO.obtenCargaTransacciones(mes);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener carga de transacciones.", ex);
        }
        return cargaTransacciones;
    }

    public PrincipalCargaTransaccionesDTO obtenerPrincipalCargaTransacciones(String mes) throws TransaccionException {
        PrincipalCargaTransaccionesDTO principalCarga = null;
        try {
            principalCarga = new PrincipalCargaTransaccionesDTO();
            principalCarga.setMesStr(this.obtenFechaFront(mes));
            principalCarga = this.cargaTransaccionesDAO.obtenerPrincipalCargaTransacciones(principalCarga);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener carga de transacciones.", ex);
        }
        return principalCarga;
    }

    public PrincipalCargaTransaccionesDTO obtenerResumenCarga(String mes) throws TransaccionException {
        PrincipalCargaTransaccionesDTO resumencarga = null;
        try {
            resumencarga = this.cargaTransaccionesDAO.obtenerResumenCarga(mes);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el Resumen de Carga Transacciones.", ex);
        }
        return resumencarga;
    }

    public PrincipalCargaTransaccionesDTO obtenerResumenCargaIdCargaTrans(Long idCarga) throws TransaccionException {
        PrincipalCargaTransaccionesDTO resumencarga = null;
        try {
            resumencarga = this.cargaTransaccionesDAO.obtenerResumenCargaIdCarga(idCarga);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el Resumen de Carga Transacciones.", ex);
        }
        return resumencarga;
    }

    private String obtenFechaFront(String mes) {
        String[] mesSeparado = mes.split("/");
        return mesSeparado.length == 3 ? "01/" + mesSeparado[0] + "/" + mesSeparado[2] : "01/12/2017";
    }

    public PrincipalCargaTransaccionesDTO registraCargaTransacciones(String mes) throws TransaccionException {
        PrincipalCargaTransaccionesDTO cargaPrincipal = new PrincipalCargaTransaccionesDTO();
        cargaPrincipal.setMesStr(this.obtenFechaFront(mes));
        try {
            this.cargaTransaccionesDAO.registrarPrincipalCarga(cargaPrincipal);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al registrar carga de transacciones.", ex);
        }
        return cargaPrincipal;
    }

    public ResponseAsociarTitTransCntVigentesDTO reCalculoPago(Long idCarga) throws TransaccionException {
        ParamAsocTitTransCntVigentesDTO request = new ParamAsocTitTransCntVigentesDTO();
        ResponseAsociarTitTransCntVigentesDTO response = null;
        DLARestClient client = null;
        try {
            Long idCargaTrans = idCarga;
            client = this.dlaRestClientFactory.getClient(DLARestServices.WS_CARGA_TRANSACCIONES_ASOCIARTITULOSTRANSCNTVIGENTES);
            request.setIdCargaTrans(idCargaTrans.toString());
            this.logger.debug("request : [{}]", (Object)request);
            response = client.get(request, ResponseAsociarTitTransCntVigentesDTO.class);
            this.logger.debug("response Recalculo Pago : [{}]", (Object)response);
            this.cargaTransaccionesDAO.calculaOverage(idCargaTrans);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al ejecutar el recalculo de pago.", ex);
        }
        return response;
    }

    public ResponseCargaTitulosPNDTO cargarArchivoDeTransacciones(File fileUpload, String fileName, String expediente, String mes, Long idCarga) throws TransaccionException {
        ParamCargaTitulosPNDTO request = new ParamCargaTitulosPNDTO();
        ResponseCargaTitulosPNDTO response = null;
        DLARestClient client = null;
        PrincipalCargaTransaccionesDTO cargaPrincipal = null;
        if (idCarga == null) {
            cargaPrincipal = this.registraCargaTransacciones(mes);
        }
        try {
            Long idCargaOk = idCarga != null ? idCarga : cargaPrincipal.getIdCarga();
            String nombreArchivo = this.uriCarga + idCargaOk + expediente + fileName;
            fileName = idCargaOk + expediente + fileName;
            byte[] file = FileUtils.readFileToByteArray((File)fileUpload);
            File d = new File(nombreArchivo);
            d.setExecutable(true, false);
            d.setReadable(true, false);
            d.setWritable(true, false);
            FileUtils.writeByteArrayToFile((File)d, (byte[])file);
            this.logger.info("Directorio: [{}]", (Object)nombreArchivo);
            this.logger.info("Archivo: [{}]", (Object)(idCargaOk + expediente + fileName));
            client = this.dlaRestClientFactory.getClient(DLARestServices.WS_CARGA_TRANSACCIONES_PROCESARCARGATITULOSPN);
            request.setNombreArchivo(fileName);
            request.setExpediente(expediente);
            request.setIdCargaTransacciones(idCargaOk.toString());
            this.logger.debug("request : [{}]", (Object)request);
            this.logger.debug("client!!! : [{}]", (Object)client);
            response = client.get(request, ResponseCargaTitulosPNDTO.class);
            response.setIdCarga(idCargaOk);
            this.logger.debug("response : [{}]", (Object)response);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al cargar el archivo de transacciones.", ex);
        }
        return response;
    }

    public InputStream dinamicIbatisRepVistaPrevia(String fileFileName, Long idCarga) throws TransaccionException, IOException, IllegalArgumentException, IllegalAccessException {
        int N;
        String tituloReporte = "Reporte Transacciones Vista Previa";
        String archivoGen = "";
        List<String> listaPaises = null;
        String pivot_paises = "";
        String pivot_select = "";
        String excelFileName = fileFileName + ".xlsx";
        fileFileName = fileFileName + ".xml";
        listaPaises = this.obtenListaPaisesVistaPrevia();
        for (N = 0; N < listaPaises.size(); ++N) {
            pivot_paises = pivot_paises + "'" + listaPaises.get(N) + "' AS " + listaPaises.get(N).replace(' ', '_') + ",";
        }
        for (N = 0; N < listaPaises.size(); ++N) {
            pivot_select = pivot_select + "NVL(" + listaPaises.get(N).replace(' ', '_') + ", 0) as " + listaPaises.get(N).replace(' ', '_') + ",";
        }
        List response = this.cargaTransaccionesDAO.obtenRowReporte(idCarga, pivot_select.substring(0, pivot_select.length() - 1), pivot_paises.substring(0, pivot_paises.length() - 1));
        archivoGen = this.genXml.generaXMLvp(response, fileFileName, tituloReporte);
        this.logger.info("{}", (Object)response);
        this.logger.info("xml en la ruta {}", (Object)archivoGen);
        return this.excelGeneratorProcessBO.generaExcelProceso(fileFileName, excelFileName);
    }

    public List<LinkedHashMap<String, String>> generaRepVistaPrevia(Long idCarga) throws TransaccionException, IllegalArgumentException, IllegalAccessException {
        List vistaprevia = null;
        try {
            int N;
            List<String> listaPaises = null;
            String pivot_paises = "";
            String pivot_select = "";
            listaPaises = this.obtenListaPaisesVistaPrevia();
            for (N = 0; N < listaPaises.size(); ++N) {
                pivot_paises = pivot_paises + "'" + listaPaises.get(N) + "' AS " + listaPaises.get(N).replace(' ', '_') + ",";
            }
            for (N = 0; N < listaPaises.size(); ++N) {
                pivot_select = pivot_select + "NVL(" + listaPaises.get(N).replace(' ', '_') + ", 0) as " + listaPaises.get(N).replace(' ', '_') + ",";
            }
            vistaprevia = this.cargaTransaccionesDAO.obtenReporteVistaPrevia(idCarga, pivot_select.substring(0, pivot_select.length() - 1), pivot_paises.substring(0, pivot_paises.length() - 1));
            this.logger.info("{}", (Object)vistaprevia);
        }
        catch (Exception e) {
            this.logger.error("Error al generar vista previa - generaRepVistaPrevia ::: {}", (Throwable)e);
        }
        return vistaprevia;
    }

    public ResponseGeneraReporteDTO obtenerVistaPrevia(String fileName, Long idCarga) throws TransaccionException, IOException, IllegalArgumentException, IllegalAccessException {
        int N;
        List<String> listaPaises = null;
        String id = idCarga.toString();
        String pivot_paises = "";
        String pivot_p = "";
        String pivot_select = "";
        String header = "";
        String first_header = "SELECT 'TIPO|ESTILO|CONCEPTO|";
        String finalHeader = "TOTAL|' as X from dual;";
        listaPaises = this.obtenListaPaisesVistaPrevia();
        for (N = 0; N < listaPaises.size(); ++N) {
            pivot_paises = pivot_paises + "'" + listaPaises.get(N) + "' AS P" + N + ",";
            header = header + "P" + N + "|";
        }
        header = first_header + header + finalHeader;
        for (N = 0; N < listaPaises.size(); ++N) {
            pivot_p = pivot_p + "P" + N + " ||'|'||";
            pivot_select = pivot_select + "NVL(P" + N + ", 0) as P" + N + ",";
        }
        pivot_p = "SELECT TIPO ||'|'|| ESTILO ||'|'|| CONCEPTO ||'|'||" + pivot_p;
        this.textoSQLReporte.clear();
        this.textoSQLReporte.add("--[BEGIN]");
        this.textoSQLReporte.add(header);
        this.textoSQLReporte.add("--[END_HEADER]");
        this.textoSQLReporte.add(pivot_p);
        this.textoSQLReporte.add("TOTAL| AS X");
        this.textoSQLReporte.add("from (SELECT CASE WHEN ESTUDIO IS NULL THEN 'total' WHEN TYPEA IS NULL THEN 'papa' ELSE ESTUDIO END AS TIPO, CASE WHEN ESTUDIO IS NULL THEN 'amarillo' WHEN TYPEA IS NULL THEN 'blanco' ELSE 'rosa' END AS ESTILO,\tNVL(TYPEA, NVL(ESTUDIO, 'TOTAL')) AS CONCEPTO,");
        this.textoSQLReporte.add(pivot_select);
        this.textoSQLReporte.add("TOTAL||'|' AS X");
        this.textoSQLReporte.add("FROM ( SELECT NVL(pv.DESCRIPCION, 'TOTAL') AS PAIS, ce.DESC_ESTUDIO AS ESTUDIO, ctt.TYPE_ABONO AS TYPEA, SUM(ctt.PAGO_MENSUAL) AS MONTO");
        this.textoSQLReporte.add("FROM DDA_T_CARGA_TRANSACCION ct, DDA_T_CARGA_TRANSACCION_TITULO ctt, DDA_C_FILIAL cf, DDA_C_EMPRESA_VENTA ev, DDA_C_PAIS_VENTA pv, DDA_C_ESTUDIO ce WHERE ct.ID_CARGA_TRANS =");
        this.textoSQLReporte.add(id);
        this.textoSQLReporte.add("AND ctt.ID_CARGA_TRANS = ct.ID_CARGA_TRANS AND ctt.ID_FILIAL = cf.ID_FILIAL AND cf.ID_EMPRESA = ev.ID_EMPRESA AND ev.ID_PAIS = pv.ID_PAIS AND ctt.ID_ESTUDIO = ce.ID_ESTUDIO");
        this.textoSQLReporte.add("GROUP BY GROUPING SETS((), (ce.DESC_ESTUDIO), (pv.DESCRIPCION), (ce.DESC_ESTUDIO, pv.DESCRIPCION), (ce.DESC_ESTUDIO, ctt.TYPE_ABONO), (pv.DESCRIPCION, ce.DESC_ESTUDIO, ctt.TYPE_ABONO))) PIVOT(SUM(MONTO) FOR PAIS ");
        this.textoSQLReporte.add("IN (");
        this.textoSQLReporte.add(pivot_paises);
        this.textoSQLReporte.add("'TOTAL' AS TOTAL)) ORDER BY ESTUDIO NULLS FIRST, TYPEA NULLS FIRST);");
        this.textoSQLReporte.add("--[END]");
        this.logger.info("Lista Paises: [{}]", listaPaises);
        this.logger.info("FILE NAME: [{}]", (Object)fileName);
        this.logger.info("header: [{}]", (Object)header);
        this.logger.info("pivot_paises: [{}]", (Object)pivot_paises);
        this.logger.info("pivot_p: [{}]", (Object)pivot_p);
        File file = new File(this.uriSQL + fileName + ".sql");
        FileUtils.writeLines((File)file, this.textoSQLReporte);
        this.logger.debug("busca archivo en [{}]", (Object)file.getAbsolutePath());
        if (file.exists()) {
            try {
                this.logger.info("Comienza llamada a Ws GENERA_TRANSACCIONES_VISTAPREVIA.");
                this.responseDTO = this.callWsGeneraReporte(fileName);
            }
            catch (Exception e) {
                this.logger.debug("error CargaTransaccionesBO: " + e.toString());
            }
        }
        return this.responseDTO;
    }

    public ResponseGeneraReporteDTO callWsGeneraReporte(String archivo) {
        DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.GENERA_TRANSACCIONES_VISTAPREVIA);
        ParamGeneraReporteDTO request = new ParamGeneraReporteDTO();
        this.logger.info("inicializa parametros.");
        request.setNombreArchivo(archivo);
        request.setFormato("json");
        request.setComprimir("n");
        this.logger.info("Request callWsGeneraReporte [{}]", (Object)request);
        ResponseGeneraReporteDTO response = client.get(request, ResponseGeneraReporteDTO.class);
        this.logger.info("Response callWsGeneraReporte [{}]", (Object)response);
        return response;
    }

    public JSONArray jsonVistaprevia(String ruta) {
        JSONArray lang = null;
        try {
            FileReader reader = new FileReader(this.filePath);
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = (JSONObject)jsonParser.parse((Reader)reader);
            lang = (JSONArray)jsonObject.get((Object)"rows");
            for (int i = 0; i < lang.size(); ++i) {
                System.out.println("The " + i + " element of the json: " + lang.get(i));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        return lang;
    }

    public byte[] obtenerDetalleErroresCarga(String mes) throws ExcelMapperException, IOException {
        List<RowRepErrResumenCargaDTO> rowReporteDetalleErroresCarga = new ArrayList();
        try {
            rowReporteDetalleErroresCarga = this.cargaTransaccionesDAO.obtenRowReporteResumenCarga(mes);
            if (rowReporteDetalleErroresCarga == null || rowReporteDetalleErroresCarga.isEmpty()) {
                rowReporteDetalleErroresCarga = new ArrayList();
                rowReporteDetalleErroresCarga.add(this.beanPopulator.initObject(RowRepErrResumenCargaDTO.class));
            }
            this.logger.debug("Descargar archivo Detalle Errores... se han  obtenido [{}]", (Object)rowReporteDetalleErroresCarga.size());
        }
        catch (Exception ex) {
            this.logger.error("Error-obtenerDetalleErroresCarga. al buscar contenido para descargar archivo detalle de carga...");
        }
        byte[] fileExcel = this.excelMapperTransform.transformObjectToExcel(rowReporteDetalleErroresCarga, "repDetalleErrorCargaTransaccion", RowRepErrResumenCargaDTO.class);
        this.logger.debug("Descargar archivo, se ha generado binario.");
        return fileExcel;
    }

    public byte[] obtenerListaErrAsocTitulos(Long idCarga) throws ExcelMapperException, IOException {
        List<RowRepErrAsocTitulosDTO> rowListadoErroresAsocTitulos = new ArrayList();
        try {
            rowListadoErroresAsocTitulos = this.cargaTransaccionesDAO.obtenRowReporteErrAsocTitulos(idCarga);
            if (rowListadoErroresAsocTitulos == null || rowListadoErroresAsocTitulos.isEmpty()) {
                rowListadoErroresAsocTitulos = new ArrayList();
                rowListadoErroresAsocTitulos.add(this.beanPopulator.initObject(RowRepErrAsocTitulosDTO.class));
            }
            this.logger.debug("Descargar archivo errores Asoctitulos: [{}]", (Object)rowListadoErroresAsocTitulos.size());
        }
        catch (Exception ex) {
            this.logger.error("Error_obtenerListaErrAsocTitulos. al buscar contenido para descargar archivo errores Asoctitulos...");
        }
        byte[] fileExcel = this.excelMapperTransform.transformObjectToExcel(rowListadoErroresAsocTitulos, "repErroresAsociacionTitulos", RowRepErrAsocTitulosDTO.class);
        this.logger.debug("Descargar archivo, se ha generado binario.");
        return fileExcel;
    }

    public byte[] descargarArchivoTransacciones(List<CargaTransaccionesDTO> infoReporte) throws TransaccionException {
        for (CargaTransaccionesDTO c : infoReporte) {
            this.logger.debug("[{}]", (Object)c);
        }
        byte[] barchivo = null;
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("cargaTransacciones");
        System.out.println("mapper:" + mapper);
        try {
            barchivo = this.excelMapperTransform.transformObjectToExcel(infoReporte, mapper, CargaTransaccionesDTO.class);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el excel.", ex);
        }
        return barchivo;
    }

    public byte[] descargaArchivoVistaPrevia(List<RowReporteCargaDTO> inforowReporte) throws TransaccionException {
        for (RowReporteCargaDTO c : inforowReporte) {
            this.logger.debug("[{}]", (Object)c);
        }
        byte[] barchivo = null;
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("cargaTransacciones2");
        try {
            barchivo = this.excelMapperTransform.transformObjectToExcel(inforowReporte, mapper, RowReporteCargaDTO.class);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el excel.", ex);
        }
        return barchivo;
    }

    public byte[] descargaArchivoResumenErroresCarga(List<RowRepErrResumenCargaDTO> infoRow) throws TransaccionException {
        for (RowRepErrResumenCargaDTO c : infoRow) {
            this.logger.debug("[{}]", (Object)c);
        }
        byte[] bFile = null;
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("repDetalleErrorCargaTransaccion");
        this.logger.debug("[{}]", (Object)mapper);
        System.out.println("mapper resumen carga:" + mapper);
        try {
            bFile = this.excelMapperTransform.transformObjectToExcel(infoRow, mapper, RowRepErrResumenCargaDTO.class);
            System.out.println("mapperDetalleCarga:" + mapper);
        }
        catch (Exception ex) {
            throw new TransaccionException("DetalleErroresCargaTransacciones. Error al obtener el arhivo excel.", ex);
        }
        return bFile;
    }

    public byte[] descargaArchivoErrAsocTitulos(List<RowRepErrAsocTitulosDTO> infoRowAsocTit) throws TransaccionException {
        for (RowRepErrAsocTitulosDTO c : infoRowAsocTit) {
            this.logger.debug("[{}]", (Object)c);
        }
        byte[] bFile = null;
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("repErroresAsociacionTitulos");
        this.logger.debug("[{}]", (Object)mapper);
        System.out.println("mapper Errores AsocTitulos:" + mapper);
        try {
            bFile = this.excelMapperTransform.transformObjectToExcel(infoRowAsocTit, mapper, RowRepErrAsocTitulosDTO.class);
            System.out.println("mapperDetalleCarga:" + mapper);
        }
        catch (Exception ex) {
            throw new TransaccionException("descargaArchivoErrAsocTitulos. Error al obtener el arhivo excel.", ex);
        }
        return bFile;
    }

    public List<TitulosCargaTransaccionesDTO> titulosdelaCarga(String mes) throws TransaccionException {
        List titulosCarga = null;
        try {
            titulosCarga = this.cargaTransaccionesDAO.titulosdelaCarga(mes);
            System.out.println(titulosCarga);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al cargar titulos en Contratos." + ex);
        }
        return titulosCarga;
    }

    public List<TitulosCargaTransaccionesDTO> sinIdBroadView(Long idCarga) throws TransaccionException {
        List sinIdBv = null;
        try {
            sinIdBv = this.cargaTransaccionesDAO.sinIdBroadView(idCarga);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al cargar titulos sin IdBv." + ex);
        }
        return sinIdBv;
    }

    public List<TitulosCargaTransaccionesDTO> idBroadViewNoExiste(Long idCarga) throws TransaccionException {
        List IdBvNoExiste = null;
        try {
            IdBvNoExiste = this.cargaTransaccionesDAO.idBroadViewNoExiste(idCarga);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al cargar titulos sin IdBv." + ex);
        }
        return IdBvNoExiste;
    }

    public List<TitulosCargaTransaccionesDTO> tituloyFilialNoExiste(Long idCarga) throws TransaccionException {
        List tyfNoExiste = null;
        try {
            tyfNoExiste = this.cargaTransaccionesDAO.tituloyFilialNoExiste(idCarga);
            System.out.println(tyfNoExiste);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al cargar titulos y filial no existe." + ex);
        }
        return tyfNoExiste;
    }

    public List<TitulosCargaTransaccionesDTO> tituloFueradePeriodo(Long idCarga) throws TransaccionException {
        List titulofueraperiodo = null;
        try {
            titulofueraperiodo = this.cargaTransaccionesDAO.tituloFueradePeriodo(idCarga);
            System.out.println(titulofueraperiodo);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al cargar titulos fuera de periodo." + ex);
        }
        return titulofueraperiodo;
    }

    public void actualizarIdBv(String IdBv, Integer id_carga_titulo, String nombreEstandar) throws Exception {
        try {
            TitulosCargaTransaccionesDTO itemTitulosCargaTransaccionesDTO = new TitulosCargaTransaccionesDTO();
            itemTitulosCargaTransaccionesDTO.setIdBv(IdBv);
            itemTitulosCargaTransaccionesDTO.setId_carga_titulo(id_carga_titulo);
            itemTitulosCargaTransaccionesDTO.setNombreEstandar(nombreEstandar);
            this.cargaTransaccionesDAO.actualizarIdBv(itemTitulosCargaTransaccionesDTO);
            System.out.println("Se va a actualizar IdBv:  " + IdBv + "con id carga: " + id_carga_titulo);
        }
        catch (Exception e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion IdBv." + e);
        }
    }

    public void ejecutaSP(String fecha) throws Exception {
        try {
            this.cargaTransaccionesDAO.ejecutaSP(fecha);
            System.out.println("Se va a actualizar fecha:  " + fecha);
        }
        catch (Exception e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        }
    }

    public FechaBloqueoDTO consultaMesActual(String anio, String mes) throws Exception {
        FechaBloqueoDTO response = new FechaBloqueoDTO();
        try {
            List fechas = this.cargaTransaccionesDAO.consultarFechaActual(mes, anio);
            if (fechas.isEmpty()) {
                response.setDia("27");
                response.setMes(mes);
                response.setAnio(anio);
            } else {
                response = (FechaBloqueoDTO)fechas.get(0);
            }
            System.out.println("Fecha recuperada:  " + response.getDia() + "/" + response.getMes() + "/" + response.getAnio());
        }
        catch (Exception e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        }
        return response;
    }

    public void ejecutaSP_porcR(String fecha) throws Exception {
        try {
            this.cargaTransaccionesDAO.ejecutaSP_porcR(fecha);
            System.out.println("ejecutaSP_porcR:  " + fecha);
        }
        catch (Exception e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        }
    }

    public void ejecutaSP_MarcaCont(String in_Contrato, String in_Estudio) throws Exception {
        try {
            this.cargaTransaccionesDAO.ejecutaSP_MarcaCont(in_Contrato, in_Estudio);
            System.out.println("ejecutaSP_MarcaCont:  " + in_Estudio);
        }
        catch (Exception e) {
            throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
        }
    }

    public void validaCarga(Long idCarga) throws Exception {
        PrincipalCargaTransaccionesDTO principalcarga = new PrincipalCargaTransaccionesDTO();
        try {
            if (idCarga != null) {
                principalcarga.setIdCarga(idCarga);
                this.cargaTransaccionesDAO.validaCarga(principalcarga);
                System.out.println("Se va a validar la carga:  ");
            }
        }
        catch (Exception e) {
            throw new TransaccionException("Error al validar carga." + e);
        }
    }

    public List<String> obtenListaPaises() throws TransaccionException {
        List lista = null;
        try {
            lista = this.cargaTransaccionesDAO.obtenListaPaises();
            lista.add(0, "Estudio");
            lista.add("Total");
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener los paises.", ex);
        }
        return lista;
    }

    public List<String> obtenListaPaisesVistaPrevia() throws TransaccionException {
        List lista = null;
        try {
            lista = this.cargaTransaccionesDAO.obtenListaPaises();
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener los paises.", ex);
        }
        return lista;
    }

    public byte[] obtenPlantilla() {
        byte[] plantilla = null;
        ArrayList<plantillaCargaTransaccionesDTO> lista = new ArrayList<plantillaCargaTransaccionesDTO>();
        ExcelMapper mapper = null;
        plantillaCargaTransaccionesDTO li = new plantillaCargaTransaccionesDTO();
        lista.add(li);
        try {
            mapper = this.excelMapperContext.getExcelMapper("plantillaCargaTransacciones");
            plantilla = this.excelMapperTransform.transformObjectToExcel(lista, mapper, plantillaCargaTransaccionesDTO.class);
        }
        catch (Exception ex) {
            this.logger.error("Error_BO:obtenPlantilla [{}]", (Throwable)ex);
        }
        return plantilla;
    }
}

