/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.catalogos.bos;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.catalogos.dtos.CategoriaDTO;
import com.mx.dla.dda.catalogos.dtos.EmpresaVentaDTO;
import com.mx.dla.dda.catalogos.dtos.EstatusDTO;
import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.catalogos.dtos.FormatoDTO;
import com.mx.dla.dda.catalogos.dtos.MedioEntregaDTO;
import com.mx.dla.dda.catalogos.dtos.PaisVentaDTO;
import com.mx.dla.dda.catalogos.dtos.RegionVentaDTO;
import com.mx.dla.dda.catalogos.dtos.ReleaseDTO;
import com.mx.dla.dda.catalogos.dtos.ServicioDTO;
import com.mx.dla.dda.catalogos.dtos.TerritorioDTO;
import com.mx.dla.dda.contrato.fees.dtos.TiempoVidaDTO;
import com.mx.dla.dda.contrato.fees.dtos.TipoSuscriptorDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CatalogosBO {
    @Autowired
    private CatalogosDAO catalogosDAO;

    public List<EstudioDTO> obtenListaEstudios() {
        return this.catalogosDAO.obtenerEstudios();
    }

    public List<CategoriaDTO> obtenListaCategorias() {
        return this.catalogosDAO.obtenerCategorias();
    }

    public List<ServicioDTO> obtenListaServicios() {
        return this.catalogosDAO.obtenerServicios();
    }

    public List<TerritorioDTO> obtenListaTerritorios() {
        return this.catalogosDAO.obtenerTerritorios();
    }

    public List<MedioEntregaDTO> obtenListaMediosEntrega() {
        return this.catalogosDAO.obtenerMediosEntrega();
    }

    public List<EstatusDTO> obtenerEstatus() {
        return this.catalogosDAO.obtenerEstatus();
    }

    public List<FormatoDTO> getFormatos() {
        return this.catalogosDAO.getFormatos();
    }

    public List<ReleaseDTO> getReleases() {
        return this.catalogosDAO.getReleases();
    }

    public List<PaisVentaDTO> getPaises() {
        return this.catalogosDAO.getPaises();
    }

    public int obtenSqIdContrato(String tipoOperacion, int idContrato) {
        if (tipoOperacion.equals("Alta")) {
            idContrato = this.catalogosDAO.obtenerSqIdContrato();
        }
        return idContrato;
    }

    public List<EmpresaVentaDTO> getEmpresasVenta() {
        ArrayList<EmpresaVentaDTO> empresas = new ArrayList();
        empresas = this.catalogosDAO.getEmpresasVenta();
        return empresas;
    }

    public PaisVentaDTO getPaisXId(Long idPais) {
        return this.catalogosDAO.getPaisXId(idPais);
    }

    public RegionVentaDTO getRegionXId(@Param(value="id") Long id) {
        return this.catalogosDAO.getRegionXId(id);
    }

    public List<RegionVentaDTO> getRegiones() {
        return this.catalogosDAO.getRegiones();
    }

    public List<TipoSuscriptorDTO> obtenerTipoSuscriptor() {
        return this.catalogosDAO.obtenerTipoSuscriptor();
    }

    public List<TiempoVidaDTO> obtenerTiempoVida() {
        return this.catalogosDAO.obtenerTiempoVida();
    }

    public List<CatalogoDTO> obtenCatalogoEmpresas(List<Long> idEmpresas, List<Long> idPaises, List<String> descEmpresas, List<Long> staEmpresas) {
        return this.catalogosDAO.obtenCatalogoEmpresas(idEmpresas, idPaises, descEmpresas, staEmpresas);
    }

    public List<CatalogoDTO> obtenCatalogoAreas(List<Long> idAreas, List<String> descAreas, List<Long> indAutorizaContratoAreas, List<Long> ordenAreas) {
        return this.catalogosDAO.obtenCatalogoAreas(idAreas, descAreas, indAutorizaContratoAreas, ordenAreas);
    }

    public List<CatalogoDTO> obtenCatalogoPerfiles(List<Long> idPerfiles, List<String> descPerfiles, List<Long> staPerfiles) {
        return this.catalogosDAO.obtenCatalogoPerfiles(idPerfiles, descPerfiles, staPerfiles);
    }

    public List<CatalogoDTO> obtenCatalogoEstudios(List<Long> idEstudios, List<Long> idSapEstudios, List<String> descEstudios, List<String> monedaEstudios, List<String> codigoPaisEstudios, List<String> nombrePaisEstudios, List<String> sociedadEstudios, List<String> siglaDdaEstudios, List<Long> ordenEstudios, List<Long> idGroupEstudios) {
        return this.catalogosDAO.obtenCatalogoEstudios(idEstudios, idSapEstudios, descEstudios, monedaEstudios, codigoPaisEstudios, nombrePaisEstudios, sociedadEstudios, siglaDdaEstudios, ordenEstudios, idGroupEstudios);
    }

    public List<CatalogoDTO> obtenCatalogoPeliculasSeries(long idEstudio) {
        return this.catalogosDAO.buscarCatalogoTitulosCPV(Long.valueOf(idEstudio));
    }

    public List<CatalogoDTO> obtenCatalogoTemporadas(long idEstudio, String nombreUnico) {
        return this.catalogosDAO.buscarCatalogoTemporadas(Long.valueOf(idEstudio), nombreUnico);
    }

    public List<CatalogoDTO> obtenContratos(long idEstudio) {
        return this.catalogosDAO.buscarContratosPorEstudio(Long.valueOf(idEstudio));
    }

    public List<CatalogoDTO> obtenCatalogoPeliculasSeriesDC(long contrato) {
        return this.catalogosDAO.buscarCatalogoTitulosDC(Long.valueOf(contrato));
    }

    public List<CatalogoDTO> obtenCatalogoTemporadasDC(long idEstudio, Long nombreUnico) {
        return this.catalogosDAO.buscarCatalogoTemporadasDC(Long.valueOf(idEstudio), nombreUnico);
    }
}

