/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.titulo.bos;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.contrato.common.bos.CommonRestBO;
import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.FechasDTO;
import com.mx.dla.dda.contrato.generales.dtos.InfoDetalleContratoDTO;
import com.mx.dla.dda.contrato.generales.enums.Movimiento;
import com.mx.dla.dda.contrato.titulo.bos.TitulosUtilBO;
import com.mx.dla.dda.contrato.titulo.constants.TipoCambioTitulo;
import com.mx.dla.dda.contrato.titulo.daos.TituloDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDmDAO;
import com.mx.dla.dda.contrato.titulo.dtos.AmortizacionSAP;
import com.mx.dla.dda.contrato.titulo.dtos.SapNum;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.titulo.rules.TituloRules;
import com.mx.dla.dda.contrato.titulos.dtos.ResponseValorTituloDTO;
import com.mx.dla.global.bos.BaseBO;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TitulosBussinesBO
extends BaseBO {
    @Autowired
    protected CommonRestBO commonRestBO;
    @Autowired
    protected TituloDAO tituloDAO;
    @Autowired
    private TituloDmDAO tituloDmDAO;
    @Autowired
    protected GeneralesDAO generalesDAO;
    @Autowired
    protected CatalogosDAO catalogosDAO;
    @Autowired
    protected TituloRules tituloRules;
    @Autowired
    private TitulosUtilBO titulosUtilBO;
    DecimalFormat df = new DecimalFormat("#.00");

    public void verificarEnmiendaActualizacion(Titulo titulo, String tipoCambio, ContratoDTO contrato) throws TituloException {
        Titulo actual = this.tituloDmDAO.buscarTitulo(titulo.getIdTituloCnt());
        titulo.setIdSap(actual.getIdSap());
        titulo.setFechaNotifsap(actual.getFechaNotifsap());
        titulo.setIdContrato(actual.getIdContrato());
        titulo.setIdTituloCntorig(actual.getIdTituloCntorig());
        this.logger.debug(titulo.toString());
        this.logger.debug(actual.toString());
        if (titulo.getIdSap() != null) {
            this.logger.debug("idsap");
            if (TipoCambioTitulo.VENTANA.name().equals(tipoCambio)) {
                if (titulo.getFechaNotifsap() != null) {
                    this.logger.debug("ventana");
                    titulo.setAjustoVu(Long.valueOf(1L));
                    titulo.setVidaUtil(this.titulosUtilBO.calcularVidaUtil(titulo.getFechaInicio(), titulo.getFechaFin()));
                    titulo.setMesesvu(this.titulosUtilBO.calculaMesesVidaUtil(titulo.getFechaInicio(), titulo.getFechaFin()));
                    if (actual.getFechaContabilizacion() == null) {
                        titulo.setFechaContabilizacion(new Date());
                    }
                    this.tituloDmDAO.actualizarTituloCambio(titulo);
                } else {
                    throw new TituloException("No se puede modificar, no se ha notificado a sap.");
                }
            }
            if (TipoCambioTitulo.COSTO.name().equals(tipoCambio)) {
                if (titulo.getFechaNotifsap() != null) {
                    this.logger.debug("costo");
                    actual.setPrecioAnual(titulo.getPrecioAnual());
                    actual.setPagoCateg(titulo.getPagoCateg());
                    actual.setAnioContrato(titulo.getAnioContrato());
                    actual.setFechaContabilizacion(titulo.getFechaContabilizacion());
                    actual.setFlgcalculoPrecio(titulo.getFlgcalculoPrecio());
                    this.tituloDmDAO.actualizarTitulo(actual);
                } else {
                    throw new TituloException("No se puede modificar, no se ha notificado a sap.");
                }
            }
            if (TipoCambioTitulo.TRASLADAR.name().equals(tipoCambio) && titulo.getFechaNotifsap() != null) {
                this.logger.debug("trasladar");
                titulo.setVidaUtil(this.titulosUtilBO.calcularVidaUtil(titulo.getFechaInicio(), titulo.getFechaFin()));
                titulo.setMesesvu(this.titulosUtilBO.calculaMesesVidaUtil(titulo.getFechaInicio(), titulo.getFechaFin()));
                titulo.setEstatus("ACTIVO");
                titulo.setIdSapAnt(actual.getIdSap());
                titulo.setIdSap("PDTE");
                titulo.setFechaNotifsap(actual.getFechaNotifsap());
                titulo.setIdTituloCntant(actual.getIdTituloCnt());
                titulo.setAjustoTitulo(Long.valueOf(1L));
                this.tituloDmDAO.insertarTitulo(titulo);
                titulo.setIdTituloCntorig(titulo.getIdTituloCnt());
                this.tituloDmDAO.actualizarTitulo(titulo);
                actual.setEstatus("ELIMINADO");
                actual.setIdTituloCntnvo(titulo.getIdTituloCnt());
                this.tituloDmDAO.actualizarTitulo(actual);
            }
        }
    }

    public void actualizarSapnumTraslados(Long idContrato) throws TituloException {
        List titulos = this.tituloDmDAO.buscarTitulosTrasladados(idContrato, "M");
        for (Titulo t : TitulosBussinesBO.safeList(titulos)) {
            Titulo tituloAnterior = this.tituloDmDAO.buscarTituloEstatus(t.getIdTituloCntant(), "ELIMINADO");
            if (tituloAnterior == null) continue;
            double costoAnt = tituloAnterior.getCosto() == null ? 0.0 : Double.parseDouble(tituloAnterior.getCosto());
            double costoActual = t.getCosto() == null ? 0.0 : Double.parseDouble(t.getCosto());
            if (costoActual != costoAnt) continue;
            List sapNumContables = this.tituloDmDAO.getSAPNUMTrasladados(t.getIdTituloCntant());
            for (SapNum s : TitulosBussinesBO.safeList(sapNumContables)) {
                s.setIdTituloCNT(t.getIdTituloCnt());
                s.setIdTituloCtoOrig(t.getIdTituloCntorig());
                this.tituloDmDAO.insertarSapSubnum(s);
            }
        }
    }

    public void actualizarBanderasTraslados(Long idContrato) throws TituloException {
        List titulos = this.tituloDmDAO.buscarTitulosTrasladados(idContrato, "M");
        for (Titulo t : TitulosBussinesBO.safeList(titulos)) {
            double costoActual;
            Titulo tituloAnterior = this.tituloDmDAO.buscarTituloEstatus(t.getIdTituloCntant(), "ELIMINADO");
            if (tituloAnterior == null) continue;
            double costoAnt = tituloAnterior.getCosto() == null ? 0.0 : Double.parseDouble(tituloAnterior.getCosto());
            double d = costoActual = t.getCosto() == null ? 0.0 : Double.parseDouble(t.getCosto());
            if (costoActual == costoAnt) {
                t.setAjustoValor(null);
                this.tituloDmDAO.actualizarTitulo(t);
                continue;
            }
            t.setAjustoValor(Long.valueOf(1L));
            this.tituloDmDAO.actualizarTitulo(t);
        }
    }

    public void actualizaCostoTodosLosTitulos(ContratoDTO contrato) {
        try {
            ResponseValorTituloDTO response = this.commonRestBO.llamadaCostoTitulo(contrato.getFechaInicio(), contrato.getIdContrato(), "ESPEJO");
            if (!response.getResultado()) {
                this.logger.error("No fue posible actualizar el costo razon:[{}]", (Object)response.getMensaje());
            }
        }
        catch (Exception e) {
            this.logger.error("Ocurrio un error al tratar de generar los costos", (Throwable)e);
        }
    }

    public void procesoActualizacionTitulosEnmienda(Long idCto) {
        InfoDetalleContratoDTO detalle = this.generalesDAO.obtenDetalleContrato(idCto);
        if (detalle.getTipoMovimiento().intValue() == Movimiento.Enmienda.getValor().intValue()) {
            List titulos = this.tituloDmDAO.buscarTitulosEnmiendaSincro(idCto, "T");
            this.logger.debug("Se inicia el proceso de sincronizacion con enmiendas con titulos:{}", (Object)titulos.size());
            for (Titulo t : titulos) {
                this.tituloDmDAO.borrarRegistroSAPNUM(t.getIdTituloCnt());
                this.actualizarCostoEnmienda(t, "T");
            }
        }
    }

    public String procesoActualizacionTitulosEnmienda(Long idCto, String prefix) {
        String titulosNoValidos = null;
        InfoDetalleContratoDTO detalle = this.generalesDAO.obtenDetalleContrato(idCto);
        if (detalle.getTipoMovimiento().intValue() == Movimiento.Enmienda.getValor().intValue()) {
            List titulos = this.tituloDmDAO.buscarTitulosEnmiendaSincro(idCto, prefix);
            this.logger.debug("Se inicia el proceso de sincronizacion con enmiendas con titulos:{}", (Object)titulos.size());
            for (Titulo t : titulos) {
                this.logger.info("id eliminar sap-num {}", (Object)t.getIdTituloCnt());
                String res = this.verificarCostoEnmienda(t);
                if (res == null) {
                    this.tituloDmDAO.borrarRegistroSAPNUM(t.getIdTituloCnt());
                    this.actualizarCostoEnmienda(t, prefix);
                    continue;
                }
                if (titulosNoValidos == null) {
                    titulosNoValidos = t.getDescTitulo();
                    continue;
                }
                titulosNoValidos = titulosNoValidos + "," + t.getDescTitulo();
            }
        }
        return titulosNoValidos;
    }

    public void actualizarCostoEnmienda(Titulo titulo, String prefix) {
        this.logger.info("Actualizacion banderas cambio de titulo-enmienda");
        this.logger.info(titulo.toString());
        Double diferencia = this.obtenerDiferenciaCostoTitulo(titulo);
        List valoresNetosContables = this.tituloDmDAO.buscaMaxSubNumByFechaAmort(titulo.getIdTituloCntorig(), Integer.valueOf(this.getAnioActual()));
        List sapNumContables = this.tituloDmDAO.getAumnentosSAPNUMContables(titulo.getIdTituloCntorig(), Integer.valueOf(this.getAnioActual()));
        this.logger.info("Diferencia {}", (Object)diferencia);
        if (diferencia < 0.0 && titulo.getFechaNotifsap() != null) {
            SapNum sapNum = new SapNum(titulo.getIdContrato(), titulo.getIdTituloCnt(), titulo.getIdTituloCntorig());
            titulo.setAjustoValor(Long.valueOf(-1L));
            titulo.setAjustoVu(null);
            sapNum.setDisminucion(this.df.format(diferencia * -1.0));
            this.tituloDmDAO.actualizarTituloVar(titulo, prefix);
            if (valoresNetosContables == null || valoresNetosContables.isEmpty()) {
                sapNum.setSubnumero("0000");
                this.tituloDmDAO.insertarSapSubnum(sapNum);
            } else {
                this.asignarDiferenciaSubNum(diferencia, sapNumContables, valoresNetosContables, sapNum);
            }
        } else if (diferencia > 0.0 && titulo.getFechaNotifsap() != null) {
            SapNum sapNum = new SapNum(titulo.getIdContrato(), titulo.getIdTituloCnt(), titulo.getIdTituloCntorig());
            titulo.setAjustoValor(Long.valueOf(1L));
            titulo.setAjustoVu(null);
            sapNum.setAumento(this.df.format(diferencia));
            this.tituloDmDAO.actualizarTituloVar(titulo, prefix);
            this.tituloDmDAO.insertarSapSubnum(sapNum);
            this.logger.info("sap-num guardao {}", (Object)sapNum.toString());
        } else {
            this.logger.info("Diferencia 0 se actuliza titulo");
            titulo.setAjustoValor(Long.valueOf(0L));
            this.tituloDmDAO.actualizarTituloVar(titulo, prefix);
        }
    }

    public Double obtenerDiferenciaCostoTitulo(Titulo titulo) {
        this.logger.info("Actualizacion banderas cambio de titulo-enmienda");
        this.logger.info(titulo.toString());
        SapNum anterior = this.tituloDmDAO.getAumentosDisminXTitulo(titulo.getIdTituloCntorig(), titulo.getIdContrato());
        if (anterior != null) {
            this.logger.info("previo {}", (Object)anterior.toString());
        }
        Double aumentos = anterior == null || anterior.getAumento() == null ? 0.0 : Double.parseDouble(anterior.getAumento());
        Double disminucion = anterior == null || anterior.getDisminucion() == null ? 0.0 : Double.parseDouble(anterior.getDisminucion());
        Double costo = titulo.getCosto() == null ? 0.0 : Double.parseDouble(titulo.getCosto());
        Double diferencia = costo - (aumentos - disminucion);
        diferencia = (double)Math.round(diferencia * 100.0) / 100.0;
        return diferencia;
    }

    public int getAnioActual() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int year = cal.get(1);
        return year;
    }

    public String verificarCostoEnmienda(Titulo titulo) {
        this.logger.info("se inicia validacion enimeinda costo");
        String valido = null;
        if (titulo.getFechaNotifsap() != null) {
            Double diferencia = this.obtenerDiferenciaCostoTitulo(titulo);
            List valoresNetosContables = this.tituloDmDAO.buscaMaxSubNumByFechaAmort(titulo.getIdTituloCntorig(), Integer.valueOf(this.getAnioActual()));
            List sapNumContables = this.tituloDmDAO.getAumnentosSAPNUMContables(titulo.getIdTituloCntorig(), Integer.valueOf(this.getAnioActual()));
            if (diferencia < 0.0) {
                if (valoresNetosContables == null || valoresNetosContables.isEmpty()) {
                    valido = null;
                } else {
                    double valorNetoContable = 0.0;
                    for (AmortizacionSAP s : TitulosBussinesBO.safeList(valoresNetosContables)) {
                        valorNetoContable += Double.parseDouble(s.getVnc());
                    }
                    this.logger.debug("vnc:{}", (Object)valorNetoContable);
                    this.logger.debug("diferencia:{}", (Object)diferencia);
                    if (Math.abs(diferencia) <= valorNetoContable) {
                        boolean asignado = this.verificarAsignarDiferenciaSubNum(diferencia, sapNumContables, valoresNetosContables);
                        if (!asignado) {
                            valido = titulo.getDescTitulo();
                        }
                    } else {
                        valido = titulo.getDescTitulo();
                    }
                }
            }
        }
        this.logger.info("valido {}", valido);
        return valido;
    }

    public boolean verificarAsignarDiferenciaSubNum(Double disminucion, List<SapNum> sapNumContables, List<AmortizacionSAP> valoresNetosContables) {
        Boolean asignado = false;
        double disminucionVerificar = disminucion * -1.0;
        for (AmortizacionSAP m : TitulosBussinesBO.safeList(valoresNetosContables)) {
            if (disminucionVerificar > 0.0) {
                double valorNeto = Double.parseDouble(m.getVnc());
                disminucionVerificar -= valorNeto;
            }
            if (!(disminucionVerificar <= 0.0)) continue;
            asignado = true;
            break;
        }
        this.logger.info("Se ha asignado la disminucion? {}", (Object)asignado);
        return asignado;
    }

    public void asignarDiferenciaSubNum(Double disminucion, List<SapNum> sapNumContables, List<AmortizacionSAP> valoresNetosContables, SapNum sapNum) {
        Boolean asignado = false;
        double disminucionVerificar = disminucion * -1.0;
        for (AmortizacionSAP m : valoresNetosContables) {
            if (disminucionVerificar > 0.0) {
                double valorNeto = Double.parseDouble(m.getVnc());
                if (valorNeto > 0.0) {
                    sapNum.setSubnumero(m.getSubNumero());
                    String valor = valorNeto >= disminucionVerificar ? String.valueOf(disminucionVerificar) : String.valueOf(valorNeto);
                    sapNum.setDisminucion(valor);
                    this.tituloDmDAO.insertarSapSubnum(sapNum);
                }
                disminucionVerificar -= valorNeto;
            }
            if (!(disminucionVerificar <= 0.0)) continue;
            asignado = true;
            break;
        }
        this.logger.info("Se ha asignado la disminucion? {}", (Object)asignado);
    }

    private SapNum getSapNum(Long idContrato, Long idTituloCNT, Long idTituloCNTORI, Double disminucion, Long idRegistroSap, String subnumero) {
        SapNum sapNum = new SapNum(idContrato, idTituloCNT, idTituloCNTORI);
        if (disminucion != null) {
            sapNum.setDisminucion(this.df.format(disminucion));
        }
        if (idRegistroSap != null) {
            sapNum.setIdRegistroSAP(idRegistroSap);
        }
        if (subnumero != null) {
            sapNum.setSubnumero(subnumero);
        }
        return sapNum;
    }

    public ContratoDTO calculaFechasInicioFinValidacion(ContratoDTO contrato) {
        ContratoDTO cv = null;
        try {
            cv = (ContratoDTO)BeanUtils.cloneBean((Object)contrato);
            FechasDTO fechas = this.generalesDAO.obtenerFechasMaximaMinimaDeContratosPorContratoOriginal(contrato.getIdContratoOriginal());
            cv.setFechaInicio(fechas.getInicio());
            cv.setFechaFin(fechas.getFin());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.error("Error ", (Throwable)e);
        }
        return cv;
    }

    public static <T> List<T> safeList(List<T> other) {
        return other == null ? Collections.EMPTY_LIST : other;
    }
}

