/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.acumulateBuys.bos;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.general.constants.MesesAnio;
import com.mx.dla.dda.general.utilerias.FechaUtilerias;
import com.mx.dla.dda.reporte.acumulateBuys.dao.ReporteAcumulateBuysDAO;
import com.mx.dla.dda.reporte.acumulateBuys.dto.acumulateBuysEstudiosDTO;
import com.mx.dla.dda.reporte.general.dtos.CeldaBaseDTO;
import com.mx.dla.dda.reporte.reportecfg.daos.ReporteConfiguracionDAO;
import com.mx.dla.dda.reportes.ExcelGeneratorProcess.bos.ExcelGeneratorProcessBO;
import com.mx.dla.dda.reportes.generaxml.generaXMLimpl;
import com.mx.dla.global.bos.BaseBO;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReporteAcumulateBuysBO
extends BaseBO {
    @Autowired
    private ReporteAcumulateBuysDAO acumulatebuysDAO;
    @Autowired
    private ReporteConfiguracionDAO reporteconfiguracionDAO;
    @Autowired
    private ExcelGeneratorProcessBO excelGeneratorProcessBO;
    @Autowired
    private generaXMLimpl genXml;

    public List<acumulateBuysEstudiosDTO> obtenEstudios() throws Exception {
        List estudios = null;
        try {
            estudios = this.acumulatebuysDAO.obtenerEstudios();
            this.logger.debug("ReporteAcumulateBuys.obtenEstudios - [{}]", (Object)estudios);
        }
        catch (Exception e) {
            throw new TransaccionException("Error al obtener estudios en AcumulateBuys ::: ", e);
        }
        return estudios;
    }

    public List<acumulateBuysEstudiosDTO> obtenEstudiosConfig(String user) throws Exception {
        List estudios = null;
        try {
            estudios = this.acumulatebuysDAO.ObtenerEstudiosConfig(user);
            this.logger.debug("ReporteAcumulateBuys.obtenEstudiosConfig - [{}]", (Object)estudios);
        }
        catch (Exception e) {
            throw new TransaccionException("Error al obtener estudios configurados en AcumulateBuys ::: ", e);
        }
        return estudios;
    }

    public List<LinkedHashMap<String, String>> reporteAcumulateBuys(String origen, Long id_estudio, String typeAbono, String fechaInicio, String fechaFin) throws TransaccionException, IllegalArgumentException, IllegalAccessException, Exception {
        List acumulateBuys = null;
        String condicionEstatusCarga = "and cga.ESTATUS_CARGA = 'OK'";
        String clave_reporte = "RAB";
        boolean muestraTOTAL = false;
        boolean muestraMeses = false;
        List configuracion = null;
        HashMap fechaInicialSplit = FechaUtilerias.getFechaValores((String)fechaInicio, (String)"MM/yyyy");
        Long mesInicial = (Long)fechaInicialSplit.get("Month");
        Long anioInicial = (Long)fechaInicialSplit.get("Year");
        HashMap fechaFinalSplit = FechaUtilerias.getFechaValores((String)fechaFin, (String)"MM/yyyy");
        Long mesFinal = (Long)fechaFinalSplit.get("Month");
        Long anioFinal = (Long)fechaFinalSplit.get("Year");
        String sumatorias_mensuales = ",";
        String sumatotal = "(";
        String endsumatotal = ") as TOTAL";
        String meses_seleccionados = "";
        String meses_pivote = "";
        String monthPivot = "";
        SimpleDateFormat formater = new SimpleDateFormat("MM/yyyy");
        try {
            configuracion = this.reporteconfiguracionDAO.obtenerReporteConfiguracion(clave_reporte, id_estudio);
            Calendar beginCalendar = Calendar.getInstance();
            Calendar finishCalendar = Calendar.getInstance();
            beginCalendar.setTime(formater.parse(mesInicial + "/" + anioInicial));
            finishCalendar.setTime(formater.parse(mesFinal + "/" + anioFinal));
            if (origen.equals("cargaTransacciones")) {
                condicionEstatusCarga = "";
            }
            Integer index = 1;
            while (beginCalendar.before(finishCalendar) || beginCalendar.equals(finishCalendar)) {
                String month = StringUtils.leftPad((String)String.valueOf(beginCalendar.get(2) + 1), (int)2, (String)"0");
                String year = String.valueOf(beginCalendar.get(1));
                monthPivot = month;
                month = this.getmonth(month);
                sumatorias_mensuales = sumatorias_mensuales + "NVL(SUM(" + month + "), 0) as " + month + ",";
                sumatotal = sumatotal + "SUM(" + month + ") + ";
                meses_seleccionados = meses_seleccionados + "NVL(" + month + ", 0 ) as " + month + ",";
                meses_pivote = meses_pivote + "'" + monthPivot + year + "' as " + month + ",";
                beginCalendar.add(2, 1);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            for (LinkedHashMap item : configuracion) {
                for (Map.Entry pair : item.entrySet()) {
                    this.logger.info("configuracion {} : {}", pair.getKey(), pair.getValue());
                    if (!((String)pair.getKey()).equals("COLUMNA")) continue;
                    if (pair.getValue().equals("TOTAL")) {
                        muestraTOTAL = true;
                        continue;
                    }
                    if (!pair.getValue().equals("MES")) continue;
                    muestraMeses = true;
                }
            }
            sumatotal = sumatotal.substring(0, sumatotal.length() - 2) + endsumatotal;
            meses_seleccionados = meses_seleccionados.substring(0, meses_seleccionados.length() - 1);
            meses_pivote = meses_pivote.substring(0, meses_pivote.length() - 1);
            if (configuracion.isEmpty()) {
                muestraTOTAL = true;
                muestraMeses = true;
            }
            if (!muestraTOTAL && !muestraMeses) {
                sumatorias_mensuales = " ";
            } else if (muestraTOTAL && !muestraMeses) {
                sumatorias_mensuales = sumatotal = "," + sumatotal;
            } else if (!muestraTOTAL && muestraMeses) {
                sumatorias_mensuales = sumatorias_mensuales.substring(0, sumatorias_mensuales.length() - 1);
            } else if (muestraTOTAL && muestraMeses) {
                sumatorias_mensuales = sumatorias_mensuales + sumatotal;
            }
            this.logger.info("sumatorias_mensuales{}", (Object)sumatorias_mensuales);
            this.logger.info("sumatotal{}", (Object)sumatotal);
            this.logger.info("meses_seleccionados{}", (Object)meses_seleccionados);
            this.logger.info("meses_pivote{}", (Object)meses_pivote);
            acumulateBuys = this.acumulatebuysDAO.reporteAcumulateBuys(condicionEstatusCarga, sumatorias_mensuales, meses_seleccionados, meses_pivote, mesFinal, anioFinal, mesInicial, anioInicial, id_estudio, typeAbono);
            this.logger.info("{}", (Object)acumulateBuys);
        }
        catch (Exception e) {
            this.logger.error("Error-BO-reporteAcumulateBuys ::: {}", (Throwable)e);
        }
        return acumulateBuys;
    }

    public InputStream generaExcelAcumumlateBuys(String fileFileName, String origen, Long id_estudio, String typeAbono, String fechaInicio, String fechaFin) throws TransaccionException, IllegalArgumentException, IllegalAccessException, Exception {
        List acumulateBuys = null;
        String condicionEstatusCarga = "and cga.ESTATUS_CARGA = 'OK'";
        String clave_reporte = "RAB";
        boolean muestraTOTAL = false;
        boolean muestraMeses = false;
        List configuracion = null;
        HashMap fechaInicialSplit = FechaUtilerias.getFechaValores((String)fechaInicio, (String)"MM/yyyy");
        Long mesInicial = (Long)fechaInicialSplit.get("Month");
        Long anioInicial = (Long)fechaInicialSplit.get("Year");
        HashMap fechaFinalSplit = FechaUtilerias.getFechaValores((String)fechaFin, (String)"MM/yyyy");
        Long mesFinal = (Long)fechaFinalSplit.get("Month");
        Long anioFinal = (Long)fechaFinalSplit.get("Year");
        String tituloReporte = "Reporte Acumulate Buys";
        String archivoGen = "";
        String excelFileName = fileFileName + ".xlsx";
        fileFileName = fileFileName + ".xml";
        String sumatorias_mensuales = ",";
        String sumatotal = "(";
        String endsumatotal = ") as TOTAL";
        String meses_seleccionados = "";
        String meses_pivote = "";
        String monthPivot = "";
        SimpleDateFormat formater = new SimpleDateFormat("MM/yyyy");
        try {
            configuracion = this.reporteconfiguracionDAO.obtenerReporteConfiguracion(clave_reporte, id_estudio);
            Calendar beginCalendar = Calendar.getInstance();
            Calendar finishCalendar = Calendar.getInstance();
            beginCalendar.setTime(formater.parse(mesInicial + "/" + anioInicial));
            finishCalendar.setTime(formater.parse(mesFinal + "/" + anioFinal));
            if (origen.equals("cargaTransacciones")) {
                condicionEstatusCarga = "";
                tituloReporte = "Vista Previa Reporte Acumulate Buys";
            }
            Integer index = 1;
            while (beginCalendar.before(finishCalendar) || beginCalendar.equals(finishCalendar)) {
                String month = StringUtils.leftPad((String)String.valueOf(beginCalendar.get(2) + 1), (int)2, (String)"0");
                String year = String.valueOf(beginCalendar.get(1));
                monthPivot = month;
                month = this.getmonth(month);
                sumatorias_mensuales = sumatorias_mensuales + "NVL(SUM(" + month + "), 0) as " + month + ",";
                sumatotal = sumatotal + "SUM(" + month + ") + ";
                meses_seleccionados = meses_seleccionados + "NVL(" + month + ", 0 ) as " + month + ",";
                meses_pivote = meses_pivote + "'" + monthPivot + year + "' as " + month + ",";
                beginCalendar.add(2, 1);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            for (LinkedHashMap item : configuracion) {
                for (Map.Entry pair : item.entrySet()) {
                    this.logger.info("configuracion {} : {}", pair.getKey(), pair.getValue());
                    if (!((String)pair.getKey()).equals("COLUMNA")) continue;
                    if (pair.getValue().equals("TOTAL")) {
                        muestraTOTAL = true;
                        continue;
                    }
                    if (!pair.getValue().equals("MES")) continue;
                    muestraMeses = true;
                }
            }
            sumatotal = sumatotal.substring(0, sumatotal.length() - 2) + endsumatotal;
            meses_seleccionados = meses_seleccionados.substring(0, meses_seleccionados.length() - 1);
            meses_pivote = meses_pivote.substring(0, meses_pivote.length() - 1);
            if (configuracion.isEmpty()) {
                muestraTOTAL = true;
                muestraMeses = true;
            }
            if (!muestraTOTAL && !muestraMeses) {
                sumatorias_mensuales = " ";
            } else if (muestraTOTAL && !muestraMeses) {
                sumatorias_mensuales = sumatotal = "," + sumatotal;
            } else if (!muestraTOTAL && muestraMeses) {
                sumatorias_mensuales = sumatorias_mensuales.substring(0, sumatorias_mensuales.length() - 1);
            } else if (muestraTOTAL && muestraMeses) {
                sumatorias_mensuales = sumatorias_mensuales + sumatotal;
            }
            this.logger.info("sumatorias_mensuales{}", (Object)sumatorias_mensuales);
            this.logger.info("sumatotal{}", (Object)sumatotal);
            this.logger.info("meses_seleccionados{}", (Object)meses_seleccionados);
            this.logger.info("meses_pivote{}", (Object)meses_pivote);
            acumulateBuys = this.acumulatebuysDAO.reporteAcumulateBuys(condicionEstatusCarga, sumatorias_mensuales, meses_seleccionados, meses_pivote, mesFinal, anioFinal, mesInicial, anioInicial, id_estudio, typeAbono);
            this.logger.info("{}", (Object)acumulateBuys);
            archivoGen = this.genXml.generaXMLabuys(acumulateBuys, fileFileName, tituloReporte);
            this.logger.info("{}", (Object)acumulateBuys);
            this.logger.info("xml en la ruta {}", (Object)archivoGen);
        }
        catch (Exception e) {
            this.logger.error("Error-BO-reporteAcumulateBuys ::: {}", (Throwable)e);
        }
        return this.excelGeneratorProcessBO.generaExcelProceso(fileFileName, excelFileName);
    }

    public ArrayList<CeldaBaseDTO> obtenerHeader(String fechaInicio, String fechaFin, Long id_estudio) throws ParseException {
        String clave_reporte = "RAB";
        boolean muestraTOTAL = false;
        boolean muestraMeses = false;
        List configuracion = null;
        HashMap fechaInicialSplit = FechaUtilerias.getFechaValores((String)fechaInicio, (String)"MM/yyyy");
        Long mesInicial = (Long)fechaInicialSplit.get("Month");
        Long anioInicial = (Long)fechaInicialSplit.get("Year");
        HashMap fechaFinalSplit = FechaUtilerias.getFechaValores((String)fechaFin, (String)"MM/yyyy");
        Long mesFinal = (Long)fechaFinalSplit.get("Month");
        Long anioFinal = (Long)fechaFinalSplit.get("Year");
        ArrayList<CeldaBaseDTO> headers = new ArrayList<CeldaBaseDTO>();
        headers.add(new CeldaBaseDTO("ASSET_NAME", null, "Asset Name"));
        SimpleDateFormat formater = new SimpleDateFormat("MM/yyyy");
        Calendar beginCalendar = Calendar.getInstance();
        Calendar finishCalendar = Calendar.getInstance();
        beginCalendar.setTime(formater.parse(mesInicial + "/" + anioInicial));
        finishCalendar.setTime(formater.parse(mesFinal + "/" + anioFinal));
        configuracion = this.reporteconfiguracionDAO.obtenerReporteConfiguracion(clave_reporte, id_estudio);
        for (LinkedHashMap item : configuracion) {
            for (Map.Entry pair : item.entrySet()) {
                this.logger.info("configuracion {} : {}", pair.getKey(), pair.getValue());
                if (!((String)pair.getKey()).equals("COLUMNA")) continue;
                if (pair.getValue().equals("TOTAL")) {
                    muestraTOTAL = true;
                    continue;
                }
                if (!pair.getValue().equals("MES")) continue;
                muestraMeses = true;
            }
        }
        if (configuracion.isEmpty()) {
            muestraTOTAL = true;
            muestraMeses = true;
        }
        Integer index = 0;
        if (muestraMeses) {
            while (beginCalendar.before(finishCalendar) || beginCalendar.equals(finishCalendar)) {
                String month = MesesAnio.parse((String)("" + (beginCalendar.get(2) + 1))).getDesc();
                String year = String.valueOf(beginCalendar.get(1));
                headers.add(new CeldaBaseDTO("M" + (index + 1), null, month.substring(0, 3) + " - " + year));
                beginCalendar.add(2, 1);
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        if (muestraTOTAL) {
            headers.add(new CeldaBaseDTO("TOTAL", null, "TOTAL"));
        }
        return headers;
    }

    public String getmonth(String month) {
        if (month.equals("01")) {
            month = "ENE";
        }
        if (month.equals("02")) {
            month = "FEB";
        }
        if (month.equals("03")) {
            month = "MAR";
        }
        if (month.equals("04")) {
            month = "ABR";
        }
        if (month.equals("05")) {
            month = "MAY";
        }
        if (month.equals("06")) {
            month = "JUN";
        }
        if (month.equals("07")) {
            month = "JUL";
        }
        if (month.equals("08")) {
            month = "AGO";
        }
        if (month.equals("09")) {
            month = "SEP";
        }
        if (month.equals("10")) {
            month = "OCT";
        }
        if (month.equals("11")) {
            month = "NOV";
        }
        if (month.equals("12")) {
            month = "DIC";
        }
        return month;
    }
}

