var uploader   = new UploaderEX("cargaFeesDivLib"); // Se crear el objeto para
var datosSubir = null;						     // cargar archivos
var modificarPeriodo;
var indiceAnio;

var rentaLibreriaController = function($scope, $filter, $q, rentaPremiumService, terminosService, minimosService, revenueService, releaseService, precioService) {

	$scope.tablaMinGar     = null;
	$scope.tablaMinAnio    = null;	
	$scope.tablaPreciosLib = null;	
	$scope.tablaRevenueLib     = null;
	$scope.tablaRevenueBoxLib  = null;
	
	$scope.tipoMin         = null;
	$scope.formatos        = null;
	$scope.tipoRevenue     = null;
	
		
	/*
	terminosService.inicializarTablas("obtenerLibreria").then(function(data) {		
		$scope.inicializar(data.data.libreria);						
	});*/
		
	$scope.inicializar = function(data) {
						
		var res = minimosService.inicializarMinimos(data.minimos);
		$scope.tablaMinGar     = res.tablaMinGar;
		$scope.tablaMinAnio    = res.tablaMinAnio;
		$scope.tipoMin         = res.tipoMin;
		minimosService.inicializarDivMinimos($scope.tipoMin, "divMinCateLib", "divMinAnioLib");
		
		$scope.tablaPreciosLib     = precioService.crearTablaPreciosLibreria(data.datosPrecio,  data.paises, null);
		$scope.tablaRevenueLib     = revenueService.crearTablaRevenueGlobal(data.revenue.datosRevenue);
		$scope.tablaRevenueBoxLib  = revenueService.crearTablaRevenueBox(data.revenue.datosRevenueBox);
		 
		if(data.revenue.revenueGlobal)				
		   $scope.tipoRevenue         = "global";			 		

		if(data.revenue.revenueBox)
		{			 		
			$scope.tipoRevenue         = "box";
			var num = $scope.tablaMinGar.datos.length;
			for(var i =0; i<num; i++)
			{					 
			     $scope.tablaRevenueBoxLib.datos[i][0].editable = false;
			     $scope.tablaRevenueBoxLib.datos[i][1].editable = false;
			     $scope.tablaRevenueBoxLib.datos[i][2].editable = false;			     			     
			     $scope.tablaRevenueBoxLib.datos[i][4].editable = false;
			}								 			 	 			 
		}
		else
			$scope.tablaRevenueBoxLib.datos[0][2].valor    = 'MFTV/MFV';
		 
	};
		
	$scope.inicializarDivsMinimos = function() {		
		minimosService.inicializarDivMinimos($scope.tipoMin, "divMinCateLib", "divMinAnioLib");	
	};

	$scope.editarTablaMinGarantizados = function(operacion, index, encabezado) {		
		var res = minimosService.editarTablaMinGarantizados(operacion, index, encabezado, $scope.tablaMinGar, $scope.idsCat, $scope.idCatEli);
		$scope.tablaMinGar  = res.tablaMinGar;
		
		if($scope.tipoRevenue == 'box')
		{
			if(operacion == 'addRow')
			   this.actualizarBox();
			else if(operacion == 'removeRow')
			{
				$scope.tablaRevenueBoxLib.datos.splice(index, 1);
				this.actualizarBox();
			}			  			
		}			
	};

	$scope.editarTablaMinGarantizadosAnio = function(operacion, index, encabezado) {
		$scope.tablaMinAnioPre = minimosService.editarTablaMinGarantizadosAnio(operacion, index, encabezado, $scope.tablaMinAnioPre);		
	};
	
	$scope.actualizarMinCeldaLib = function(fila, columna, valor, metadatos) {			
		var res = minimosService.actualizarMinCelda(fila, columna, valor, $scope.tipoMin, $scope.tablaMinAnioPre, $scope.tablaMinGar);		
		$scope.tablaMinAnioPre = res.tablaMinAnio;
		$scope.tablaMinGar     = res.tablaMinGar;
		
		if($scope.tipoRevenue == 'box')
		{			
				if(columna == 2)
			   	   $scope.tablaRevenueBoxLib.datos[fila][columna].valor = valor.srcElement.value;
				else
				{
					if(columna >= 0 && columna < 2)
					{
						if (!isNaN(valor.srcElement.value) && parseFloat(valor.srcElement.value) > 0) 
						{				 
							if (valor.srcElement.value == "")
								$scope.tablaRevenueBoxLib.datos[fila][columna].valor = null;
							else
								$scope.tablaRevenueBoxLib.datos[fila][columna].valor = $filter('numDigMoneda')(valor.srcElement.value, 2);								
						}
						else 						
						   $scope.tablaRevenueBoxLib.datos[fila][columna].valor = null;	
					}														
				}		
		}		   
	};
						
	$scope.actualizarPrecioCelda = function(fila, columna, valor, metadatos) {		
		  var valClean =  $filter('numDigNormal')(valor.srcElement.value);		  
		  if(!isNaN(valClean) && parseFloat(valClean) > 0)
		  {
			  if(valClean == "")			  
				 $scope.tablaPreciosLib.datos[fila][columna].valor = null;    		  
			  else if(columna % 2 == 0)
	  	  {        		      			
	  		 $scope.tablaPreciosLib.datos[fila][columna].valor = $filter('numDigMoneda')(valor.srcElement.value,4); 
	  		 $scope.tablaPreciosLib.datos[fila][columna-1].valor = null;        		        			 
	  	  }    		    	
			  else
			  {
				 $scope.tablaPreciosLib.datos[fila][columna].valor = $filter('numDigMoneda')(valor.srcElement.value,4); 
	   		 $scope.tablaPreciosLib.datos[fila][columna+1].valor = null;
			  }
		  }
		  else    	      		        	  
			valor.srcElement.value = null;    				
	};
	
	$scope.actualizarRevenueCelda = function(fila, columna, valor, metadatos){		      	  
		$scope.tablaRevenueLib = revenueService.actualizarRevenueGlobalCelda(fila, columna, valor,$scope.tablaRevenueLib);       		    		      	    	      	
	};
	 	  
	$scope.actualizarRevenueBoxCelda = function(fila, columna, valor, metadatos){		      	  		  		  
		$scope.tablaRevenueBoxLib = revenueService.actualizarRevenueBoxCelda(fila, columna, valor, $scope.tablaRevenueBoxLib);
	};
	
	$scope.actualizarBox = function(){		          
		  $scope.tablaRevenueLib.datos    = [[{"valor":null},{"valor":null}]];		  		  
		  
		  if($scope.tipoMin == "categoria")
		  {			
			  var temp = [];
			  var temp1 = [];
			  if($scope.tablaRevenueBoxLib.datos.length > 0)			  
			  {
				  for(var i=0; i<$scope.tablaRevenueBoxLib.datos.length; i++)
				  {
					  temp.push($scope.tablaRevenueBoxLib.datos[i][3].valor);
					  temp1.push($scope.tablaRevenueBoxLib.datos[i][4].valor);
				  }			  				      
			  }			  
				 
			  $scope.tablaRevenueBoxLib.datos = [];
			  for(var i=0; i<$scope.tablaMinGar.datos.length; i++)
			  {
				  var fila = [];
				  for(var j=0; j<=2; j++)
				  {
					  fila.push({"valor" : $scope.tablaMinGar.datos[i][j].valor, "editable":false});				  
				  }  
				  
				  if(temp.length > 0)
				  {
					  fila.push({"valor" : temp[i], "editable":true});
					  fila.push({"valor" : temp1[i], "editable":false});
				  }
				  else
				  {
					  fila.push({"valor" : null, "editable":true});
					  fila.push({"valor" : null, "editable":false});  
				  }				  
				  $scope.tablaRevenueBoxLib.datos.push(fila);
			  } 			  			  			  
		  }		  

		  if($scope.tablaRevenueBoxLib.datos.length == 0)
			  $scope.tablaRevenueBoxLib.datos.push([{"valor":null,"editable":false},{"valor":null,"editable":false},{"valor":null,"editable":false},{"valor":null,"editable":false},{"valor":null,"editable":false}] );
	};
	 
	$scope.guardar = function() {
		var continuar = true;
		var tablas = [];
					
		   continuar = minimosService.validarMinimos($scope.tablaMinAnio, $scope.tablaMinGar, $scope.tipoMin, "tabMinCatLib", "tabAnioMinLib");
		
		if(continuar)
		   continuar = revenueService.validarRevenueBoxGlobal($scope.tipoRevenue , $scope.tablaRevenueLib, $scope.tablaRevenueBoxLib);
		
		if(continuar)		
			continuar = precioService.validaPrecioLib($scope.tablaPreciosLib);
		   						
		if(continuar)		
		   continuar = terminosService.validarTipoCambio();		
		
		if(continuar)
		{
			if($scope.tipoRevenue == "box" && $scope.tipoMin == "anio")
			{
				showError("No se puede tener revenue box con minimos por periodo.")
			    continuar = false;
			}			  
		}
		
		if (continuar) 
		{										
			var minimosG = {    anios   : minimosService.obtenerMinAniosGuardar($scope.tipoMin, "tabMinCatLib", "tabAnioMinLib"),			
					         minimosCa  : terminosService.crearMatriz($scope.tablaMinGar), 
					         minimosAn  : terminosService.crearMatriz($scope.tablaMinAnio),
					         tipoMin    : $scope.tipoMin
					        }
																
			var revenue  = { revenueGlobal: $scope.tipoRevenue == "global" ? true:false,
					         revenueBox   : $scope.tipoRevenue == "box" ? true:false, 
					         revenue      : terminosService.crearMatriz($scope.tablaRevenueLib), 
					         revenueB     : terminosService.crearMatriz($scope.tablaRevenueBoxLib)
					       };			
		
			var comun  =  {
							 tipoCambio  : $("#tipoCambio").val(),
							 inflacion   : $("#inflacionTx").val(),
							 fechaInicio : null,
							 fechaFin	 : null						
						  }
			
			var libreria = { revenue : revenue, minimos : minimosG, precio : terminosService.crearMatriz($scope.tablaPreciosLib), comun: comun };
						
																									
			var data     = { "libreria" : libreria, idContrato: $("#idCto").val() };
			
			
			terminosService.guardar(data, "guardarLibreria").then(function(data) {				   	    
					if (data.error != null)
						showError(data.error);
					else
					{
						showMessage("Se han guardado los datos de la seccion Libreria.");
						terminosService.inicializarTablas("obtenerLibreria").then(function(data) {							
							$scope.inicializar(data.data.libreria);						
						});
					}
            });

		}
	};

	//funciones para importar exceles					
	$scope.cargarDatos = function() {
		uploader.startUpload("modalCarga");
	};
	
	$scope.verificarDatos = function() {
		$('#modalImportarArchivoLib').modal('hide');
		if (datosSubir != null && datosSubir.datosMatriz != null) 
		{			
			if(uploader.tipoFees == "libreria" && uploader.operacion == "minimos")			
			   this.importarMinimos(datosSubir.datosMatriz);			
			if(uploader.tipoFees == "libreria" && uploader.operacion == "precio")
			   this.importarPrecio(datosSubir.datosMatriz);						
		}
	};
	
	$scope.abrirModalMinimos = function() {		
		terminosService.generaVarCarga("cargaFeesDivLib", "libreria", "minimos", "Lib");				
	};
	
	$scope.importarMinimos = function(data) {				
		var res = minimosService.importarExcelMin(data, $scope.tablaMinGar, $scope.idsCat, $scope.idCatEli);
		$scope.tablaMinGar = res.tablaMinGar;
		$scope.idsCat      = res.idsCat;		
		this.actualizarBox();
	};
								
	$scope.abrirModalPrecio = function() {
		terminosService.generaVarCarga("cargaFeesDivLib", "libreria", "precio", "Lib");		
	};
	
	$scope.importarPrecio = function(data) {		
		data.splice(0, 2);		
		for(var i=0; i<$scope.tablaPreciosLib.datos.length; i++)
		{
			for(var j=0; j<$scope.tablaPreciosLib.datos[0].length; j++)
			{
				if(j>0 && data[i].fila[j] != null && data[i].fila[j] != "")
					$scope.tablaPreciosLib.datos[i][j].valor = $filter('numDigMoneda')(data[i].fila[j],4);
				else
					$scope.tablaPreciosLib.datos[i][j].valor = data[i].fila[j];	
			}
		}																			
	};														
			
	//funcion para exportar excel
	$scope.exportarExcel = function(seccion, operacion, datos, encabezados) {
		var enc = [];					   			
		datos   = terminosService.crearMatriz(datos);				
						
		if(operacion == "min_cat" || operacion == "min_anio")
		   enc = minimosService.obtenerEncabezadosExportar(operacion, encabezados, "tabAnioMinPre");								   			
		else if(operacion == "precio")
		{			
			var temp = datos;
			var fila = [];				
			fila.push("Formato");
			
			for(var i=0; i<(datos[0].length-2)/2;i++)
			{
				fila.push("ML");
			    fila.push("Dolares");
			}
			
			var datos1 = [];
			datos1.push(fila);
			
			for(var i=0; i<temp.length;i++)
				datos1.push(temp[i]);
			datos = datos1;	
			
			enc[0] = "Precio por evento";				
			for(var i=0; i<encabezados.length;i++)
			{
				enc.push(encabezados[i].valor);
				enc.push("");
			}
		}		   
					    				
		terminosService.descargarArchivo(seccion, operacion, $("#idCto").val(), datos, enc).then(function(data) {  });				
	};
	
	$scope.setColspan = function(x) {
		return x.colspan;
	};
		
	$scope.modificarFechasAnioMinimos = function(indice, evento) {		
		var fecha;
		if($scope.tipoMin == "categoria")
		   fecha = evento.srcElement.textContent;
		else if($scope.tipoMin == "anio")
		  fecha = evento.srcElement.value;
				
		var cadenas = fecha.split("-");		
		$("#fechaPerInicioLib").val(cadenas[0]);
		$("#fechaPerFinLib")   .val(cadenas[1]);
		$("#modificarPeriodoLib").modal("show");
		modificarPeriodo = true;
		indiceAnio       = indice;
	};
	
	$scope.actualizarFechasMinimos = function() {						
		var fecha = $("#fechaPerInicioLib").val() + "-" + $("#fechaPerFinLib").val();			
		if($scope.tipoMin == "categoria")		
		   $("#tabMinCatLib").find("thead tr").find("th:nth-child(" + (indiceAnio + 1) + ")").text(fecha);				
		else if($scope.tipoMin == "anio")							
			$scope.tablaMinAnio.datos[indiceAnio][0].valor = fecha;									
		$("#modificarPeriodoLib").modal("hide");
	};
	
	$scope.agregarPeriodos = function() {		
		$("#chInflacionLib").prop('checked', false)
		$("#perNuevoLib").prop('checked', false)
		$("#perAntLib").prop('checked', false)
	    $("#fechaAgInicioLib").val('');
		$("#fechaAgFinLib").val('');		
		$("#agregarPeriodoLib").modal('show');						
	};

	$scope.agregarNuevoPeriodo = function() {		
		if($("#fechaAgInicioLib").val() == "" || $("#fechaAgFinLib").val() == "")		
		   $("#labErroAgLib").text("No se han ingresado las fechas del periodo").show();		
		else
		{						
			if($scope.tipoMin == "categoria")			
			   $scope.tablaMinGar  = minimosService.agregarPeriodoCategoria($scope.tablaMinGar, "fechaAgInicioLib", "fechaAgFinLib", "perAntLib", "perNuevoLib");								
			else			
			   $scope.tablaMinAnio = minimosService.agregarPeriodoAnio($scope.tablaMinAnio, "fechaAgInicioLib", "fechaAgFinLib", "perAntLib", "perNuevoLib");													
			$("#agregarPeriodoLib").modal("hide");	
		}			
	};				
};

registraController("rentaLibreriaController", rentaLibreriaController);