package com.mx.dla.dda.contrato.terminos.daos;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.mx.dla.dda.contrato.terminos.dtos.ContratoConsultaDTO;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoBD;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoServicioBD;

public interface TerminosDAO {

	public ContratoConsultaDTO consultaContrato(@Param("contrato")ContratoConsultaDTO param);
	public void actualizaContratoLimitesLicencia(ContratoConsultaDTO param);
	public void actualizaBroadviewContrato(ContratoConsultaDTO param);
	public List<ContratoConsultaDTO> consultaContratosPorEstudio(@Param("contrato")ContratoConsultaDTO param);
	
	public TerminoBD getTermino(Long idContrato);
	public List<TerminoBD> getTerminoPeriodicos(Long idContrato);
	public List<TerminoServicioBD> getTerminoTitulos(Long idContrato);
		
	public void eliminarTermino(Long idContrato);
	public void eliminarTerminoPago(Long idContrato);
	public void eliminarServicio(Long idContrato);
	
	public void guardarTermino(TerminoBD termino);
	public void guardarTerminoPago(@Param("pagos")List<TerminoBD> termino);	
	public void guardarServicioTitulo(@Param("servicios") List<TerminoServicioBD> servicios, @Param("idContrato")Long idContrato);
	
	public Integer getNumTitulos(Long idContrato);
}
