package com.mx.dla.admin.bos;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.admin.daos.MenuDAO;
import com.mx.dla.admin.dtos.MenuDTO;
import com.mx.dla.admin.dtos.PermisoDTO;
import com.mx.dla.global.bos.BaseBO;

@Component
public class MenuBO extends BaseBO {

	//private static Logger log = Logger.getLogger(ErrorAction.class);
	
	@Autowired	
	private MenuDAO menuDAO;
	
	public List<MenuDTO> armarArbolMenus( List<MenuDTO> menus, String idPerfil )
	{		
		if( menus != null ){
			
			for( MenuDTO menu:menus ){
				
				if( !menu.getTipoMenu().equals("0") ){					
					
					//-- Tipo 0 => Permiso				
					String idMenu = menu.getIdMenu();					
					
					if( idMenu != null ){
						
						List<MenuDTO> hijos = menuDAO.consultarHijos( idMenu, idPerfil );						
						
						if( hijos != null ){
							hijos = this.armarArbolMenus( hijos, idPerfil );
							menu.setHijos( hijos );
						}
					}
				}
			}
		}
		
		return menus;
	}
	
	public List<PermisoDTO> obtenPermisosPerfil(String idPerfil) {
		
		List<PermisoDTO> permisos = null;
		
		try {
			permisos = menuDAO.obtenerPermisos(idPerfil);
			//logger.debug("Permisos : [{}]", permisos);
		}catch(Exception ex) {
			logger.debug("[{}]", ex);
		}
		return permisos;
	}
	
}
