package com.mx.dla.dda.contrato.generales.bos;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.admin.dtos.UsuarioDTO;
import com.mx.dla.dda.contrato.amortizacion.constants.TipoAmortizacion;
import com.mx.dla.dda.contrato.amortizacion.daos.AmortizacionDAO;
import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.AreaDTO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.DetalleCatalogoContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.InfoDetalleContratoDTO;
import com.mx.dla.dda.contrato.generales.enums.Estatus;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.global.bos.BaseBO;

@Component
public class GeneralesBO extends BaseBO{

	@Autowired
	private GeneralesDAO generalesDAO;
	
	@Autowired
	private AmortizacionDAO amortizacionDAO;
	
	@Autowired
	private PoblarGeneralesBO poblarGeneralesBO;
	
	@Autowired
	private ExcelMapperContext excelMapperContext;
	
	@Autowired
	protected ExcelMapperTransform excelMapperTransform;
	
	@Autowired
	public DLARestClientFactory dlaRestClientFactory;
	
	public ContratoDTO registraContrato(Long campoEstudio, Long estatus, Long tipoOperacion, Long tipoContrato, 
			Date campoFechaInicio, Date campoFechaFin, Long apartado, String annios, String meses, 
			String tipoAmortizacion, Date fechaAutorizacion, String claveIva) {
		
		estatus = Estatus.Registro.getValor();
		ContratoDTO contratoNuevo = new ContratoDTO();
		Map<String, Object> paramNumeroContrato = new HashMap<String, Object>();
		boolean esVirtual = false;
		
		try{
			
			esVirtual = esEstudioVirtual(campoEstudio); //cambiar por la funcion que estara en Estudios BO
			
			contratoNuevo.setIdEstudio(campoEstudio);
			contratoNuevo.setIdEstatus(estatus);
			contratoNuevo.setIdTipoMovimiento(tipoOperacion);
			contratoNuevo.setIdTipoContrato(tipoContrato); 
			contratoNuevo.setIdApartado(null);
			contratoNuevo.setFechaFin(campoFechaFin);
			contratoNuevo.setFechaInicio(campoFechaInicio);
			contratoNuevo.setIdContratoOriginal(contratoNuevo.getIdContrato());
			contratoNuevo.setFechaAlta(new Date());
			contratoNuevo.setAnnios(annios);
			contratoNuevo.setMeses(meses);
			contratoNuevo.setIdApartado(apartado);
			contratoNuevo.setFechaAutorizacion(fechaAutorizacion);
			contratoNuevo.setClaveIva(claveIva);
			
			if(contratoNuevo.getIdTipoContrato() == 1){
				contratoNuevo.setAmortizable("SI");
			}else{
				contratoNuevo.setAmortizable("NO");
			}
			
			if (tipoContrato == 1) {
			
				if(tipoAmortizacion != null) {
					contratoNuevo.setTipoAmortizacion(TipoAmortizacion.EXCLUSIVIDAD.name());
				}else {
					contratoNuevo.setTipoAmortizacion(TipoAmortizacion.LINEAL.name());
				}
				
			}
			
			generalesDAO.registrarContrato(contratoNuevo);
			
			logger.debug(" idContrato desde insert : " + contratoNuevo.getIdContrato() + " tipoOperacion : " + tipoOperacion);
			
			paramNumeroContrato.put("idEstudio", campoEstudio);
			paramNumeroContrato.put("idTipo", tipoContrato);
			paramNumeroContrato.put("idContrato", contratoNuevo.getIdContrato());
			paramNumeroContrato.put("idMovimiento", tipoOperacion);
			paramNumeroContrato.put("numeroContrato","");
			
			if(esVirtual) {
				String ceros = "000000";
				ceros = ceros.substring(0, contratoNuevo.getIdContrato().toString().length());
				contratoNuevo.setNumeroContrato("ETV" + ceros + contratoNuevo.getIdContrato());
			} else {
				
				generalesDAO.llamarCrearNumeroContrato(paramNumeroContrato); //el return de la funcin regresa null, el nmero del contrato esta dentro del map
				logger.debug("Nmero de contrato recuperado : [{}]", paramNumeroContrato);
				contratoNuevo.setNumeroContrato((String) paramNumeroContrato.get("numeroContrato"));
			}
			
			logger.debug("Nmero de contrato seteado en ContratoDTO : [{}]", contratoNuevo.getNumeroContrato());
			generalesDAO.actualizaNumeroContrato(contratoNuevo.getIdContrato(), contratoNuevo.getNumeroContrato());
			
		}catch(Exception ex){
			logger.error("", ex);
		}
			logger.debug(contratoNuevo.toString());
		
		return contratoNuevo;
	}
	
	public void registraContratoProceso(Long idContrato) {
		logger.debug("En registraContratoProceso --  idContrato : [{}]", idContrato );
		try{
			amortizacionDAO.insertContratoProceso(idContrato, 0);
		}catch(Exception ex){
			logger.error("", ex);
		}
		
	}
	
	public String actualizaContratoProceso(Long idContrato, Integer valorAmortizacion){
		
		String mensaje = "OK";
		
		try{
			amortizacionDAO.updateContratoProceso(idContrato, valorAmortizacion);
		}catch(Exception ex){
			logger.error("", ex);
			mensaje = "Fallo al Actualizar";
		}
		
		return mensaje;
	}
	
	public ContratoDTO obtenContrato(Long idContrato){
		
		ContratoDTO contrato = null;
		
		try{
			contrato = generalesDAO.obtenerContrato(idContrato);
		}catch(Exception ex){
			logger.error("", ex);
		}
		
		return contrato;
	}
	
	public void actualizaContrato(Long campoContrato, Long campoEstudio, Date campoFechaInicio, Date campoFechaFin, 
									Long apartado, String annios, String meses, Date campoFechaAutorizacion, String indicador) {
		try{
			generalesDAO.actualizaContrato(campoContrato, campoEstudio, campoFechaInicio, campoFechaFin, apartado, annios, meses, campoFechaAutorizacion, indicador);
		}catch(Exception ex){
			logger.error("", ex);
		}
	}
	
	public void cambiarAddendum (Long idContrato, String numeroContrato) {
		numeroContrato = numeroContrato.substring(0, 9) + "A";
		generalesDAO.cambiarAddendum(idContrato, numeroContrato);
	}
	
	public boolean eliminaContrato(Long idContrato) {
		
		Long noError = 0L;
		boolean respuestaDeEliminar = false;
		
		Map<String, Object> parametroSP = new HashMap<String, Object>();
		
		parametroSP.put("idContrato", idContrato);
		parametroSP.put("noError", 0L);
		parametroSP.put("strError", "");
		
		try{
			//generalesDAO.llamarEliminaContrato(idContrato, noError, strError);
			generalesDAO.llamarEliminaContrato(parametroSP);
			logger.debug("noError : [{}]", parametroSP.get("noError"));
			logger.debug("strError : [{}]", parametroSP.get("strError"));
			noError = (Long) parametroSP.get("noError");
			
			if(noError >= 0) {
				respuestaDeEliminar = true;
			}
			
			
		}catch(Exception ex){
			logger.error("", ex);
		}
		
		//logger.debug("noError : " + noError + " strError: " + strError);
		
		return respuestaDeEliminar;
	}	
	
	public void cambiaEstudioVirtualContrato(Long idContrato, Long idEstudioOficial, Long idEstudio, boolean eliminaVirtual) {
		
		ContratoDTO contrato;
		Map<String, Object> paramNumeroContrato = new HashMap<String, Object>();
		
		try {
			
			generalesDAO.actualizaIdEstudioContrato(idContrato, idEstudioOficial);
			
			contrato = generalesDAO.obtenerContrato(idContrato);
			
			paramNumeroContrato.put("idEstudio", idEstudioOficial);
			paramNumeroContrato.put("idTipo", contrato.getIdTipoContrato());
			paramNumeroContrato.put("idContrato", contrato.getIdContrato());
			paramNumeroContrato.put("idMovimiento", contrato.getIdTipoMovimiento());
			paramNumeroContrato.put("numeroContrato","");
			
			generalesDAO.llamarCrearNumeroContrato(paramNumeroContrato);
			contrato.setNumeroContrato((String) paramNumeroContrato.get("numeroContrato"));
			
			generalesDAO.actualizaNumeroContrato(contrato.getIdContrato(), contrato.getNumeroContrato());
			
			//generalesDAO.pruebaActulizacion(idContrato, idEstudio);
			generalesDAO.actulizaEstudioTitulos(idEstudio, idEstudioOficial);
			
			if(eliminaVirtual) {
				generalesDAO.eliminaEstudioVirtual(idEstudio);
			}
			
			
			
		} catch(Exception ex) {
			logger.error("", ex);
		}
		
	}
	
	/*Function to EstudiosBO*/
	public boolean esEstudioVirtual(Long idEstudio) {
		String idSap = null;
		
		try {
			idSap = generalesDAO.obtenIdSapEstudio(idEstudio);
		} catch(Exception ex) {
			logger.error("", ex);
		}
		
		if(idSap == null) {
			return true;
		} else {
			return false;
		}
	}
	
	public String obtenerFechaSAP() {
		String fechaSAP = null;
		
		try {
			
			fechaSAP = generalesDAO.obtenerFechaSAP();
			
		}catch(Exception ex) {
			logger.error("Erro : [{}]", ex);
		}
		
		return fechaSAP;
	}
	
	public AreaDTO obtenerAreaPorExpediente(String expediente) {
		
		AreaDTO area = null;
		
		try {
			area = generalesDAO.obtenerAreaPorExpediente(expediente);
		}catch(Exception ex) {
			logger.error("Error : [{}]", ex);
		}
		
		return area;
	}
	
	public AreaDTO obtenerAreaPorOrdenWF(Integer ordenWF) {
		AreaDTO area = null;
		
		try {
			
			area = generalesDAO.obtenerAreaPorOrdenWF(ordenWF);
			
		}catch(Exception ex) {
			logger.error("Error : [{}]", ex);
		}
		
		return area;
	}
	
	public List<AreaDTO> obtenerAreasFinalizadoras() {
		List<AreaDTO> areas = null;
		
		try {
			areas = generalesDAO.obtenerAreasFinalizadoras();
		}catch(Exception ex) {
			logger.error("Error : [{}]", ex);
		}
		
		return areas;
	}
	
	public List<DetalleCatalogoContratoDTO> detalleContrato(Long idContrato){
		List<DetalleCatalogoContratoDTO> detalleCompleto = new ArrayList<DetalleCatalogoContratoDTO>();
		
		try {
			InfoDetalleContratoDTO detalleContrato = generalesDAO.obtenDetalleContrato(idContrato);
			List<DetalleCatalogoContratoDTO> catalogosContrato = generalesDAO.obtenDetalleCatalogos(idContrato);
			
			
			detalleCompleto.add(creaDetalleCatalogoContrato("Nmero Contrato", detalleContrato.getNumeroContrato()));
			detalleCompleto.add(creaDetalleCatalogoContrato("Estudio", detalleContrato.getDescripcionEstudio()));
			detalleCompleto.add(creaDetalleCatalogoContrato("Vigencia", poblarGeneralesBO.formateaFecha(detalleContrato.getFechaInicio()) + " - " + 
			poblarGeneralesBO.formateaFecha(detalleContrato.getFechaFin())));
			detalleCompleto.add(creaDetalleCatalogoContrato("Estatus", detalleContrato.getDescripcionEstatus()));
			detalleCompleto.add(creaDetalleCatalogoContrato("Apartado", detalleContrato.getDescripcionApartado()));
			
			if(detalleContrato.getFechaAutorizacion() != null) {
				detalleCompleto.add(creaDetalleCatalogoContrato("Fecha Autorizacin", poblarGeneralesBO.formateaFecha(detalleContrato.getFechaAutorizacion())));
			}
			
			for(DetalleCatalogoContratoDTO cc:catalogosContrato){
				detalleCompleto.add(cc);
			}
			
		}catch(Exception ex){
			logger.error("[{}]", ex);
		}
		
		return detalleCompleto;
	}
	
	public DetalleCatalogoContratoDTO creaDetalleCatalogoContrato(String tipo, String value) {
		DetalleCatalogoContratoDTO dcc = new DetalleCatalogoContratoDTO();
		dcc.setTipo(tipo);
		dcc.setLista(value);
		return dcc;
	}
	
	public InputStream h(Long idContrato) {
		
		byte[] bytesExcel = null;
		ExcelMapper mapper = null;
		InputStream is = null;
		
		try {
			mapper = excelMapperContext.getExcelMapper("detalleContrato");
			bytesExcel = excelMapperTransform.transformObjectToExcel(detalleContrato(idContrato), mapper, DetalleCatalogoContratoDTO.class);
			is =  new ByteArrayInputStream(bytesExcel);
		} catch (ExcelMapperException e) {
			logger.error("[{}]", e);
		} catch (IOException e) {
			logger.error("[{}]", e);
		}
		
		return is;
	}
	
	public void crearListaNuevaTransaccion(Long idContrato, Date fechaInicio) {
		try {
			generalesDAO.crearListaNuevaTransaccion(idContrato, fechaInicio);
		} catch (Exception ex) {
			logger.error("[{}]", ex);
		}
	}
	
	
	public void actualizaFechaInicioLista(Long idContrato, Date fechaInicio ) {
		try {
			logger.info("en Generales BO TIPO CONTRATO :" + idContrato + "|" + fechaInicio );
			
			//DateFormat formatoEntrada = new SimpleDateFormat("MM/yyyy");
			//Date date = formatoEntrada.parse(fecha);

			//SimpleDateFormat formatoAnio = new SimpleDateFormat("yyyy");
			//Long anio = Long.parseLong(formatoAnio.format(fechaInicio));
			
			
			//DateFormat  formatoEntrada = new SimpleDateFormat("01-01-yyyy");
			
			DateFormat formatoEntrada = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			String fecha = formatoEntrada.format(fechaInicio);
			logger.info("en Generales BO fechaInicio 11111111:" + fecha );
			
			SimpleDateFormat formatoFecha = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			Date fechaInicioLista = formatoFecha.parse(fecha);
			
			logger.info("en Generales BO fechaInicio 2222222:" + fechaInicioLista );
			
			generalesDAO.actualizaFechaLista(idContrato, fechaInicio);
				
		} catch (Exception ex) {
			logger.error("[{}]", ex);
		}
	}
	
}
