package com.mx.dla.dda.contrato.transaccion.minimoGarantizado.bos;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.transaccion.minimoGarantizado.daos.MinimoGarantizadoDAO;
import com.mx.dla.dda.contrato.transaccion.minimoGarantizado.dtos.MinGarantizadoDTO;

import com.mx.dla.global.bos.BaseBO;

@Component
public class MinimoGarantizadoBO extends BaseBO{
	
	@Autowired
	private MinimoGarantizadoDAO minimoGarantizadoDAO;
	
	@Autowired
	private GeneralesDAO generalesDAO;
	
	Long IdContratoOrig;
	
	public List<MinGarantizadoDTO> consultaInformacionMinimos(Long idContrato ) 
	{
		ContratoDTO contrato 	= generalesDAO.obtenerContrato(idContrato);
		IdContratoOrig 			= contrato.getIdContratoOriginal();
		
		return minimoGarantizadoDAO.consultaMinimoGarantizado( IdContratoOrig );
	}
	
}
