//alerts
function alertErrorValidaCarga() {
	swal("No se puede Validar Carga", "para Validar la carga elimine los Errores existentes...", "error");
}
function alertOk_validaCarga() {
	swal("Actualizacion Correcta!", "Validacion de carga realizada correctamente, pulsa OK para continuar...", "success");
}



//inicia angularjs
var uploader = new UploaderEX("cargaTransaccionesDiv"); //Objeto para carga de archivo

var cargaTransaccionesController = function($scope, $filter, $http, cargaTransaccionesService) {

	$('#divTablaResumenCarga').hide();
	$('#msjVoboCarga').hide();

	$scope.origenReporte = "MenuReportes";
	$scope.validaEstatusCarga = "NO";

	$scope.cargaPrincipal = '';
	$scope.total_registrados = '';
	$scope.total_cargados = '';
	$scope.total_error = '';
	$scope.fecha_vobo = '';
	$scope.mesCarga = null;
	$scope.rojo = { backgroundColor: '#cb2c25', color: 'white' };
	$scope.blanco = { backgroundColor: 'white' };
	$scope.amarillo = { backgroundColor: '#F2FA94 ' };
	$scope.rosa = { backgroundColor: '##FCB4B4' };
	$scope.botonSubirDisabled = true;
	$scope.botonAsociarTitulos = true;
	$scope.botonValidaCarga = true;
	$scope.botonMostrarVistaPrevia = true;
	$scope.botonExportarPrincipal = true;
	$scope.botonRecalculoPago = true;
	$scope.mensajeConfirmacion = "";
	$scope.vistaPrevia = [];
	$scope.detalleErroresCarga = [];
	$scope.json = '';

	/*
	 *  FUNCIONES JQGRID
	 * */
	function loadJS(src, callback) {
		var s = document.createElement('script');
		s.src = src;
		s.async = true;
		s.onreadystatechange = s.onload = function() {
			var state = s.readyState;
			if (!callback.done && (!state || /loaded|complete/.test(state))) {
				callback.done = true;
				callback();
			}
		};

		document.getElementsByTagName('head')[0].appendChild(s);

	}//Termina function loadJS( ... )

	function fFormatearFilas(pstSufijo) {
		var lstTablaFuente = "#" + gstNombreTabla;
		var lstDestino = "#" + gstNombreTabla + pstSufijo;

		//-- Resalta el total, es decir la primera fila
		$(lstDestino + ' tbody  tr#2 > td').css({ 'font-weight': 'bold', 'background-color': '#ffffcc' });
		$(lstDestino + ' tbody  tr#2 > td').css({ 'font-weight': 'bold', 'padding-left': '1px' });

	}//Termina function fFormatearFilas()        

	function fReloadGrid(pobJson) {
		jQuery("#" + gstNombreTabla).jqGrid('clearGridData');

		jQuery("#" + gstNombreTabla).jqGrid('setGridParam',
			{
				datatype: 'local',
				data: pobJson,
				rowNum: 999999,
				page: 1,
				loadComplete: function() {
					console.log('Terminando de cargar los datos');
					fFormatearFilas('');
					fFormatearFilas('_frozen');
				}
			}).trigger('reloadGrid');

	}//Termina function fReloadGrid( ... )

	/*
	 *  END FUNCIONES JQGRID__________________________________________
	 * */

	$scope.consultarCarga = function() {
		console.log("mesCarga:", $scope.mesCarga);
		if ($scope.mesCarga != null && $scope.mesCarga != '') {
			cargaTransaccionesService.consultarCarga($scope.mesCarga).then(function(data) {
				$scope.botonSubirDisabled = false;

				$scope.principalCargaTransacciones = data.principalCargaTransacciones;

				if (data.principalCargaTransacciones == null) {
					$scope.cargaTransacciones = [];
					$scope.infoHeadTransacciones = [];
					showError("El mes seleccionado no tiene carga asociada.");
					$('#divTablaResumenCarga').hide();
					$scope.botonAsociarTitulos = true;
					$scope.botonMostrarVistaPrevia = true;
					$scope.botonExportarPrincipal = true;
					$scope.botonRecalculoPago = true;
					$scope.botonValidaCarga = true;

				} else if (data.cargaTransacciones.length > 0) {
					$scope.botonAsociarTitulos = false;
					$scope.botonMostrarVistaPrevia = false;
					$scope.botonExportarPrincipal = false;
					$scope.botonRecalculoPago = false;

					$('#divTablaResumenCarga').show();

					$scope.infoHeadTransacciones = ["Pa\u00EDs", "Filial", "Transacciones", "Monto", "Pago", "% Asociaci\u00F3n"];
					$scope.principalCargaTransacciones = data.principalCargaTransacciones;
					cargaTransaccionesL = [];
					angular.forEach(data.cargaTransacciones, function(item, $index) {


						if (item.pais == null) {
							item.estilo = "rojo";
						} else {
							item.estilo = "blanco";
						}

						if (item.origen === "N" && item.filial == "SUBTOTAL")
							item.filial = "Subtotal Pay TV";
						if (item.origen === "P" && item.filial == "SUBTOTAL")
							item.filial = "Subtotal Plataforma";
						if (item.filial == "TOTAL")
							item.filial = "Total " + fechaMesAnnio($scope.mesCarga);

						cargaTransaccionesL.push(item);

					});

					$scope.cargaTransacciones = cargaTransaccionesL;
					$scope.obtenerResumenCargaTransacciones();

				} else {

					//aqui va el codigo en cas ode archivo TODO MAL
					$scope.obtenerResumenCargaIdTrans();

					$scope.cargaTransacciones = [];
					$scope.infoHeadTransacciones = [];
					$scope.botonAsociarTitulos = true;
					$scope.botonMostrarVistaPrevia = true;
					$scope.botonExportarPrincipal = true;
					$scope.botonRecalculoPago = true;
					$scope.botonValidaCarga = true;

				}
			});
		} else {
			showError("Seleccione un mes de carga.");
			$scope.botonSubirDisabled = true;
			$scope.botonAsociarTitulos = true;
			$scope.botonMostrarVistaPrevia = true;
			$scope.botonExportarPrincipal = true;
			$scope.botonRecalculoPago = true;
			$scope.botonValidaCarga = true;
			$('#divTablaResumenCarga').hide();

		}
	}


	$scope.obtenerResumenCargaTransacciones = function() {

		if ($scope.mesCarga != null && $scope.mesCarga != '') {
			cargaTransaccionesService.obtenerResumenCarga($scope.mesCarga).then(
				function(data) {

					$scope.resumenCarga(data.resumencarga);

				})
				.catch(function(error) {
					console.log("ERROR. al obtener Resumen Carga......");

				});
		} else {
			console.log("ERROR. al obtener resumen de la carga... fecha =" + $scope.mesCarga);
		}

	}

	$scope.obtenerResumenCargaIdTrans = function() {

		if ($scope.principalCargaTransacciones.idCarga != null) {

			cargaTransaccionesService.obtenerResumenCargaIdTrans($scope.principalCargaTransacciones.idCarga).then(
				function(data) {
					console.log("OK. se obtuvo Resumen Carga con id...");

					$scope.resumenCarga(data.resumencarga);

				})
				.catch(function(error) {
					console.log("ERROR. al obtener Resumen Carga......");

				});
		} else {
			console.log("ERROR. al obtener resumen de la carga... idCarga =" + $scope.principalCargaTransacciones.idCarga);
		}

	}


	$scope.cambiaronParametros = function() {
		$scope.botonSubirDisabled = true;
		$scope.botonAsociarTitulos = true;
	};



	/*Inicio funciones carga de archivo*/

	$scope.subirArchivo = function() {
		console.log("principalCarga", $scope.principalCargaTransacciones);
	}


	$scope.abrirModal = function() {

		if ($scope.principalCargaTransacciones != null) {

			if ($scope.principalCargaTransacciones.vobo == null)
				$scope.mensajeConfirmacion = "Los datos ya fueron cargados para [" + fechaMesAnnio($scope.mesCarga) + "]. Desea recargarlos?";
			else
				$scope.mensajeConfirmacion = "Los datos ya fueron cargados y validados para [" + fechaMesAnnio($scope.mesCarga) + "]. Desea recargarlos?";
			$('#modalConfirmacion').modal('show');
		} else {
			this.abrirModalCarga();
		}
	};

	$scope.abrirModalCarga = function() {
		$('#modalConfirmacion').modal('hide');
		uploader = new UploaderEX("cargaTransaccionesDiv");
		uploader.limpiaForma("idFormCargaAlgo");
		uploader.scope = $scope;
		uploader.mesCarga = $scope.mesCarga;
		if ($scope.principalCargaTransacciones != null) {
			uploader.idCarga = $scope.principalCargaTransacciones.idCarga;
		}
		$("#esperaDiv").html("");
		$("#modalCargarArchivo").modal("show");
	};


	$scope.cargarDatos = function() {
		uploader.startUpload("cargaTransaccionesDiv");
	};


	$scope.resumenCarga = function(cargaPrincipal) {
		$scope.cargaPrincipal = '';
		$scope.total_registrados = '';
		$scope.total_cargados = '';
		$scope.total_error = '';
		$scope.fecha_vobo = '';

		$scope.cargaPrincipal = cargaPrincipal;

		$scope.total_registrados = $scope.cargaPrincipal.TOTAL_CARGADOS;
		$scope.total_cargados = $scope.cargaPrincipal.TOTAL_REGISTROS;
		$scope.total_error = $scope.cargaPrincipal.TOTAL_ERROR;
		$scope.fecha_vobo = $scope.cargaPrincipal.vobo;

		//extrae el % de asoc para manejar boton "asociar Titulos"
		for (var k = 0; k < $scope.cargaTransacciones.length; k++) {
			if ($scope.cargaTransacciones[k].estilo == 'rojo') {
				$scope.porcentajeAsociacion = $scope.cargaTransacciones[k].asociacion;
			}
		}

		if ($scope.porcentajeAsociacion == '100 %') {
			$scope.botonAsociarTitulos = true;
		} else {
			$scope.botonAsociarTitulos = false;
			$scope.botonRecalculoPago = false;

		}

		if ($scope.total_error == 0 && $scope.porcentajeAsociacion == '100 %' && $scope.fecha_vobo == null) {
			$scope.botonValidaCarga = false;
		} else {
			$scope.botonValidaCarga = true;
		}
		if ($scope.fecha_vobo != null) {
			$scope.botonValidaCarga = true;
			$('#msjVoboCarga').show();
			$scope.botonDescargaFileError = true;
			$scope.botonRecalculoPago = true;
		} else {
			$('#msjVoboCarga').hide();
		}
		if ($scope.total_error > 0) {
			$scope.botonDescargaFileError = false;
			$scope.botonRecalculoPago = false;
			$('#bDescargaFileError').show();
		}
		if ($scope.total_error == 0) {
			$('#bDescargaFileError').hide();
		}

		$('#divTablaResumenCarga').show();

		console.log($scope.cargaPrincipal);

	};

	$scope.idReporteDeralleErrores = '';
	$scope.RecuperaIdReporteError = function(cargaPrincipal) {
		$scope.idReporteDeralleErrores = '';
		$scope.cargaPrincipal = '';

		$scope.cargaPrincipal = cargaPrincipal;

		$scope.idReporteDeralleErrores = $scope.cargaPrincipal.ID_CARGA;

	}

	/*Fin funciones carga de archivo*/

	/*funcion para recuperar informacion detalle de errores carga*/
	$scope.obtieneDetalleErroresCarga = function() {


		if ($scope.principalCargaTransacciones != null) {

			if ($scope.principalCargaTransacciones.idCarga != null) {
				cargaTransaccionesService.obtenerDetalleErroresCargaService($scope.mesCarga).then(function(data) {
					if (data.detalleErroresCarga.length > 0) {
						$scope.detalleErroresCarga = [];
						dErroresCarga = [];
						angular.forEach(data.detalleErroresCarga, function(item, $index) {

							dErroresCarga.push(item);

						});
						$scope.detalleErroresCarga = dErroresCarga;

						$('#bDescargaFileError').show();

					} else {
						$('#bDescargaFileError').hide();
					}

				});

			} else {
				$scope.detalleErroresCarga = [];
				showError("No se puede recuperar objeto con detalles de error carga.");
			}

		} else {
			showError("No se puede mostrar la vista previa.");
		}
	}


	/*Inicio funciones para mostrar la vista previa*/

	$scope.seMuestran = [];

	$scope.mostrarVistaPrevia = function() {


		$scope.seMuestran = []; //para limpiar los detalles que se estan mostrando

		if ($scope.principalCargaTransacciones != null) {

			if ($scope.principalCargaTransacciones.idCarga != null) {
				cargaTransaccionesService.obtenerVistaPrevia($scope.principalCargaTransacciones.idCarga).then(function(data) {
					$scope.infoHeadVistaPrevia = data.listaPaises;
					vistaPreviaL = [];
					jsonL = [];
					$scope.json = '';
					cargaTransaccionesService.obtenerJsonVistaPrevia(data.vistaPrevia.ruta).then(function(data) {
						angular.forEach(data.json, function(item, $index) {

							if (item.id > 3) {
								vistaPreviaL.push(item.cell);

								if (item.cell[0] != 'papa') {
									jsonL.push(item);
								}

							}


						});
						$scope.vistaPrevia = vistaPreviaL;//data.json;
						$scope.json = jsonL;
						$('#modalReporteEstudioPais').modal('show');
					});

				});

			} else {
				showError("No se puede mostrar la vista previa.");
			}

		} else {
			showError("No se puede mostrar la vista previa.");
		}
	}

	$scope.descargaExcel = function() {
		var url = contextPath + '/carga/transacciones/generaReporteVistaPreviaAction.action?idCarga=' + $scope.principalCargaTransacciones.idCarga;

		try { window.open(url); }
		catch (e) { showError("Ha ocurrido un error en la descarga: " + e.description); }
	}

	//rediseño vista previa jul2017
	$scope.vistaprevia = function() {
		$scope.seMuestran = []; //para limpiar los detalles que se estan mostrando

		if ($scope.principalCargaTransacciones != null) {

			if ($scope.principalCargaTransacciones.idCarga != null) {
				cargaTransaccionesService.obtenerVistaPrevia($scope.principalCargaTransacciones.idCarga).then(function(data) {
					console.log("nueva vistaprevia");
					console.log(data);
					$scope.infoHeadVistaPrevia = data.listaPaises;
					//itera vistaPrevia
					if (data.repvistaprevia.length > 0) {
						vistaPreviaL = [];
						angular.forEach(data.repvistaprevia, function(item, $index) {

							vistaPreviaL.push(item);

						});
						$scope.descargavistaPrevia = vistaPreviaL;

					} else {
						$scope.infoHeadTransacciones = [];
					}

					$scope.vistaPrevia = vistaPreviaL;
					console.log("vistaPrevia:", $scope.vistaPrevia);

					$('#modalReporteEstudioPais').modal('show');
				});

			} else {
				showError("No se puede mostrar la vista previa.");
			}

		} else {
			showError("No se puede mostrar la vista previa.");
		}
	}

	$scope.bandera = "false";
	$scope.recive = function(index, t) {

		if (t.AATIPO == 'papa') {
			$scope.bandera = !$scope.bandera;
			if ($scope.bandera) {
				$scope.seMuestran.push(t.AAACONCEPTO);
			}
			else {
				quitaDeSeMuestran(t.AAACONCEPTO);
			}
		}
	};

	$scope.estaEnSeMuestran = function(papa) {
		var seEncontro = false;

		angular.forEach($scope.seMuestran, function(item, $index) {
			if (papa === item)
				seEncontro = true;
		});

		return seEncontro;
	}

	$scope.esPapa = function(elemento) {
		return elemento === 'papa' || elemento === 'total' ? true : false;
	}

	function quitaDeSeMuestran(elemento) {
		var lt = [];
		angular.forEach($scope.seMuestran, function(item, $index) {
			if (item !== elemento)
				lt.push(item);
		});
		$scope.seMuestran = lt;
	}

	/*Fin funciones para mostrar la vista previa*/


	$scope.exportarPrincipal = function() {

		var dataIn = { "error": "from front front", "cargaTransacciones": $scope.cargaTransacciones }
		//debugger;
		cargaTransaccionesService.descargarArchivo(dataIn).then(function(data) {
			
		});
	}

	$scope.exportarVistaPrevia = function() {

		var dataIn2 = { "error": "from front front", "vistaPrevia": $scope.vistaPrevia }

		cargaTransaccionesService.descargarArchivoVistaPrevia(dataIn2).then(function(data) {

		});

	}

	$scope.exportarDetalleErrorCargaT = function() {
		var url = contextPath + '/carga/transacciones/descargaReporteErrorResumenCarga.action?mes=' + $scope.mesCarga;

		try { window.open(url); }
		catch (e) { showError("Ha ocurrido el siguiente error: " + e.description); }
	}

	$scope.exportarArchivoErrAsocTitulos = function() {
		//dataIn4
		cargaTransaccionesService.descargarArchivoErrAsocTitulosService($scope.principalCargaTransacciones.idCarga).then(function(data) {
		});

	}

	// funcion que recupera el listado de titulos a asociar clasificado por tipo de error...
	$scope.mostrarAsociarTitulos = function() {

		if ($scope.principalCargaTransacciones.idCarga != null && $scope.mesCarga != null) {
			cargaTransaccionesService.obtenerTitulosdelaCarga($scope.mesCarga).then(
				function(data) {

					//debugger;
					$scope.titulosCarga = data.titulosdelaCarga;

				});
			cargaTransaccionesService.obtenerSinIdBroadView($scope.principalCargaTransacciones.idCarga).then(
				function(data) {

					//debugger;
					$scope.sinIdBroadView = data.sinIdBroadView;
					if ($scope.sinIdBroadView.length > 0) {
						$('#BtnAsocTitGuardar').attr("disabled", false);
					} else {
						$('#BtnAsocTitGuardar').attr("disabled", true);
					}


				});
			cargaTransaccionesService.obtenerIdBroadViewNoExiste($scope.principalCargaTransacciones.idCarga).then(
				function(data) {

					//debugger;
					$scope.idBroadViewNoExiste = data.idBroadViewNoExiste;
				});
			cargaTransaccionesService.obtenerTituloyFilialNoExiste($scope.principalCargaTransacciones.idCarga).then(
				function(data) {

					//debugger;
					$scope.tituloyFilialNoExiste = data.tituloyFilialNoExiste;

				});
			cargaTransaccionesService.obtenerTituloyFilialNoExiste($scope.principalCargaTransacciones.idCarga).then(
				function(data) {

					//debugger;
					$scope.tituloyFilialNoExiste = data.tituloyFilialNoExiste;					

				});
			cargaTransaccionesService.obtenerTituloFueradePeriodo($scope.principalCargaTransacciones.idCarga).then(
				function(data) {

					//debugger;
					$scope.tituloFueradePeriodo = data.tituloFueradePeriodo;						

				});

			$('#modalAsociacionDeTitulos').modal('show');
		} else {
			showError("No se puede mostrar la vista previa.");
		}

	}

	//funcion para validar input's de asociacion de titulos de carga y hacer la actualizacion en BD
	$scope.actualizarIdBv = function() {
		$scope.idBv = "";
		$scope.idBv_comp = "";
		$scope.id_carga_titulo = "";
		$scope.nombreEstandar = "";
		$scope.msj = "";
		$scope.band = false;
		var indices = [];
		var cont = 0;

		//______________FUNCIONALIDAD PARA DETECTAR IDS BROAD VIEW REPETIDOS__________________
		for (var k = 0; k < $scope.sinIdBroadView.length; k++) {

			$scope.idBv = $('#' + $scope.sinIdBroadView[k].id_carga_titulo).val();
			for (var L = 0; L < $scope.sinIdBroadView.length; L++) {
				$scope.idBv_comp = $('#' + $scope.sinIdBroadView[L].id_carga_titulo).val();
				// comparamos ids 
				if ($scope.idBv != "") {
					if ($scope.idBv == $scope.idBv_comp) {
						cont++;
					}
				}
			}

			if (cont == 1) {
				//no es repetido
				cont = 0;
			} else if (cont > 1) {
				$scope.band = true;
				console.log("se encontraron elementos repetidos");
			}
		}

		//____________SE INICIA PROCESO DE ACTUALIZACION SOLO SI NO HUBO ELEMENTOS REPETIDOS____________
		for (var i = 0; i < $scope.sinIdBroadView.length; i++) {
			$scope.idBv = "";
			$scope.id_carga_titulo = "";
			$scope.nombreEstandar = "";
			$scope.idBv = $('#' + $scope.sinIdBroadView[i].id_carga_titulo).val();
			$scope.id_carga_titulo = $scope.sinIdBroadView[i].id_carga_titulo;
			$scope.nombreEstandar = $scope.sinIdBroadView[i].nombreEstandar;  		  			
			if ($scope.band == false) {
				if ($scope.idBv != "") {
					$scope.bandera_titulos = false;
					for (var j = 0; j < $scope.titulosCarga.length; j++) {
						//si el id proporcionado se encuentra en la lista de titulos se actualiza
						if ($scope.idBv == $scope.titulosCarga[j].idBv) {
							$scope.bandera_titulos = true;
						}

					}// fin busca id titulos en contratos		    	        

					if ($scope.bandera_titulos == true) {
						//SE LLAMA AL SERVICIO
						cargaTransaccionesService.actualizaIdBv($scope.idBv, $scope.id_carga_titulo, $scope.nombreEstandar).then(
							function(data) {		    	        				 

							})
							.catch(function(error) {
								console.log("error al intentar Actualizar IdBV...");

							});
					} else {
						$scope.msj = "Existen Id BroadView que no pertenecen a ningun t\u00E9tulo en contrato, por favor vuelva a abrir la ventana de asignaci\u00F3n para ver los errores que persisten.";
					}
				}
				//si el contenido del select esta vacio no hace nada...
			}// fin if idx -1
			else {
				i = $scope.sinIdBroadView.length + 1;
				alertError();
				$scope.band = true;
			}

		}//termina recorrido de selects	    

		if ($scope.msj == '' && $scope.band == false) {
			alertOk();
		} else if ($scope.msj != '') {
			alertWarn();
		}

	}


	$scope.rCalculoPago = function() {

		if ($scope.principalCargaTransacciones.idCarga != null) {

			cargaTransaccionesService.reCalculoPago($scope.principalCargaTransacciones.idCarga).then(
				function(data) {
					$scope.consultarCarga();
					alertOk_reCalculoPago();
				})
				.catch(function(error) {
					alertError_reCalculoPago();

				});
		} else {
			console.log("ERROR. al recalcular Pago...IdCarga=" + $scope.principalCargaTransacciones.idCarga);
		}

	}

	$scope.porcentajeAsociacion = '';
	$scope.validaCarga = function() {

		for (var k = 0; k < $scope.cargaTransacciones.length; k++) {
			if ($scope.cargaTransacciones[k].estilo == 'rojo') {
				$scope.porcentajeAsociacion = $scope.cargaTransacciones[k].asociacion;
			}
		}

		if ($scope.porcentajeAsociacion == '100 %' && $scope.total_error == '0') {
			//1. mensaje de confirmacion en modal
			$('#modalValidaCarga').modal('show');

		} else {
			//alert no se puede validar carga
			alertErrorValidaCarga();
		}

	}

	$scope.confirmaValidaCarga = function() {
		if ($scope.principalCargaTransacciones.idCarga != null) {
			$scope.CurrentDate = new Date();
			$scope.fecha_vobo = $scope.CurrentDate;
			cargaTransaccionesService.validaCargaService($scope.principalCargaTransacciones.idCarga).then(
				function(data) {

					$('#modalValidaCarga').modal('hide');
					alertOk_validaCarga();
					$scope.botonValidaCarga = true;
					$scope.botonAsociarTitulos = true;
					$scope.botonRecalculoPago = true;
					$('#msjVoboCarga').show();


				})
				.catch(function(error) {
					console.log("error al intentar validar la carga controller...");

				});

		} else {
			console.log("validar la carga controller...idCarga es NULL");
		}
	}

	$scope.descargaPlantillaExcel = function() {
		var url = contextPath + '/carga/transacciones/descargaPlantillaTransacciones.action';
		try { window.open(url); }
		catch (e) { showError("Ha ocurrido un error en la descarga de la plantilla: " + e.description); }
	}


	$scope.openModalAcumulateBuys = function() {

		$('#modalAcumulateBuys').modal('show');
		$scope.origenReporte = "cargaTransacciones";

	}

	$scope.openModalOveragePayments = function() {

		$('#modalOveragePayments').modal('show');
		$scope.origenReporte = "cargaTransacciones";

	}

	$scope.openModalCostPView = function() {

		$('#modalCostPView').modal('show');
		$scope.origenReporte = "cargaTransacciones";

	}

	//funciones comunes **************************************************************************************************

	$scope.disableElementsTransacciones = function() {
		//al cargar la pantalla transacciones se deshabilitan todos estos elementos para validar carga y permisos...

		$('#divTablaResumenCarga').hide();
		$('#bValidar').attr("disabled", true);
		$('#bVista').attr("disabled", true);
		$('#bExportar').attr("disabled", true);
		$('#bAsociar').attr("disabled", true);
		$('#bRecalculo').attr("disabled", true);
	}

	$scope.fmaFront = function(fecha) {

		return fecha != null ? fechaMesAnnio(fecha) : "";
	}

	function fechaMesAnnio(fecha) {
		var fsplited = fecha.split("/");
		if (fsplited.length == 3)
			return getMesStr(fsplited[0]) + " " + fsplited[2];
		else
			return fecha;
	}

	function getMesStr(mes) {
		var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
		return meses[parseInt(mes) - 1];
	}

};

registraController("cargaTransaccionesController", cargaTransaccionesController);