function eligeTemporadaCore() {

	var actionpath = null;
	var parametros = null;


	if ($("#peliculasSeries").val() != "" && $("#peliculasSeries").val() != "Todos") {
		parametros = { idEstudio: $("#estudio").val(), nombreUnico: $("#peliculasSeries").val() };

		actionpath = '/reporte/reporteCostPerView/obtenerTemporada.action';

		if (actionpath != null) {

			$.post(contextPath + actionpath, parametros,
				function(data) {

					if (data.errorMensaje != null)
						showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
					else {

						$('#temporadas')
							.find('option')
							.remove()
							.end()
							;

						if (data[0].desc == 'PELICULA') {
							$("#temporadas").append($('<option>', { value: "00", text: "PELICULA", selected: true }));
							$('#temporadas').prop('disabled', true);
						}
						else {
							$("#temporadas").append($('<option>', { value: "00", text: "Todos", selected: true }));

							for (var i = 0; i < data.length; i++)
								$("#temporadas").append($('<option>', {
									value: data[i].value,
									text: data[i].desc
								}));

							$('#temporadas').prop('disabled', false);

						}
					}


				}).fail(function() {
					console.log("error");
				});

		}

	} else {
		$("#temporadas").append($('<option>', { value: "00", text: "Todos", selected: true }));
		$('#temporadas').prop('disabled', true);
	}

}

var reporteCostoPerViewController = function($scope, $filter, utileriasService) {

	$scope.tipoReporte = null;
	$scope.tabla = null;
	$scope.aheader = null;
	$scope.bheader = null;
	$scope.estudios = [];
	$scope.estudio = null;
	$scope.hindex = null;
	$scope.paginationLimit = 100;
	$scope.totalDisplayed = $scope.paginationLimit;

	var nMeses = 1;
	var actualfecha = new Date();
	var year = (((actualfecha.getMonth() + 1) - nMeses) <= 0) ? (actualfecha.getFullYear() - 1) : actualfecha.getFullYear();
	var month = (((actualfecha.getMonth() + 1) - nMeses) <= 0) ? (12 + ((actualfecha.getMonth() + 1) - nMeses)) : ((actualfecha.getMonth() + 1) - nMeses);
	var date = ("00" + month).slice(-2) + '/' + year;

	$scope.fechaConsulta = date;

	$('#mes').datepicker({ dateFormat: 'mm/yy' });

	utileriasService.actionCall('/reporte/reporteCostPerView/inicializaCatalogos.action', {}).then(
		function(data) {
			if (data.errorMensaje != null)
				showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
			else {
				$scope.estudios = data.estudios;

				$("#estudio").append($('<option>', { value: "", text: "Todos", selected: true }));
				$("#peliculasSeries").append($('<option>', { value: "Todos", text: "Todos", selected: true }));
				$("#temporadas").append($('<option>', { value: "Todos", text: "Todos", selected: true }));

				for (var i = 0; i < $scope.estudios.length; i++)
					$("#estudio").append($('<option>', {
						value: $scope.estudios[i].value,
						text: $scope.estudios[i].desc
					}));

				$("#estudio").find('option').get(0).remove();
			}
		},
		function(error) {
			console.log("ERROR");
			showError("Ha ocurrido el siguiente error: " + error);
		}
	);

	$scope.muestraReporte = function(tipo, fecha, estudio) {
		if ($('#mes').val() == "")
			showError("Favor de elegir una fecha para el reporte");
		else if ($('#tipoReporte').val() == "")
			showError("Favor de elegir un tipo de reporte");
		else
			$scope.generaReporte(tipo, fecha, estudio);
	}

	$scope.generaReporte = function(tipo, fecha, estudio) {
		var parametros = { fecha: fecha };

		if ($("#estudio").val() != "")
			parametros = { fecha: fecha, idEstudio: $("#estudio").val(), nombreUnico: $("#peliculasSeries").val(), temporada: $("#temporadas").val() };

		var check = moment(fecha, 'MM/YYYY');
		var month = check.format('M');

		var size = 5;

		if (tipo == 'mensual')
			size = month;

		$scope.hindex = ((Number(size) + 1) * 3) + 1;
		$scope.totalDisplayed = $scope.paginationLimit;

		var actionpath = null;

		if (tipo == 'mensual')
			actionpath = '/reporte/reporteCostPerView/obtenerDatosReporteMensual.action';
		if (tipo == 'anual')
			actionpath = '/reporte/reporteCostPerView/obtenerDatosReporteAnual.action';

		if (actionpath != null)
			utileriasService.actionCall(actionpath, parametros).then(function(data) {

				if (data.errorMensaje != null)
					showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
				else {
					$scope.tabla = data.reporteVista.tabla;
					$scope.aheader = data.reporteVista.pheader;
					$scope.bheader = data.reporteVista.rheader;
				}

			},
				function(error) {
					showError("Ha ocurrido el siguiente error: " + error);
				});

	}

	$scope.descargaReporte = function(tipo, fecha, estudio) {

		var estudioParametro = "";
		if ($("#estudio").val() != "")
			estudioParametro = '&idEstudio=' + $("#estudio").val() + '&nombreUnico=' + $("#peliculasSeries").val() + '&temporada=' + $("#temporadas").val();

		var url = contextPath + '/reporte/reporteCostPerView/exportaReporte.action?tipoReporte=' + tipo + '&fecha=' + fecha + estudioParametro;

		try { window.open(url); }
		catch (e) { showError("Ha ocurrido el siguiente error: " + e.description); }

	}

	$scope.descargaZip = function(tipo, fecha, estudio) {

		if ($("#estudio").val() == "") {

			var url = contextPath + '/reporte/reporteCostPerView/exportaZip.action?tipoReporte=' + tipo + '&fecha=' + fecha;
			try { window.open(url); }
			catch (e) { showError("Ha ocurrido el siguiente error: " + e.description); }
		}

	}

	$scope.imprime = function(idDivPrintArea, fecha) {
		$("#" + idDivPrintArea).printThis({
			importCSS: true,
			importStyle: true,
			header: "<h3 style='width: 950px; font-weight:bold;'><img style='padding-right: 50px;' src='" + contextPath + "/design/img/common/Clarovideo.png'/>REPORTE COST PER VIEW AL " + utileriasService.getMes(fecha) + " - " + utileriasService.getAnio(fecha) + "</h3>"
		});


	}

	$scope.descargaExcel = function() {
		var url = contextPath + '/reporte/reporteOveragesYPayments/descargarExcel.action';

		try { window.open(url); }
		catch (e) { showError("Ha ocurrido el siguiente error: " + e.description); }
	}


	$scope.mostrarColumna = function(icolumna) {

		if (icolumna == $scope.hindex) return false;

		return true;
	}

	$scope.obtenEstilo = function(row, column, x, y, tlength) {



		var styles = {};


		if (row[$scope.hindex] == 1) styles['font-weight'] = "900";
		if (row[$scope.hindex] == 2) { styles['font-weight'] = "600"; styles['color'] = "blue"; }
		if (row[$scope.hindex] == 3) { styles['font-weight'] = "100"; styles['color'] = "blue"; }

		if (y == 0 && x < tlength - 1)
			styles['text-align'] = "left";
		else
			styles['text-align'] = "right";

		return styles;
	}

	$scope.esStringVacio = function(valor) {
		return valor ? valor.trim().length == 0 : true;
	}

	$scope.loadMore = function() {
		$scope.totalDisplayed += $scope.paginationLimit;
	};

	$scope.reporteZip = function() {
		return $scope.esStringVacio($scope.estudio);
	};

	$scope.eligeEstudio = function() {
		$scope.estudio = $("#estudio").val();
		$scope.tabla = null;
		$scope.aheader = null;
		$scope.bheader = null;
		$scope.peliculasSeries = $("#peliculasSeries").val();

		//		RFD -- seccion donde llama la funcionalidad de todos las series y peliculas del estudio
		var actionpath = null;
		var parametros = null;

		$('#peliculasSeries')
			.find('option')
			.remove()
			.end()
			;

		if ($("#estudio").val() != "") {
			parametros = { idEstudio: $("#estudio").val() };

			actionpath = '/reporte/reporteCostPerView/obtenerSeriesyPeliculas.action';

			if (actionpath != null)
				utileriasService.actionCall(actionpath, parametros).then(function(data) {

					if (data.errorMensaje != null)
						showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
					else {

						//borramos toda la informacion del select previo a la carga
						//comenzamos la carga

						$("#peliculasSeries").append($('<option>', { value: "Todos", text: "Todos", selected: true }));
						$("#temporadas").append($('<option>', { value: "Todos", text: "Todos", selected: true }));

						for (var i = 0; i < data.peliculas_series.length; i++)
							$("#peliculasSeries").append($('<option>', {
								value: data.peliculas_series[i].value,
								text: data.peliculas_series[i].desc
							}));
						$('#peliculasSeries').prop('disabled', false);
						$('#peliculasSeries').focus();

					}

				},
					function(error) {
						showError("Ha ocurrido el siguiente error: " + error);
					});

		} else {

			$("#peliculasSeries").append($('<option>', { value: "Todos", text: "Todos", selected: true }));
			$("#temporadas").append($('<option>', { value: "Todos", text: "Todos", selected: true }));

			$('#peliculasSeries').prop('disabled', true);
			$('#temporadas').prop('disabled', true);
		}

	}


	$scope.eligeTemporada = function() {
		$scope.estudio = $("#estudio").val();
		$scope.peliculaSerie = $("#peliculasSeries").val();
		$scope.tabla = null;
		$scope.aheader = null;
		$scope.bheader = null;
		//		RFD -- seccion donde llama la funcionalidad de todos las series y peliculas del estudio

		var actionpath = null;
		var parametros = null;

		if ($("#peliculasSeries").val() != "" && $("#peliculasSeries").val() != "Todos") {
			parametros = { idEstudio: $("#estudio").val(), nombreUnico: $("#peliculasSeries").val() };

			actionpath = '/reporte/reporteCostPerView/obtenerTemporada.action';

			$.post(contextPath + actionpath, parametros,
				function(data) {
					if (data.errorMensaje != null)
						showError("Ha ocurrido el siguiente error: " + data.errorMensaje);
					else {

						$('#temporadas')
							.find('option')
							.remove()
							.end()
							;

						if (data[0].desc == 'PELICULA') {
							$("#temporadas").append($('<option>', { value: "Todos", text: "PELICULA", selected: true }));
							$('#temporadas').prop('disabled', true);
						}
						else {
							$("#temporadas").append($('<option>', { value: "Todos", text: "Todos", selected: true }));

							for (var i = 0; i < data.length; i++)
								$("#temporadas").append($('<option>', {
									value: data[i].value,
									text: data[i].desc
								}));

							$('#temporadas').prop('disabled', false);

						}

					}

				}).fail(function() {
					console.log("error");
				});
		} else {
			$('#temporadas')
				.find('option')
				.remove()
				.end()
				;
			$("#temporadas").append($('<option>', { value: "Todos", text: "Todos", selected: true }));

			$('#temporadas').prop('disabled', true);
		}

	}

}

registraController("reporteCostoPerViewController", reporteCostoPerViewController);
