package com.mx.dla.dda.ncredito.general.actions;

import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.catalogos.dtos.EstudioDTO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;
import com.mx.dla.dda.contrato.generales.bos.PoblarGeneralesBO;
import com.mx.dla.dda.general.constants.SiNoOpcion;
import com.mx.dla.dda.ncredito.general.bos.NotaCreditoBO;
import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoDetalleDTO;
import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoGeneralDTO;
import com.opensymphony.xwork2.Action;

public class NotaCreditoAction extends BaseContratoAction {

	private static final long			  serialVersionUID = 1L;
	private ContratoNotaCreditoGeneralDTO notaCredito	   = new ContratoNotaCreditoGeneralDTO();

	@Autowired
	private NotaCreditoBO				  facturacionBO;

	@Autowired
	private PoblarGeneralesBO			  poblarGeneralesBO;

	private Long						  idEstudio;
	private Long						  idNotaCredito;
	private Integer						  aprobado;
	private String						  detalleCto;

	public String cargarNotaCreditoGeneral() {

		try {

			Long idNotaCredito = (Long) this.getSession().get("idNotaCredito");
			Long idEstudio = (Long) this.getSession().get("idEstudio");

			notaCredito = facturacionBO.cargaNotaCreditoGeneral(idEstudio, idNotaCredito);

			logger.info("cargaFacturaGeneral COMPLETE: " + notaCredito);

		}
		catch (Exception e) {
			logger.error("Ha ocurrido el siguiente error durante la consulta. {}", e);
			addActionError("Ha ocurrido el siguiente error durante la consulta: " + e.getMessage());
		}
		bajaInfoDeSession();
		return Action.SUCCESS;
	}

	public String cargarNotaCreditoDetalle() {

		try {

			List<ContratoNotaCreditoDetalleDTO> detalles = facturacionBO.cargaNotaCreditoDetalle(idEstudio, idNotaCredito, aprobado == 0 ? false : true);
			notaCredito.setContratos(detalles);

			logger.info("cargaFacturaDetalle COMPLETE: " + notaCredito);

		}
		catch (Exception e) {
			logger.error("Ha ocurrido el siguiente error durante la consulta. {}", e);
			addActionError("Ha ocurrido el siguiente error durante la consulta: " + e.getMessage());
		}

		bajaInfoDeSession();
		return Action.SUCCESS;
	}

	public String guardarNotaCredito() {

		try {
			idNotaCredito = facturacionBO.guardarFactura(notaCredito);
			aprobado = notaCredito.getApproved();
			facturacionBO.notificarServicioRest(notaCredito);
		}
		catch (Exception e) {
			logger.error("Ha ocurrido el siguiente error durante el guardado. {}", e);
			addActionError("Ha ocurrido el siguiente error durante el guardad " + e.getMessage());
		}

		// addActionMessage("La factura se ha guardado con exito");
		bajaInfoDeSession();
		return Action.SUCCESS;
	}

	public void bajaInfoDeSession() {
		this.setPmn((String) this.getSession().get("pmn"));
		this.setPmnReturn((String) this.getSession().get("pmnReturn"));
	}

	public ContratoNotaCreditoGeneralDTO getNotaCredito() {
		return notaCredito;
	}

	public void setNotaCredito(ContratoNotaCreditoGeneralDTO notaCredito) {
		this.notaCredito = notaCredito;
	}

	public List<EstudioDTO> getEstudios() {
		return poblarGeneralesBO.obtenListaEstudios();
	}

	public List<SiNoOpcion> getSiNoOpcion() {
		return Arrays.asList(SiNoOpcion.values());
	}

	public Long getIdEstudio() {
		return idEstudio;
	}

	public void setIdEstudio(Long idEstudio) {
		this.idEstudio = idEstudio;
	}

	public Long getIdNotaCredito() {
		return idNotaCredito;
	}

	public void setIdNotaCredito(Long idNotaCredito) {
		this.idNotaCredito = idNotaCredito;
	}

	public Integer getAprobado() {
		return aprobado;
	}

	public void setAprobado(Integer aprobado) {
		this.aprobado = aprobado;
	}

	public String getDetalleCto() {
		return detalleCto;
	}

	public void setDetalleCto(String detalleCto) {
		this.detalleCto = detalleCto;
	}

}